/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg.gsea;

import edu.mit.broad.genome.objects.GeneSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class GeneToGeneSetMap {
    private Map _map;

    private GeneToGeneSetMap(Map map) {
        this._map = map;
    }

    public int[] getGenesetIndicesForGene(String name) {
        return (int[])this._map.get(name);
    }

    public static GeneToGeneSetMap generateGeneToGenesetMap(GeneSet[] gsets) {
        HashMap<String, ArrayList<Integer>> map = new HashMap<String, ArrayList<Integer>>();
        for (int gsIdx = 0; gsIdx < gsets.length; ++gsIdx) {
            String[] genes = gsets[gsIdx].getMembersArray();
            for (int i = 0; i < genes.length; ++i) {
                ArrayList<Integer> l = (ArrayList<Integer>)map.get(genes[i]);
                if (l == null) {
                    l = new ArrayList<Integer>();
                    map.put(genes[i], l);
                }
                l.add(gsIdx);
            }
        }
        HashMap<String, int[]> indexMap = new HashMap<String, int[]>();
        for (String gene : map.keySet()) {
            ArrayList genesets = (ArrayList)map.get(gene);
            int[] indexArr = new int[genesets.size()];
            for (int j = 0; j < indexArr.length; ++j) {
                indexArr[j] = (Integer)genesets.get(j);
            }
            indexMap.put(gene, indexArr);
        }
        return new GeneToGeneSetMap(indexMap);
    }
}

