/*
 * Decompiled with CFR 0.152.
 */
package xapps.gsea;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jidesoft.swing.JideTabbedPane;
import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentDb;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.genome.swing.GuiHelper;
import edu.mit.broad.genome.swing.fields.GDirFieldPlusChooser;
import edu.mit.broad.genome.swing.fields.GFieldPlusChooser;
import edu.mit.broad.genome.viewers.AbstractViewer;
import edu.mit.broad.xbench.core.api.Application;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import org.genepattern.gsea.LeadingEdgeWidget;
import xapps.api.vtools.ParamSetFormForAFew;
import xtools.api.param.DirParam;
import xtools.api.param.Param;
import xtools.api.param.ReportCacheChooserParam;

public class LeadingEdgeReportViewer
extends AbstractViewer {
    public static final String NAME = "LeadingEdgeReportWidget";
    public static final Icon ICON = JarResources.getIcon("Lev16_b.gif");
    private ReportCacheChooserParam fReportParam;
    private DirParam fDirParam;
    private File curr_gseaResultDir;
    private JComponent fFiller;
    private LeadingEdgeReportViewer fInstance = this;
    private JideTabbedPane sharedTabbedPane;

    public LeadingEdgeReportViewer() {
        super(NAME, ICON, "Leading edge analysis");
        this.jbInit();
    }

    private void jbInit() {
        JButton bBuild = new JButton("Load GSEA Results");
        bBuild.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LeadingEdgeReportViewer.this.fReportParam.isSpecified() && LeadingEdgeReportViewer.this.fDirParam.isSpecified()) {
                    Application.getWindowManager().showMessage("Both cache and a brows'ed directory were specified. Only 1 can be specified. Delete one and try again");
                } else if (!LeadingEdgeReportViewer.this.fReportParam.isSpecified() && !LeadingEdgeReportViewer.this.fDirParam.isSpecified()) {
                    Application.getWindowManager().showMessage("No GSEA result folder was specified. Specify one and try again");
                } else {
                    SwingWorker<Object, Void> worker = new SwingWorker<Object, Void>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        protected Object doInBackground() throws Exception {
                            try {
                                Application.getWindowManager().getRootFrame().setCursor(Cursor.getPredefinedCursor(3));
                                if (LeadingEdgeReportViewer.this.fReportParam.isSpecified()) {
                                    LeadingEdgeReportViewer.this.curr_gseaResultDir = LeadingEdgeReportViewer.this.fReportParam.getReportDir();
                                } else {
                                    LeadingEdgeReportViewer.this.curr_gseaResultDir = LeadingEdgeReportViewer.this.fDirParam.getDir();
                                }
                                EnrichmentDb edb = ParserFactory.readEdb(LeadingEdgeReportViewer.this.curr_gseaResultDir, true);
                                if (LeadingEdgeReportViewer.this.log.isDebugEnabled()) {
                                    LeadingEdgeReportViewer.this.log.debug("edb: {}", (Object)edb.getQuickInfo());
                                }
                                boolean first = false;
                                if (LeadingEdgeReportViewer.this.sharedTabbedPane == null) {
                                    first = true;
                                    LeadingEdgeReportViewer.this.sharedTabbedPane = new JideTabbedPane();
                                    LeadingEdgeReportViewer.this.sharedTabbedPane.setHideOneTab(true);
                                    LeadingEdgeReportViewer.this.sharedTabbedPane.setTabEditingAllowed(true);
                                    LeadingEdgeReportViewer.this.sharedTabbedPane.setShowCloseButtonOnTab(true);
                                }
                                LeadingEdgeWidget josh_widget = new LeadingEdgeWidget(LeadingEdgeReportViewer.this.sharedTabbedPane, edb);
                                LeadingEdgeReportViewer.this.sharedTabbedPane.setSelectedComponent((Component)josh_widget.getViewAndSearchComponent());
                                if (first) {
                                    LeadingEdgeReportViewer.this.fInstance.remove(LeadingEdgeReportViewer.this.fFiller);
                                    LeadingEdgeReportViewer.this.fInstance.add((Component)LeadingEdgeReportViewer.this.sharedTabbedPane, "Center");
                                }
                                LeadingEdgeReportViewer.this.fInstance.revalidate();
                            }
                            catch (Throwable t) {
                                Application.getWindowManager().showError("Trouble loading enrichment database", t);
                            }
                            finally {
                                Application.getWindowManager().getRootFrame().setCursor(Cursor.getPredefinedCursor(0));
                            }
                            return null;
                        }
                    };
                    worker.execute();
                }
            }
        });
        this.fReportParam = new ReportCacheChooserParam("Select a GSEA result from the application cache");
        this.fDirParam = new DirParam("dir", "[ OR ] Locate a GSEA result folder from the file system", "[ OR ] Locate a GSEA report folder from the file system", false);
        Param[] params = new Param[]{this.fReportParam, this.fDirParam};
        StringBuffer colStr = LeadingEdgeReportViewer._createColStr();
        StringBuffer rowStr = LeadingEdgeReportViewer._createRowStr(params);
        PanelBuilder builder = ParamSetFormForAFew.createPanelBuilder(colStr, rowStr);
        CellConstraints cc = new CellConstraints();
        int rowcnt = 3;
        for (int i = 0; i < params.length; ++i) {
            GFieldPlusChooser chooser = params[i].getSelectionComponent();
            if (params[i].isFileBased() && chooser instanceof GDirFieldPlusChooser) {
                ((GDirFieldPlusChooser)chooser).getTextField().setBackground(ParamSetFormForAFew.LIGHT_GREEN);
            }
            JLabel label = new JLabel(params[i].getHtmlLabel_v3());
            ParamSetFormForAFew.enableToolTips(label, params[i]);
            builder.add((Component)label, cc.xy(1, rowcnt));
            builder.add((Component)chooser.getComponent(), cc.xy(3, rowcnt));
            rowcnt += 2;
        }
        builder.add((Component)new JLabel(""), cc.xy(1, rowcnt));
        builder.add((Component)bBuild, cc.xy(3, rowcnt));
        JPanel paramPanel = builder.getPanel();
        this.setLayout(new BorderLayout(10, 10));
        this.add((Component)paramPanel, "North");
        this.fFiller = GuiHelper.createWaitingPlaceholder();
        this.add((Component)this.fFiller, "Center");
        this.revalidate();
    }

    private static StringBuffer _createColStr() {
        return new StringBuffer("220dlu,      4dlu,        200dlu,   4dlu,  4dlu");
    }

    private static StringBuffer _createRowStr(Param[] params) {
        StringBuffer rowStr = new StringBuffer();
        rowStr.append("pref, 10dlu,");
        for (int i = 0; i < params.length + 1; ++i) {
            rowStr.append("pref, 5dlu");
            if (params.length == i - 1) continue;
            rowStr.append(",");
        }
        return rowStr;
    }

    @Override
    public JMenuBar getJMenuBar() {
        return EMPTY_MENU_BAR;
    }
}

