/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.core.api;

import edu.mit.broad.genome.alg.ComparatorFactory;
import edu.mit.broad.genome.parsers.ParseUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

public class XStore
extends AbstractListModel<String>
implements ComboBoxModel<String> {
    private static final Logger klog = LoggerFactory.getLogger(XStore.class);
    private File fFile;
    private List<String> fLinesByFileExt;
    private List<String> fLinesByLoadOrder;
    private int fSelIndex = 0;
    private boolean fLoaded;
    private AdditionDecider fDecider;

    protected XStore() {
    }

    protected void init(File file, AdditionDecider dec) {
        this.fFile = file;
        this.fLinesByFileExt = new ArrayList<String>();
        this.fLinesByLoadOrder = new ArrayList<String>();
        this.fDecider = dec;
    }

    private void load() {
        if (this.fLoaded) {
            return;
        }
        try {
            if (!this.fFile.exists()) {
                this.fFile.createNewFile();
            }
            List<String> ffn = ParseUtils.readFfn(this.fFile);
            this.fLinesByFileExt = new ArrayList<String>();
            for (int i = 0; i < ffn.size(); ++i) {
                String s = ffn.get(i);
                String ret = this.fDecider.addThis(s.trim());
                if (ret == null || ret.length() == 0) continue;
                this.fLinesByFileExt.add(ret);
                this.fLinesByLoadOrder.add(ret);
            }
            this.sort();
            this.fLoaded = true;
            this.fireContentsChanged(this, 0, this.fLinesByFileExt.size());
        }
        catch (Throwable t) {
            klog.error(MarkerFactory.getMarker((String)"FATAL"), "Could not init store: {}", (Object)this.fFile);
            klog.error(t.getMessage(), t);
        }
    }

    public void clearAll() {
        this.fLinesByFileExt.clear();
        this.fLinesByLoadOrder.clear();
        this.save();
    }

    private void add(String text) {
        String ret;
        if (!this.fLoaded) {
            this.load();
        }
        if (text == null) {
            return;
        }
        if ((text = text.trim()).length() == 0) {
            return;
        }
        if (text.endsWith("\n")) {
            text = text.substring(0, text.length() - 1);
        }
        if ((ret = this.fDecider.addThis(text)) != null && ret.length() != 0) {
            this.fLinesByLoadOrder.add(ret);
            this.fLinesByFileExt.add(ret);
            this.fireIntervalAdded(this, this.fLinesByFileExt.size() - 1, this.fLinesByFileExt.size() - 1);
        } else if (this.fLinesByLoadOrder.contains(text)) {
            this.fLinesByLoadOrder.remove(text);
            this.fLinesByLoadOrder.add(text);
        }
    }

    private void save() {
        try {
            if (!this.fFile.exists()) {
                this.fFile.createNewFile();
            }
            if (this.fFile.canWrite()) {
                FileUtils.writeLines((File)this.fFile, this.fLinesByLoadOrder);
            }
        }
        catch (Throwable t) {
            klog.error("Trouble saving store", t);
        }
    }

    public void trim(int maxNumLines) {
        if (!this.fLoaded) {
            this.load();
        }
        if (this.fLinesByLoadOrder.size() > maxNumLines) {
            int size = this.fLinesByFileExt.size();
            List<String> removedItems = this.fLinesByLoadOrder.subList(0, size - maxNumLines);
            this.fLinesByLoadOrder = this.fLinesByLoadOrder.subList(size - maxNumLines, size);
            this.fLinesByFileExt.removeAll(removedItems);
            this.save();
            this.fireIntervalRemoved(this, 0, size - maxNumLines);
        }
    }

    public void removeAndSave(List<String> items) {
        this.fLinesByLoadOrder.removeAll(items);
        for (String item : items) {
            int indexOf = this.fLinesByFileExt.indexOf(item);
            if (indexOf < 0) continue;
            this.fLinesByFileExt.remove(item);
            this.fireIntervalRemoved(this, indexOf, indexOf);
        }
        this.save();
    }

    private void sort() {
        Collections.sort(this.fLinesByFileExt, new ComparatorFactory.FileExtComparator());
    }

    public void addAndSave(String text) {
        this.add(text);
        this.save();
        this.sort();
        this.fireContentsChanged(this, 0, this.fLinesByFileExt.size());
    }

    public Collection<String> getLines() {
        return this.fLinesByFileExt;
    }

    public void refresh(String item) {
        if (this.fLinesByLoadOrder.contains(item)) {
            this.fLinesByLoadOrder.remove(item);
            this.fLinesByLoadOrder.add(item);
            this.save();
        }
    }

    @Override
    public int getSize() {
        if (!this.fLoaded) {
            this.load();
        }
        return this.fLinesByFileExt.size();
    }

    @Override
    public String getElementAt(int index) {
        return this.fLinesByFileExt.get(index);
    }

    public boolean contains(String str) {
        return this.fLinesByFileExt.contains(str);
    }

    @Override
    public String getSelectedItem() {
        if (this.fLinesByFileExt.size() == 0) {
            return null;
        }
        return this.fLinesByFileExt.get(this.fSelIndex);
    }

    @Override
    public void setSelectedItem(Object obj) {
        this.fSelIndex = this.fLinesByFileExt.indexOf(obj);
    }

    public static interface AdditionDecider {
        public String addThis(String var1);
    }
}

