/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.viewers;

import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.Printf;
import edu.mit.broad.genome.models.TemplateModel;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.swing.GuiHelper;
import edu.mit.broad.genome.viewers.AbstractViewer;
import java.awt.GridLayout;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;

public class PhenotypeViewer
extends AbstractViewer {
    public static final Icon ICON = JarResources.getIcon("Cls.gif");
    public static final String NAME = "PhenotypeViewer";
    private final Template fTemplate;

    public PhenotypeViewer(Template template) {
        super(NAME, ICON, template);
        this.fTemplate = template;
        this.jbInit();
    }

    private void jbInit() {
        this.setLayout(new GridLayout(1, 1));
        JTabbedPane tp = new JTabbedPane(3);
        tp.addTab("Phenotype Structure", new TableView(this.fTemplate));
        tp.addTab("Phenotype Text", new TextView(this.fTemplate));
        tp.addTab("Phenotype Info", new InfoView(this.fTemplate));
        this.add(tp);
    }

    public static class InfoView
    extends JPanel {
        private final JTextArea taFreeText;

        public InfoView(Template template) {
            this.taFreeText = new JTextArea(Printf.outs(template).toString());
            this.taFreeText.setEditable(false);
            GuiHelper.fill(this, new JScrollPane(this.taFreeText));
            this.revalidate();
        }
    }

    public static class TextView
    extends JPanel {
        private final JTextArea taFreeText;

        public TextView(Template template) {
            this.taFreeText = new JTextArea(template.getAsString(false));
            this.taFreeText.setEditable(false);
            GuiHelper.fill(this, new JScrollPane(this.taFreeText));
            this.revalidate();
        }
    }

    public static class TableView
    extends JPanel {
        private final JTable tableStructured;

        public TableView(Template template) {
            this.tableStructured = AbstractViewer.createTable(new TemplateModel(template), false, true);
            this.tableStructured.revalidate();
            this.tableStructured.repaint();
            GuiHelper.fill(this, AbstractViewer.createAlwaysScrollPane(this.tableStructured));
            this.revalidate();
        }
    }
}

