/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.genome.objects.ColorMap;
import edu.mit.broad.genome.objects.ColumnsImpl;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class SampleAnnot
extends AbstractObject {
    private List fSampleNames;
    private ColorMap.Columns fColorMap;

    public SampleAnnot(String name, List sampleNames) {
        this.initHere(name, sampleNames, null);
    }

    public SampleAnnot(String name, String[] sampleNames, ColorMap.Columns cm_opt) {
        if (sampleNames == null) {
            throw new IllegalArgumentException("Param sampleNames cannot be null");
        }
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < sampleNames.length; ++i) {
            names.add(sampleNames[i]);
        }
        this.initHere(name, names, cm_opt);
    }

    private void initHere(String name, List sampleNames, ColorMap.Columns cm_opt) {
        super.initialize(name);
        if (sampleNames == null) {
            throw new IllegalArgumentException("Param sampleNames cannot be null");
        }
        this.fSampleNames = sampleNames;
        this.fColorMap = cm_opt == null ? new ColumnsNull() : cm_opt;
    }

    public SampleAnnot cloneDeep(String[] useOnlyTheseSamples) {
        return new SampleAnnot(this.getName() + "resr_" + useOnlyTheseSamples.length, useOnlyTheseSamples, new ColumnsImpl(useOnlyTheseSamples));
    }

    @Override
    public String getQuickInfo() {
        return null;
    }

    public ColorMap.Columns getColorMap() {
        return this.fColorMap;
    }

    public int getNumSamples() {
        return this.fSampleNames.size();
    }

    class ColumnsNull
    implements ColorMap.Columns {
        ColumnsNull() {
        }

        @Override
        public Color getColor(String rowName, String colName) {
            return Color.WHITE;
        }

        @Override
        public int getNumRow() {
            return 1;
        }

        @Override
        public String getRowName(int row) {
            return "SampleName";
        }
    }
}

