/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.math;

import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.ScoreMode;
import edu.mit.broad.genome.math.SortMode;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.Dataset;
import gnu.trove.TIntObjectHashMap;

public class DatasetModed {
    private Dataset fOrigDataset;
    private TIntObjectHashMap fColIndexExtractedVectorMap;
    private ScoreMode fScoreMode;
    private SortMode fSort;
    private Order fOrder;

    public DatasetModed(Dataset orig, ScoreMode smode, SortMode sort, Order order) {
        if (orig == null) {
            throw new IllegalArgumentException("Param orig cannot be null");
        }
        if (smode == null) {
            throw new IllegalArgumentException("Param smode cannot be null");
        }
        this.fOrigDataset = orig;
        this.fScoreMode = smode;
        this.fColIndexExtractedVectorMap = new TIntObjectHashMap();
        this.fSort = sort;
        this.fOrder = order;
    }

    public int getNumCol() {
        return this.fOrigDataset.getNumCol();
    }

    public int getDim_orig() {
        return this.fOrigDataset.getDim();
    }

    public Vector getColumn_sorted(int col) {
        Object obj = this.fColIndexExtractedVectorMap.get(col);
        if (obj == null) {
            Vector v = this.fOrigDataset.getColumn(col);
            v = v.extract(this.fScoreMode);
            v.sort(this.fSort, this.fOrder);
            obj = v;
            this.fColIndexExtractedVectorMap.put(col, (Object)v);
        }
        return (Vector)obj;
    }
}

