/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg.markers;

import edu.mit.broad.genome.StandardException;
import edu.mit.broad.genome.alg.DatasetMetrics;
import edu.mit.broad.genome.alg.Metric;
import edu.mit.broad.genome.alg.RankedListGenerators;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.SortMode;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.math.XMath;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultDataset;
import edu.mit.broad.genome.objects.MetricWeightStruc;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.ScoredDataset;
import edu.mit.broad.genome.objects.Template;
import gnu.trove.TFloatArrayList;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PermutationTest {
    private final Logger log = LoggerFactory.getLogger(PermutationTest.class);
    private Dataset fDataset;
    private Template fTemplate;
    private int fNumMarkers;
    private int fNumPerms;
    private Metric fMetric;
    private SortMode fSort;
    private Order fOrder;
    private Map<String, Boolean> fMetricParams;
    private String fName;
    public static final float[] DEFAULT_SIG_LEVELS = new float[]{0.01f, 0.05f, 0.5f};
    private TFloatArrayList fSigLevels;
    private Matrix fUpSignificanceLevelsMatrix;
    private Matrix fDnSignificanceLevelsMatrix;
    private Template[] fRndTemplates;
    private ScoredDataset fRealScoredDataset;
    private TIntArrayList fMetricCrossOverRanks;
    private MetricWeightStruc[] fRndMetricWeightStrucs;
    private Matrix nMarkersUpMatrix;
    private Matrix nMarkersDnMatrix;
    private int fNumSetCalls;
    private RankedList fRealRankedList;

    public PermutationTest(String name, int numMarkers, int nperm, Metric metric, SortMode sort, Order order, Map<String, Boolean> metricParams, Dataset ds, Template template, float[] siglevels, boolean categorical) {
        if (numMarkers > ds.getNumRow()) {
            throw new IllegalArgumentException("numMarkers: " + numMarkers + " cannot be larger than dataset size: " + ds.getNumRow());
        }
        if (metric == null) {
            throw new IllegalArgumentException("Param metric cannot be null");
        }
        if (template == null) {
            throw new IllegalArgumentException("Param template cannot be null");
        }
        if (categorical) {
            if (!metric.isCategorical()) {
                throw new StandardException("As the phenotype choosen was categorical, only categorical metrics are allowed. Got: " + metric.getName(), 1010);
            }
            if (!template.isCategorical()) {
                throw new IllegalArgumentException("Only categorical templates allowed. Got: " + template.getName());
            }
        } else {
            if (!metric.isContinuous()) {
                throw new StandardException("As the phenotype choosen was continuous, only continuous class metrics are allowed. Got: " + metric.getName(), 1011);
            }
            if (!template.isContinuous()) {
                throw new IllegalArgumentException("Only continuous templates allowed. Got: " + template.getName());
            }
        }
        this.fName = name;
        this.fNumMarkers = numMarkers;
        this.fNumPerms = nperm;
        this.fMetric = metric;
        this.fSort = sort;
        this.fOrder = order;
        this.fMetricParams = metricParams;
        this.fDataset = ds;
        this.fTemplate = template;
        this.fSigLevels = new TFloatArrayList();
        if (siglevels == null || siglevels.length == 0) {
            this.fSigLevels.add(DEFAULT_SIG_LEVELS);
        } else {
            this.fSigLevels.add(siglevels);
        }
        DatasetMetrics dm = new DatasetMetrics();
        this.fRealScoredDataset = dm.scoreDataset(this.fMetric, this.fSort, this.fOrder, this.fMetricParams, this.fDataset, this.fTemplate);
        this.nMarkersUpMatrix = new Matrix(this.fNumMarkers, this.fNumPerms);
        this.nMarkersDnMatrix = new Matrix(this.fNumMarkers, this.fNumPerms);
        this.fRndTemplates = new Template[this.fNumPerms];
        this.fMetricCrossOverRanks = new TIntArrayList(this.fNumPerms);
        this.fRndMetricWeightStrucs = new MetricWeightStruc[this.fNumPerms];
    }

    public int getNumMarkers() {
        return this.fNumMarkers;
    }

    public String getName() {
        return this.fName;
    }

    public Metric getMetric() {
        return this.fMetric;
    }

    public Template getTemplate() {
        return this.fTemplate;
    }

    public float[] getSigLevels() {
        return this.fSigLevels.toNativeArray();
    }

    public Dataset getSigLevels(boolean up) {
        if (this.fUpSignificanceLevelsMatrix == null || this.fDnSignificanceLevelsMatrix == null) {
            throw new IllegalStateException("calcAndSetSignificanceLevels not yet called");
        }
        ArrayList<String> ranks = new ArrayList<String>();
        for (int i = 0; i < this.fNumMarkers; ++i) {
            ranks.add("rank_" + i);
        }
        ArrayList<String> siglevel = new ArrayList<String>();
        for (int i = 0; i < this.fSigLevels.size(); ++i) {
            siglevel.add("sig_" + this.fSigLevels.get(i));
        }
        if (up) {
            return new DefaultDataset(this.fName + "_up_rnd", this.fUpSignificanceLevelsMatrix, ranks, siglevel, null);
        }
        return new DefaultDataset(this.fName + "_dn_rnd", this.fDnSignificanceLevelsMatrix, ranks, siglevel, null);
    }

    private static float _getSignificanceLevel(Vector scores, float level, SortMode sort, Order order) {
        if (scores.getSize() == 0) {
            return Float.NaN;
        }
        scores.sort(sort, order);
        int index = (int)(level * (float)scores.getSize());
        return scores.getElement(index);
    }

    public void doCalc() {
        if (this.fNumSetCalls != this.fNumPerms) {
            throw new IllegalStateException("Not yet done: fNumSetCalls: " + this.fNumSetCalls + " nperm: " + this.fNumPerms);
        }
        if (this.fUpSignificanceLevelsMatrix != null) {
            this.log.warn("Already filled markers -- refilling ...");
        }
        int numSigLevels = this.fSigLevels.size();
        int numMarkers = this.nMarkersUpMatrix.getNumRow();
        this.fUpSignificanceLevelsMatrix = new Matrix(this.nMarkersUpMatrix.getNumRow(), numSigLevels);
        this.fDnSignificanceLevelsMatrix = new Matrix(this.nMarkersDnMatrix.getNumRow(), numSigLevels);
        for (int r = 0; r < numMarkers; ++r) {
            Vector v1 = this.nMarkersUpMatrix.getRowV(r);
            for (int c = 0; c < numSigLevels; ++c) {
                float level = PermutationTest._getSignificanceLevel(v1, this.fSigLevels.get(c), this.fSort, this.fOrder);
                this.fUpSignificanceLevelsMatrix.setElement(r, c, level);
            }
            Vector v2 = this.nMarkersDnMatrix.getRowV(r);
            for (int c = 0; c < numSigLevels; ++c) {
                float level = PermutationTest._getSignificanceLevel(v2, 1.0f - this.fSigLevels.get(c), this.fSort, this.fOrder);
                this.fDnSignificanceLevelsMatrix.setElement(r, c, level);
            }
        }
    }

    public void addRnd(Template rndTemplate, RankedList rndRl) {
        if (this.fNumSetCalls == this.fNumPerms) {
            throw new IllegalStateException("Already done fNumSetCalls: " + this.fNumSetCalls + " getNumPerms: " + this.fNumPerms);
        }
        this.fRndTemplates[this.fNumSetCalls] = rndTemplate;
        for (int r = 0; r < this.fNumMarkers; ++r) {
            this.nMarkersUpMatrix.setElement(r, this.fNumSetCalls, rndRl.getScore(r));
        }
        int p = rndRl.getSize() - 1;
        int cnt = 0;
        while (cnt < this.fNumMarkers) {
            this.nMarkersDnMatrix.setElement(cnt, this.fNumSetCalls, rndRl.getScore(p));
            ++cnt;
            --p;
        }
        for (int r = 0; r < rndRl.getSize(); ++r) {
            if (!XMath.isNegative(rndRl.getScore(r))) continue;
            this.fMetricCrossOverRanks.add(r + 1);
            break;
        }
        this.fRndMetricWeightStrucs[this.fNumSetCalls] = rndRl.getMetricWeightStruc();
        ++this.fNumSetCalls;
    }

    public RankedList getRankedList() {
        if (this.fRealRankedList == null) {
            this.fRealRankedList = RankedListGenerators.createBySorting(this.fRealScoredDataset, this.fSort, this.fOrder);
        }
        return this.fRealRankedList;
    }
}

