/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.alg.AlgUtils;
import edu.mit.broad.genome.math.RandomSeedGenerator;
import edu.mit.broad.genome.math.XMath;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.RankedList;
import java.util.ArrayList;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneSetGenerators {
    private static Logger klog = LoggerFactory.getLogger(GeneSetGenerators.class);

    private GeneSetGenerators() {
    }

    public static GeneSet[] createRandomGeneSetsFixedSize(int numRndGeneSets, RankedList rl, GeneSet gset, RandomSeedGenerator rst) {
        String prefix = NamingConventions.removeExtension(gset);
        int nmembers = gset.getNumMembers(rl);
        GeneSet[] rndgsets = new GeneSet[numRndGeneSets];
        for (int g = 0; g < numRndGeneSets; ++g) {
            int[] randomrowindices = XMath.randomlySampleWithoutReplacement(nmembers, rl.getSize(), rst);
            if (randomrowindices.length != nmembers) {
                throw new IllegalStateException("random indices generated: " + randomrowindices.length + " not equal to # members: " + nmembers);
            }
            HashSet<String> members = new HashSet<String>();
            for (int i = 0; i < nmembers; ++i) {
                members.add(rl.getRankName(randomrowindices[i]));
            }
            if (members.size() != nmembers) {
                klog.warn("Bad randomization -- repeated rnd members were made members: {} but wanted: {}", (Object)members.size(), (Object)nmembers);
            }
            rndgsets[g] = new GeneSet(prefix + "_" + g, members);
        }
        return rndgsets;
    }

    private static GeneSet[] removeGeneSetsSmallerThan(GeneSet[] gsets, int cutoff) {
        ArrayList<GeneSet> list = new ArrayList<GeneSet>(gsets.length);
        for (int i = 0; i < gsets.length; ++i) {
            if (gsets[i].getNumMembers() < cutoff) continue;
            list.add(gsets[i]);
        }
        return list.toArray(new GeneSet[list.size()]);
    }

    public static GeneSet[] removeGeneSetsSmallerThan(GeneSet[] gsets, int cutoff, RankedList rl) {
        GeneSet[] ogsets = GeneSetGenerators.removeGeneSetsSmallerThan(gsets, cutoff);
        ArrayList<GeneSet> list = new ArrayList<GeneSet>(ogsets.length);
        for (int i = 0; i < ogsets.length; ++i) {
            GeneSet gset = ogsets[i].cloneDeep(rl);
            int num = gset.getNumMembers();
            if (num >= cutoff) {
                list.add(gset);
            }
            if (i == 0 || i % 500 != 0) continue;
            System.out.println("Done removeGeneSetsSmallerThan: " + cutoff + " for: " + (i + 1) + " / " + ogsets.length);
        }
        return list.toArray(new GeneSet[list.size()]);
    }

    public static GeneSet[] removeGeneSetsLargerThan(GeneSet[] ogsets, int cutoff, RankedList rl) {
        ArrayList<GeneSet> list = new ArrayList<GeneSet>(ogsets.length);
        for (int i = 0; i < ogsets.length; ++i) {
            GeneSet gset = ogsets[i].cloneDeep(rl);
            int num = AlgUtils.getNumOfMembers(rl, gset);
            if (num <= cutoff) {
                list.add(gset);
            }
            if (i == 0 || i % 500 != 0) continue;
            System.out.println("Done removeGeneSetsLargerThan " + (i + 1) + " / " + ogsets.length);
        }
        return list.toArray(new GeneSet[list.size()]);
    }
}

