/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.lucene;

import java.io.Closeable;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;
import org.ujmp.core.collections.map.AbstractMap;
import org.ujmp.core.interfaces.Erasable;
import org.ujmp.core.objectmatrix.DenseObjectMatrix2D;
import org.ujmp.core.objectmatrix.ObjectMatrix2D;
import org.ujmp.core.util.SerializationUtil;
import org.ujmp.core.util.StringUtil;
import org.ujmp.core.util.io.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneMap<K, V>
extends AbstractMap<K, V>
implements Flushable,
Closeable,
Erasable {
    private static final long serialVersionUID = 8998898900190996038L;
    private static final String KEYSTRING = "KS";
    private static final String KEYDATA = "KD";
    private static final String VALUESTRING = "VS";
    private static final String VALUEDATA = "VD";
    private transient Directory directory = null;
    private transient IndexWriter indexWriter = null;
    private transient IndexSearcher indexSearcher = null;
    private static final int MAXSEARCHSIZE = 1000000;
    private boolean readOnly = false;
    private transient File path = null;
    private transient Analyzer analyzer = null;

    public LuceneMap() throws IOException {
        this(null, false);
    }

    public LuceneMap(String dir) throws IOException {
        this(new File(dir));
    }

    public LuceneMap(File dir) throws IOException {
        this(dir, false);
    }

    public LuceneMap(File path, boolean readOnly) throws IOException {
        this.readOnly = readOnly;
        this.path = path;
    }

    public synchronized Directory getDirectory() throws IOException {
        if (this.directory == null) {
            this.directory = FSDirectory.open((File)this.getPath());
        }
        return this.directory;
    }

    public synchronized File getPath() throws IOException {
        if (this.path == null) {
            this.path = File.createTempFile("lucene_map_", ".tmp");
            this.path.delete();
            this.path.mkdir();
        }
        return this.path;
    }

    @Override
    public synchronized void clear() {
        try {
            this.getIndexWriter().deleteAll();
        }
        catch (Exception e) {
            throw new RuntimeException("cannot clear index", e);
        }
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        try {
            Term term = new Term(KEYSTRING, LuceneMap.getUniqueString(key));
            return this.getIndexSearcher().getIndexReader().docFreq(term) > 0;
        }
        catch (Exception e) {
            throw new RuntimeException("could not search documents: " + key, e);
        }
    }

    @Override
    public synchronized boolean containsValue(Object value) {
        try {
            Term term = new Term(VALUESTRING, LuceneMap.getUniqueString(value));
            return this.getIndexSearcher().getIndexReader().docFreq(term) > 0;
        }
        catch (Exception e) {
            throw new RuntimeException("could not search documents: " + value, e);
        }
    }

    @Override
    public synchronized V get(Object key) {
        try {
            Term term = new Term(KEYSTRING, LuceneMap.getUniqueString(key));
            TermQuery query = new TermQuery(term);
            TopDocs docs = this.getIndexSearcher().search((Query)query, 1);
            if (docs.totalHits > 0) {
                ScoreDoc match = docs.scoreDocs[0];
                Document doc = this.getIndexSearcher().doc(match.doc);
                return (V)SerializationUtil.deserialize(doc.getBinaryValue((String)VALUEDATA).bytes);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("could not search documents: " + key, e);
        }
        return null;
    }

    public synchronized ObjectMatrix2D search(String searchString) {
        try {
            MultiFieldQueryParser p = new MultiFieldQueryParser(Version.LUCENE_47, new String[]{VALUESTRING}, this.getAnalyzer());
            Query query = p.parse(searchString);
            TopDocs docs = this.getIndexSearcher().search(query, 100);
            DenseObjectMatrix2D result = ObjectMatrix2D.Factory.zeros((long)docs.totalHits, 3L);
            for (int row = 0; row < docs.totalHits; ++row) {
                ScoreDoc match = docs.scoreDocs[row];
                Document doc = this.getIndexSearcher().doc(match.doc);
                result.setAsFloat(match.score, row, 0L);
                result.setAsObject(SerializationUtil.deserialize(doc.getBinaryValue((String)KEYDATA).bytes), row, 1L);
                result.setAsObject(SerializationUtil.deserialize(doc.getBinaryValue((String)VALUEDATA).bytes), row, 2L);
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("could not search documents: " + searchString, e);
        }
    }

    @Override
    public synchronized Set<K> keySet() {
        HashSet<Object> set = new HashSet<Object>();
        if (this.isEmpty()) {
            return set;
        }
        try {
            Term term = new Term(KEYSTRING, "*");
            WildcardQuery query = new WildcardQuery(term);
            TopDocs docs = this.getIndexSearcher().search((Query)query, 1000000);
            for (ScoreDoc sd : docs.scoreDocs) {
                Document d = this.getIndexSearcher().doc(sd.doc);
                set.add(SerializationUtil.deserialize(d.getBinaryValue((String)KEYDATA).bytes));
            }
            return set;
        }
        catch (Exception e) {
            throw new RuntimeException("could not search documents", e);
        }
    }

    private static String getUniqueString(Object o) throws IOException {
        if (o == null) {
            return "";
        }
        if (o instanceof String) {
            return (String)o;
        }
        return StringUtil.encodeToHex((Serializable)o);
    }

    @Override
    public synchronized V put(K key, V value) {
        try {
            Term term = new Term(KEYSTRING, LuceneMap.getUniqueString(key));
            Document doc = new Document();
            doc.add((IndexableField)new StringField(KEYSTRING, LuceneMap.getUniqueString(key), Field.Store.YES));
            doc.add((IndexableField)new StoredField(KEYDATA, SerializationUtil.serialize((Serializable)key)));
            doc.add((IndexableField)new StringField(VALUESTRING, LuceneMap.getUniqueString(value), Field.Store.YES));
            doc.add((IndexableField)new StoredField(VALUEDATA, SerializationUtil.serialize((Serializable)value)));
            this.getIndexWriter().updateDocument(term, (Iterable)doc);
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("could not add document: " + key, e);
        }
    }

    @Override
    public synchronized V remove(Object key) {
        try {
            Term term = new Term(KEYSTRING, LuceneMap.getUniqueString(key));
            this.getIndexWriter().deleteDocuments(term);
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("could not delete document: " + key, e);
        }
    }

    public Analyzer getAnalyzer() {
        if (this.analyzer == null) {
            this.analyzer = new StandardAnalyzer(Version.LUCENE_47);
        }
        return this.analyzer;
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    @Override
    public synchronized int size() {
        try {
            this.flush();
            if (this.indexSearcher != null) {
                return this.indexSearcher.getIndexReader().numDocs();
            }
            int size = this.getIndexWriter().numDocs();
            return size;
        }
        catch (Exception e) {
            throw new RuntimeException("could not count documents", e);
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        IndexWriter iw = this.getIndexWriter();
        iw.commit();
        iw.close(true);
        this.indexWriter = null;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.indexWriter != null) {
            this.indexWriter.close(true);
        }
        if (this.indexSearcher != null) {
            this.indexSearcher.getIndexReader().close();
        }
        if (this.indexWriter != null) {
            this.indexWriter.close(true);
            this.indexWriter = null;
        }
        if (this.indexSearcher != null) {
            this.indexSearcher.getIndexReader().close();
            this.indexSearcher = null;
        }
    }

    private synchronized IndexWriter getIndexWriter() {
        try {
            if (!this.readOnly && this.indexSearcher != null && this.indexSearcher.getIndexReader().getRefCount() > 0) {
                this.indexSearcher.getIndexReader().close();
                this.indexSearcher = null;
            }
            if (this.indexWriter == null) {
                if (DirectoryReader.indexExists((Directory)this.getDirectory())) {
                    if (!this.readOnly) {
                        if (IndexWriter.isLocked((Directory)this.getDirectory())) {
                            IndexWriter.unlock((Directory)this.getDirectory());
                        }
                        this.indexWriter = new IndexWriter(this.getDirectory(), new IndexWriterConfig(Version.LUCENE_47, this.getAnalyzer()));
                    }
                } else if (!this.readOnly) {
                    this.indexWriter = new IndexWriter(this.getDirectory(), new IndexWriterConfig(Version.LUCENE_47, this.getAnalyzer()));
                }
            }
            return this.indexWriter;
        }
        catch (Exception e) {
            throw new RuntimeException("could not prepare writher", e);
        }
    }

    private synchronized IndexSearcher getIndexSearcher() {
        try {
            if (!DirectoryReader.indexExists((Directory)this.getDirectory())) {
                this.getIndexWriter();
            }
            if (this.indexSearcher == null) {
                this.indexSearcher = new IndexSearcher((IndexReader)DirectoryReader.open((IndexWriter)this.getIndexWriter(), (boolean)true));
            }
            return this.indexSearcher;
        }
        catch (Exception e) {
            throw new RuntimeException("could not prepare reader", e);
        }
    }

    @Override
    public synchronized void erase() throws IOException {
        this.clear();
        this.close();
        FileUtil.deleteRecursive(this.path);
    }
}

