/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.jfreechart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.ujmp.core.Matrix;
import org.ujmp.core.util.StringUtil;
import org.ujmp.gui.MatrixGUIObject;
import org.ujmp.jfreechart.AbstractChartPanel;
import org.ujmp.jfreechart.ChartConfiguration;
import org.ujmp.jfreechart.XYSeriesCollectionWrapper;

public class MatrixChartPanel
extends AbstractChartPanel {
    private static final long serialVersionUID = 3661988250162505586L;

    public MatrixChartPanel(Matrix m) {
        this((MatrixGUIObject)m.getGUIObject());
    }

    public MatrixChartPanel(MatrixGUIObject guiObject) {
        this(guiObject, new ChartConfiguration());
    }

    public MatrixChartPanel(Matrix m, ChartConfiguration config) {
        this((MatrixGUIObject)m.getGUIObject(), config);
    }

    public MatrixChartPanel(MatrixGUIObject matrix, ChartConfiguration config) {
        super(matrix, config);
    }

    public synchronized void redraw() {
        NumberAxis axis;
        NumberAxis axis2;
        XYSeriesCollectionWrapper dataset = null;
        dataset = new XYSeriesCollectionWrapper(this.getMatrix());
        String title = this.getMatrix().getLabel();
        String xLabel = StringUtil.format(this.getMatrix().getMatrix().getDimensionLabel(0));
        String yLabel = null;
        this.setChart(ChartFactory.createXYLineChart((String)title, (String)xLabel, yLabel, (XYDataset)((XYDataset)dataset), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false));
        XYPlot plot = this.getChart().getXYPlot();
        if (this.getConfig().isLogScaleDomain()) {
            try {
                axis2 = new LogarithmicAxis(null);
                plot.setDomainAxis((ValueAxis)axis2);
            }
            catch (Exception e) {
                axis = new NumberAxis();
                plot.setDomainAxis((ValueAxis)axis);
            }
        } else {
            axis2 = new NumberAxis();
            plot.setDomainAxis((ValueAxis)axis2);
        }
        if (this.getConfig().isLogScaleRange()) {
            try {
                axis2 = new LogarithmicAxis(null);
                plot.setRangeAxis((ValueAxis)axis2);
            }
            catch (Exception e) {
                axis = new NumberAxis();
                plot.setRangeAxis((ValueAxis)axis);
            }
        } else {
            axis2 = new NumberAxis();
            plot.setRangeAxis((ValueAxis)axis2);
        }
        this.getChart().setTitle((String)null);
        this.getChart().setBackgroundPaint((Paint)Color.WHITE);
        plot.setDomainGridlinesVisible(false);
        plot.setRangeGridlinesVisible(false);
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        renderer.setBaseShapesVisible(false);
        renderer.setDrawSeriesLineAsPath(true);
        for (int i = 0; i < this.getMatrix().getColumnCount(); ++i) {
            renderer.setSeriesStroke(i, (Stroke)new BasicStroke(3.0f));
            plot.setRenderer(i, (XYItemRenderer)renderer);
        }
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setDomainGridlinePaint((Paint)Color.white);
        plot.setRangeGridlinePaint((Paint)Color.white);
        plot.setDomainCrosshairVisible(false);
        plot.setRangeCrosshairVisible(false);
        plot.getRangeAxis().setAutoRange(true);
        plot.getDomainAxis().setAutoRange(true);
        plot.getDomainAxis().setUpperMargin(0.0);
        this.setMouseZoomable(false);
    }
}

