/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.print;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.RepaintManager;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.ujmp.gui.print.PaperA4;

public class PrintPreviewPanel
extends JPanel
implements ActionListener,
ChangeListener {
    private static final long serialVersionUID = -3281742799998775189L;
    static final double INITIAL_SCALE_FACTOR = 1.0;
    Component targetComponent;
    PageFormat pageFormat = new PageFormat();
    double xScaleFactor = 1.0;
    double yScaleFactor = 1.0;
    BufferedImage bufferedImage;
    JPanel settingsPanel = new JPanel();
    PreviewPanel previewPanel;
    ButtonGroup orientationButtonGroup = new ButtonGroup();
    JRadioButton portraitButton;
    JRadioButton landscapeButton;
    JLabel xScaleLabel = new JLabel("X-Scale:", 2);
    JLabel yScaleLabel = new JLabel("Y-Scale:", 2);
    JButton print = new JButton("Print");
    JSpinner xsp;
    JSpinner ysp;
    SpinnerNumberModel snmx;
    SpinnerNumberModel snmy;
    int pcw;
    int pch;
    double wh;
    double hw;

    public PrintPreviewPanel(Component pc) {
        this.targetComponent = pc;
        this.setLayout(new BorderLayout());
        if (this.targetComponent.getWidth() < 1) {
            this.targetComponent.setSize(600, this.targetComponent.getHeight());
        }
        if (this.targetComponent.getHeight() < 1) {
            this.targetComponent.setSize(this.targetComponent.getWidth(), 400);
        }
        this.pcw = this.targetComponent.getWidth();
        this.pch = this.targetComponent.getHeight();
        this.bufferedImage = new BufferedImage(this.pcw, this.pch, 2);
        Graphics2D g = this.bufferedImage.createGraphics();
        this.targetComponent.paint(g);
        g.dispose();
        this.wh = (double)this.pcw / (double)this.pch;
        this.hw = (double)this.pch / (double)this.pcw;
        this.pageFormat.setPaper(new PaperA4());
        this.pageFormat.setOrientation(1);
        this.previewPanel = new PreviewPanel();
        this.snmx = new SpinnerNumberModel(1.0, 0.1, 10.0, 0.1);
        this.snmy = new SpinnerNumberModel(1.0, 0.1, 10.0, 0.1);
        this.xsp = new JSpinner(this.snmx);
        this.ysp = new JSpinner(this.snmy);
        this.xsp.addChangeListener(this);
        this.ysp.addChangeListener(this);
        this.portraitButton = new JRadioButton("Portrait");
        this.portraitButton.setActionCommand("1");
        this.portraitButton.setSelected(true);
        this.portraitButton.addActionListener(this);
        this.landscapeButton = new JRadioButton("Landscape");
        this.landscapeButton.setActionCommand("2");
        this.landscapeButton.addActionListener(this);
        this.orientationButtonGroup.add(this.portraitButton);
        this.orientationButtonGroup.add(this.landscapeButton);
        this.print.addActionListener(this);
        this.previewPanel.setBackground(Color.white);
        this.settingsPanel.setBorder(BorderFactory.createTitledBorder("Settings"));
        this.settingsPanel.setLayout(new GridBagLayout());
        GridBagConstraints c1 = new GridBagConstraints();
        c1.insets = new Insets(15, 45, 0, 5);
        c1 = this.buildConstraints(c1, 0, 0, 2, 1, 0.0, 0.0);
        this.settingsPanel.add((Component)this.portraitButton, c1);
        c1.insets = new Insets(2, 45, 0, 5);
        c1 = this.buildConstraints(c1, 0, 1, 2, 1, 0.0, 0.0);
        this.settingsPanel.add((Component)this.landscapeButton, c1);
        c1.insets = new Insets(25, 5, 0, 5);
        c1 = this.buildConstraints(c1, 0, 2, 1, 1, 0.0, 0.0);
        this.settingsPanel.add((Component)this.xScaleLabel, c1);
        c1.insets = new Insets(25, 5, 0, 35);
        c1 = this.buildConstraints(c1, 1, 2, 1, 1, 0.0, 0.0);
        this.settingsPanel.add((Component)this.xsp, c1);
        c1.insets = new Insets(5, 5, 0, 5);
        c1 = this.buildConstraints(c1, 0, 3, 1, 1, 0.0, 0.0);
        this.settingsPanel.add((Component)this.yScaleLabel, c1);
        c1.insets = new Insets(15, 5, 0, 35);
        c1 = this.buildConstraints(c1, 1, 3, 1, 1, 0.0, 0.0);
        this.settingsPanel.add((Component)this.ysp, c1);
        c1.insets = new Insets(5, 35, 25, 35);
        c1 = this.buildConstraints(c1, 0, 7, 2, 1, 0.0, 0.0);
        this.settingsPanel.add((Component)this.print, c1);
        this.add((Component)this.settingsPanel, "West");
        this.add((Component)this.previewPanel, "Center");
    }

    GridBagConstraints buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, double wx, double wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
        gbc.fill = 1;
        return gbc;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.portraitButton) {
            this.updatePreview();
        } else if (e.getSource() == this.landscapeButton) {
            this.updatePreview();
        } else if (e.getSource() == this.print) {
            this.print();
        }
    }

    public void updatePreview() {
        if (this.portraitButton.isSelected()) {
            this.pageFormat.setOrientation(1);
        } else if (this.landscapeButton.isSelected()) {
            this.pageFormat.setOrientation(0);
        }
        this.setScales();
        this.previewPanel.repaint();
    }

    public void setScales() {
        try {
            this.xScaleFactor = (Double)this.xsp.getValue();
            this.yScaleFactor = (Double)this.ysp.getValue();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void print() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        Book book = new Book();
        book.append(new PrintPage(), this.pageFormat);
        printerJob.setPageable(book);
        boolean doPrint = printerJob.printDialog();
        if (doPrint) {
            try {
                printerJob.print();
            }
            catch (PrinterException exception) {
                System.err.println("Printing error: " + exception);
            }
        }
    }

    public void stateChanged(ChangeEvent e) {
        this.updatePreview();
    }

    class PrintPage
    implements Printable {
        PrintPage() {
        }

        public int print(Graphics g, PageFormat format, int pageIndex) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.translate(format.getImageableX(), format.getImageableY());
            double dw = format.getImageableWidth();
            double dh = format.getImageableHeight();
            PrintPreviewPanel.this.setScales();
            double xScale = dw / ((double)PrintPreviewPanel.this.targetComponent.getWidth() * PrintPreviewPanel.this.xScaleFactor);
            g2d.scale(xScale, xScale);
            PrintPreviewPanel.this.targetComponent.paint(g2d);
            return 0;
        }

        public void disableDoubleBuffering(Component c) {
            RepaintManager currentManager = RepaintManager.currentManager(c);
            currentManager.setDoubleBufferingEnabled(false);
        }

        public void enableDoubleBuffering(Component c) {
            RepaintManager currentManager = RepaintManager.currentManager(c);
            currentManager.setDoubleBufferingEnabled(true);
        }
    }

    public class PreviewPanel
    extends JPanel {
        private static final long serialVersionUID = -868466190084572319L;

        public PreviewPanel() {
            this.setPreferredSize(new Dimension(640, 640));
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            int xOffsetPaper = (int)PrintPreviewPanel.this.pageFormat.getImageableX();
            int yOffsetPaper = (int)PrintPreviewPanel.this.pageFormat.getImageableY();
            int widthImage = (int)PrintPreviewPanel.this.pageFormat.getImageableWidth();
            int heightImage = (int)PrintPreviewPanel.this.pageFormat.getImageableHeight();
            int widthScaledImage = (int)Math.rint((double)widthImage * PrintPreviewPanel.this.xScaleFactor);
            int heightScaledImage = (int)Math.rint((double)widthImage * PrintPreviewPanel.this.hw * PrintPreviewPanel.this.yScaleFactor);
            g2d.setColor(Color.black);
            g2d.drawRect(0, 0, widthImage + 2 * xOffsetPaper, heightImage + 2 * yOffsetPaper);
            g2d.setColor(Color.lightGray);
            g2d.drawRect(xOffsetPaper, yOffsetPaper, widthImage, heightImage);
            Image image = PrintPreviewPanel.this.bufferedImage.getScaledInstance(widthScaledImage, heightScaledImage, 1);
            g2d.drawImage(image, xOffsetPaper, yOffsetPaper, this);
        }
    }
}

