/*
  Copyright Dave Bone 1998 - 2014 
  All Rights Reserved. 
  No part of this document may be reproduced without written consent from the author.
	
FILE:		  la_expr_lexical.lex
Dates:		  20 May 2005
Purpose:	  Grammar's lookahead boundary expression resolves
			  identifier, c-string and c-literal by the symbol table into
			  a T-in-stbl or rule-in-stbl. 
			  The operators '+' and '-' remain as raw characters.
*/
/@
@i "/usr/local/yacco2/copyright.w"
@** |la_expr_lexical| grammar.\fbreak
Verify the tokens ``identifier'', ``c-string'', and ``c-literal'' 
against the symbol table using their literal values as keys.
The found vocabulary symbol is then put into the token container
for |la_expr| grammar digestion.

Remember, the ``parallel-parser'' construct containing the lookahead expression 
comes before the Grammar's vocabulary definitions.
These  input token scraps are raw lexems without a symbol table translation
that now need symbol table evaluation.
@/

fsm	
(fsm-id "la_expr_lexical.lex"
,fsm-filename la_expr_lexical
,fsm-namespace NS_la_expr_lexical
,fsm-class Cla_expr_lexical{
  user-prefix-declaration
#include "yacco2_stbl.h"
  ***
}
,fsm-version "1.0",fsm-date "24 mar 2004",fsm-debug "false"
,fsm-comments "Lexer: 2nd stage lexing for lookahead: stripper...")
@"/usr/local/yacco2/compiler/grammars/yacco2_T_includes.T"

rules{
Rstripper  (
lhs{
  op
    using namespace NS_yacco2_k_symbols;
    ADD_TOKEN_TO_PRODUCER_QUEUE(*yacco2::PTR_LR1_eog__);   
    ADD_TOKEN_TO_PRODUCER_QUEUE(*yacco2::PTR_LR1_eog__);  
  ***
  }
){
  -> Rtoks eog
}

Rtoks  (){
  ->  Rtok
  ->  Rtoks Rtok 
}

Rtok  (){
  ->  "identifier" {
    op
          using namespace yacco2_stbl;
		T_sym_tbl_report_card report_card;
		find_sym_in_stbl(report_card,*sf->p1__->identifier()->c_str());
		if(report_card.action_ == T_sym_tbl_report_card::not_fnd){
		  CAbs_lr1_sym* sym = new Err_bad_term_in_la_expr;
          sym->set_rc(*sf->p1__,__FILE__,__LINE__);
          ADD_TOKEN_TO_ERROR_QUEUE(*sym);
          rule_info__.parser__->set_stop_parse(true);
          return;
		}
       ADD_TOKEN_TO_PRODUCER_QUEUE(*report_card.tbl_entry_->symbol_);
    ***
    }
  ->  "c-string" {
    op
          using namespace yacco2_stbl;
		T_sym_tbl_report_card report_card;
		find_sym_in_stbl(report_card,*sf->p1__->c_string()->c_str());
		if(report_card.action_ == T_sym_tbl_report_card::not_fnd){
		  CAbs_lr1_sym* sym = new Err_bad_term_in_la_expr;
          sym->set_rc(*sf->p1__,__FILE__,__LINE__);
          ADD_TOKEN_TO_ERROR_QUEUE(*sym);
          rule_info__.parser__->set_stop_parse(true);
          return;
		}
       ADD_TOKEN_TO_PRODUCER_QUEUE(*report_card.tbl_entry_->symbol_);
    ***
    }
  ->  "c-literal" {
    op
          using namespace yacco2_stbl;
		T_sym_tbl_report_card report_card;
		find_sym_in_stbl(report_card,*sf->p1__->c_literal()->c_str());
		if(report_card.action_ == T_sym_tbl_report_card::not_fnd){
		  CAbs_lr1_sym* sym = new Err_bad_term_in_la_expr;
          sym->set_rc(*sf->p1__,__FILE__,__LINE__);
          ADD_TOKEN_TO_ERROR_QUEUE(*sym);
          rule_info__.parser__->set_stop_parse(true);
          return;
		}
       ADD_TOKEN_TO_PRODUCER_QUEUE(*report_card.tbl_entry_->symbol_);
    ***
    }
 -> "+" {
    op
       ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p1__); 
    ***
    }
 -> "-" {
    op
       ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p1__); 
    ***
    }
  -> |+| {
/@
  Drain the swamp. 
  Accept the keywords, LR k constants, and raw characters.
@/
    op
    ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p1__);
    ***			
    } 
}
}// end of rules
