/*
  Copyright Dave Bone 1998 - 2014 
  All Rights Reserved. 
  No part of this document may be reproduced without written consent from the author.
	
FILE:		  cweb_put_k_into_ph.lex
Dates:		  31 Jan. 2006
Purpose:	  Put the prefix cweb comment into its phrase
*/
/@
@i "/usr/local/yacco2/copyright.w"
@** |cweb_put_k_into_ph| grammar.\fbreak
Puts the |cweb| comments into the appropriate parse phrase.
@/
fsm	
(fsm-id	"cweb_put_k_into_ph.lex",fsm-filename	cweb_put_k_into_ph,fsm-namespace NS_cweb_put_k_into_ph
,fsm-class Ccweb_put_k_into_ph
{
 user-declaration
    public:
    AST* cweb_marker_t_;
    bool* rules_phrase_seen_;
	void initialize(AST* Cweb_marker_t,bool* Rules_phrase_seen);
  ***
  user-implementation
	void Ccweb_put_k_into_ph::
	initialize(AST* Cweb_marker_t,bool* Rules_phrase_seen){
			cweb_marker_t_ = Cweb_marker_t;
			rules_phrase_seen_ = Rules_phrase_seen;
		}
  ***
}
,fsm-version	"1.0"	,fsm-date	"22 dec. 2005",fsm-debug	"false"
,fsm-comments	"Extract CWEB comments.")
@"/usr/local/yacco2/compiler/grammars/yacco2_T_includes.T"
rules{

Rcweb_put_k_into_phrase (){ 
  ->  "fsm-phrase"  { 
    op
      Ccweb_put_k_into_ph* fsm = 
	(Ccweb_put_k_into_ph*)rule_info__.parser__->fsm_tbl__;
      sf->p1__->add_cweb_marker(fsm->cweb_marker_t_);
    ***
    }
  ->  "parallel-parser-phrase"  { 
    op
      Ccweb_put_k_into_ph* fsm = 
	(Ccweb_put_k_into_ph*)rule_info__.parser__->fsm_tbl__;
      sf->p1__->add_cweb_marker(fsm->cweb_marker_t_);
    ***
    }
  ->  "terminals-phrase"  { 
    op
      Ccweb_put_k_into_ph* fsm = 
	(Ccweb_put_k_into_ph*)rule_info__.parser__->fsm_tbl__;
      sf->p1__->add_cweb_marker(fsm->cweb_marker_t_);
    ***
    }
  ->  "error-symbols-phrase"  { 
    op
      Ccweb_put_k_into_ph* fsm = 
	(Ccweb_put_k_into_ph*)rule_info__.parser__->fsm_tbl__;
      sf->p1__->add_cweb_marker(fsm->cweb_marker_t_);
    ***
    }
  ->  "rc-phrase"  { 
    op
      Ccweb_put_k_into_ph* fsm = 
	(Ccweb_put_k_into_ph*)rule_info__.parser__->fsm_tbl__;
      sf->p1__->add_cweb_marker(fsm->cweb_marker_t_);
    ***
    }
  ->  "lr1-k-phrase"  { 
    op
      Ccweb_put_k_into_ph* fsm = 
	(Ccweb_put_k_into_ph*)rule_info__.parser__->fsm_tbl__;
      sf->p1__->add_cweb_marker(fsm->cweb_marker_t_);
    ***
    }
  ->  "rules-phrase"  { 
    op
      Ccweb_put_k_into_ph* fsm = 
	(Ccweb_put_k_into_ph*)rule_info__.parser__->fsm_tbl__;
      sf->p1__->add_cweb_marker(fsm->cweb_marker_t_);
      (*fsm->rules_phrase_seen_) = true;
    ***
    }
  ->  "T-enum-phrase"  { 
    op
      Ccweb_put_k_into_ph* fsm = 
	(Ccweb_put_k_into_ph*)rule_info__.parser__->fsm_tbl__;
      sf->p1__->add_cweb_marker(fsm->cweb_marker_t_);
    ***
    }
}
}// end of rules
