/* MakeFonts -- compute the fonts listed in an external file.

   Copyright (C) 1994, 1995 Ralph Schleicher  */

/* This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Program arguments:

	files		input file names

   Program options:

        -l, --list	print commands only
        -v, --verbose	be verbose
        -?, --help	display a short help

   Environment variables:

	MAKEFONTS	search path for input files

   I make use of some OS/2 extensions of the Rexx language, here.  */


prog = 'MakeFonts';
exec = '@';

call rxfuncadd 'sysloadfuncs', 'rexxutil', 'sysloadfuncs';
call sysloadfuncs;

verbose = 0;
list = 0;

mag = 1.0;

data.proof.name = 'proof';
data.proof.verbatim = 'proof mode';
data.proof.directory = 'proof';
data.proof.resolution = 2601.72;
data.proof.default = 0;

modes = 'proof';
extra = '';


path = getenv('MAKEFONTS');
if path = '' then
  path = '.';
else
  path = translate(path, '\', '/');
call putenv '_MAKEFONTS', path;

parse arg all;
do while all \= ''
  parse var all option rest;
  if left(option, 1) \= '-' then
    leave;
  select
    when option = '-l' | option = '--list' then
      list = 1;
    when option = '-v' | option = '--verbose' then
      verbose = 1;
    when option = '-?' | option = '--help' then
      call usage;
    otherwise
      call usage option||": Unknown option";
  end;
  all = rest;
end;

files = all;
if files = '' then
  call usage;

call input 'modes';

do until files = ''
  parse var files file files;
  iter = modes;
  do while iter \= ''
    parse upper var iter mode iter;
    if data.mode.default then
      call process file;
  end;
  iter = extra;
  do while iter \= ''
    parse upper var iter mode iter;
    call process file;
  end;
  extra = '';
end;

exit 0;


process: procedure expose prog verbose list modes extra data. mode mag
  parse arg orig;
  file = os2name(orig);
  file = syssearchpath('_MAKEFONTS', file);
  if file = '' then
    call usage orig||': No such file or directory';
  call stream file, 'command', 'open read';
  if result \= 'READY:' then
    call usage file||': Access denied';
  do forever
    do forever
      line = strip(linein(file));
      if line = '' & lines(file) > 0 then
	iterate;
      leave;
    end;
    if line = '' then
      leave;
    parse upper var line command whatever;
    if command = 'MAKE' | command = 'INPUT' then
      line = 'call' line;
    interpret line;
  end;
  call stream file, 'command', 'close';
  return;

make: procedure expose prog verbose list modes extra data. mode mag
  parse arg fonts, magnification;
  if magnification = '' then
    magnification = mag;
  res = data.mode.resolution;
  name = data.mode.name;
  do while fonts \= ''
    parse var fonts font fonts;
    if list | verbose then
      say 'MakeTeXPK' font '0' res magnification name;
    if list then
      iterate;
    if verbose then
      say copies('-', 78);
    call 'MakeTeXPK' font '0' res magnification name;
    if verbose then
      say copies('=', 78);
  end;
  return;

input: procedure expose prog verbose list modes extra data. mode mag
  parse arg file;
  if verbose then
    say prog||':'file': Entering file';
  call process file;
  if verbose then
    say prog||':'file': Leaving file';
  return;

usage: procedure expose prog
  parse arg message;
  if message = '' then
    do
      say "Usage:  "||prog||" [-l] [-v] [-?] <file names>";
      say "";
      say "	-l, --list";
      say "		Don't execute commands, list them only.";
      say "	-v, --verbose";
      say "		Be a little bit verbose.";
      say "	-?, --help";
      say "		Display this help.";
    end;
  else
    say prog||':'||message;
  exit 1;

/* REXXLIB: getenv putenv os2name */

getenv: procedure
  parse arg name, default;
  variable = value(name, , 'OS2ENVIRONMENT');
  if variable = '' then
    variable = default;
  return variable;

putenv: procedure
  parse arg name, entry;
  return value(name, entry, 'OS2ENVIRONMENT');

toupper: procedure
  parse arg string;
  return translate(string,
    'ABCDEFGHIJKLMNOPQRSTUVWXYZ',
      'abcdefghijklmnopqrstuvwxyz');

tilde: procedure
  parse arg string, mode;
  home = getenv('HOME');
  if home = '' then
    return string;
  if mode = '' then
    mode = 'E';
  else
    mode = left(toupper(mode), 1);
  select
    when mode = 'E' then
      if left(string, 1) = '~' then
	string = home||substr(string, 2);
    when mode = 'R' then
      do
	home_len = length(home); string_len = length(string);
	if string_len >= home_len & left(string, home_len) = home then
	  string = '~'||substr(string, home_len + 1);
      end;
    otherwise
      nop;
  end;
  return string;

os2name: procedure
  parse arg name;
  name = tilde(name, 'e');
  name = translate(name, '\', '/');
  name = strip(name, 't', '\');
  return name;
