/* Generate make dependencies for bitmaps. */

#include <stdio.h>
#include <stdlib.h>
#include <dir.h>
#include <string.h>

FILE *f;

void do_files(char *message, char *sfx)
{
  struct ffblk fb;
  int i, n, end_p;
  char names[200][12], ptn[80];
  

  sprintf(ptn, "bitmap\\*.%s", sfx);
  fprintf(f, "\n# %s\n", message);

  for (n = 0, end_p = findfirst(ptn, &fb, 0); !end_p; ++n, end_p = findnext(&fb)) {
    *strchr(fb.ff_name, '.') = '\0';
    strlwr(fb.ff_name);
    strcpy(names[n], fb.ff_name);
  }
  qsort(names, n, sizeof names[0], (int(*)(const void*,const void*))strcmp);
  for (i = 0; i < n; ++i) 
    fprintf(f, "%s.c%s: %s.%s\n", names[i], 
    	    strlen(names[i]) > 5 ? "\t" : "\t\t",
	    names[i], sfx);
}

int main(void)
{
  f = fopen("bitmap.dep", "w");

  if (f == NULL)
    return 1;

  do_files("standard bitmaps", "sbm");
  do_files("custom bitmaps",   "bmp");
  do_files("cursor bitmaps",   "csr");

  fclose(f);
  return 0;
}
