/* chsize.c (rsxnt) -- Copyright (c) 1996-1997 Rainer Schnitker */

#include "rsxnt.h"

int __chsize (int fd, long newsize)
{
    EMXPROCESS *p = _rsxnt_get_process_ptr();
    DWORD newpos;

    if (fd >= N_FILES || fd < 0)
        return _rsxnt_errno(EBADF);
    if (p->file[fd].f_handle == INVALID_HANDLE_VALUE)
        return _rsxnt_errno(EBADF);

    newpos = SetFilePointer (p->file[fd].f_handle, newsize, NULL, FILE_BEGIN);
    if (newpos == 0xffffffff)
        return _rsxnt_get_last_errno();

    if (SetEndOfFile(p->file[fd].f_handle) == FALSE)
        return _rsxnt_get_last_errno();
    else
        return 0;
}
