#include <stdio.h>
#include <stdlib.h>
#include <process.h>
#include <signal.h>

void handler(int signal)
{
    printf("signal handler called");
}

static int make_tokens(char *argmem, char **argp)
{
    int i;
    int args=0;

    argp[args++] = argmem;
    for (i = 0; *(argmem + i) != 0; i++)
	if (*(argmem + i) == ' ') {
	    *(argmem + i) = 0;
	    if (*(argmem + i + 1) == ' ')
		continue;
	    if (*(argmem + i + 1) == 0)
		break;
	    argp[args++] = (argmem + i + 1);
	}
    argp[args] = 0;

    return args;
}

int main (int argc, char * const *argv, char * const *env)
{
    char in[80];
    char *args[80];
    int i, t, p;

    signal(SIGCLD, handler);

    for (;;) {
	printf("program arg1 arg2 .. :");
	gets(in);
	if (!*in || strcmp("exit",in) == 0)
	    break;
	make_tokens(in,&args);
	i = spawnvpe(P_NOWAIT,in,args,env);
	printf("return spawn = %d\n",i);
	p = wait(&t);
	if (p == -1)
	    perror("wait");
	else {
	    if ((t & 0xff) == 0)
		fprintf(stderr, "Process %d terminated normally, rc=%d\n",
		    p, t >> 8);
	    else if ((t & 0xff) == 127)
		fprintf(stderr, "Process %d stopped by signal %d\n",
			p, t >> 8);
	    else
		fprintf(stderr, "Process %d terminated by signal %d\n",
		    p, t & 0xff);
	}
    }
    return 0;
}
