/*
 * Programm zum Testen der Dateinamen-Konvertierungen
 * 	Optionen -t -r* -Rt803 -R533 -Rp
 *
 * Kompilieren mit:
 *	gcc -o fs-test.exe build/fs.o fs-test.c
 */

#include <stdio.h>
#include <ctype.h>

#include "DPMI.H"
#include "RSX.H"
#include "PROCESS.H"
#include "FS.H"

NEWPROCESS p;
NEWPROCESS *npz = &p;

/*
 * eine Ladung Funktionsruempfe, damit der Linker was hat.
 */
void	rm_lseek () {}
void	rm_ioctl_select_in () {}
void	rm_isatty () {}
void	rm_close () {}
void	cdosx_read () {}
void	cdosx_write () {}
void	sysemx_ioctl () {}
int	send_signal (NEWPROCESS *p, int i) { return 0;}
int	AllocLDT (UINT a, UINT *b) { return 0;}
int	AllocMem (DWORD a, DWORD *b, DWORD *c) {return 0;}
int	SetLimit (UINT a, DWORD b) {return 0;}
int	SetAccess (UINT a, BYTE b, BYTE c) {return 0;}
int	SetBaseAddress (UINT a, DWORD b) {return 0;}
int	FreeMem (DWORD a) {return 0;}
void	cpy32_16 () {}
void	cpy16_32 () {}
void	cpy32_32 () {}
void	store32 () {}
void	bzero32 () {}
int	schedule () {return 0;}
int	kbd_ioctl () {return 0;}
int	termio_read () {return 0;}
unsigned rm_bios_read_keybrd() {return 0;}
int	kready;
unsigned emx_errno;
long	time_tic;


void
main ()
{
  char	inbuf[BUFSIZ];
  int	temp;

  while (1) {
    printf (">");
    gets(inbuf);
    switch (*inbuf) {
      case 'h':
      case '?':	puts("cname         : convert name");
		puts("r*            : set default drive to *");
		puts("p             : toggle dot-conversion");
		puts("t[533|803]    : set conversion-convention");
		puts("h");
		puts("?             : print this help");
		puts("q             : quit");
		break;
      case 'q': exit(0);
      case 'c': convert_filename(inbuf+1);
		printf("  result <%s>\n", inbuf+1);
		break;
      case 'p':	npz->options.opt_convert_dot ^= 1;
		printf("  dot-conversion is %s\n",
			npz->options.opt_convert_dot ? "on" : "off");
		break;
      case 'r':	if (inbuf[1] == '\0'  ||  isalpha(inbuf[1]))
		  npz->options.opt_default_disk = inbuf[1];
		printf("  default disk drive is %c\n",
			npz->options.opt_default_disk);
		break;
      case 't':	if (1 == sscanf (inbuf+1, "%d", &temp) &&
				(temp == 533 || temp == 803))
		  npz->options.opt_convert_filename = temp;
		else
		  npz->options.opt_convert_filename = 0;
		printf("  conversion-style is %d\n",
			npz->options.opt_convert_filename);
		break;
    }
  }
}
