/* short.cmd */

/* Files to patch */

pfiles = 'cpp\bool.h cpp\builtinbuf.h cpp\CursesW.h cpp\iostream.h cpp\libio.h'
pfiles = pfiles||' cpp\minmax.h cpp\parsestream.h cpp\procbuf.h cpp\RNG.h'
pfiles = pfiles||' cpp\std.h cpp\streambuf.h cpp\exception cpp\stdexcept'
pfiles = pfiles||' cpp\std\typeinfo.h cpp\gen\SplayNode.ccP'
pfiles = pfiles||' cpp\std\cmath.h cpp\std\complext.h cpp\std\stddef.h'
pfiles = pfiles||' objc\Object.h'

/* Files to rename */

rfiles = 'unchecked.h cpp\_G_config.h'
rfiles = rfiles||' cpp\algorithm cpp\AllocRing.h cpp\BitString.h'
rfiles = rfiles||' cpp\builtinbuf.h cpp\exception cpp\functional'
rfiles = rfiles||' cpp\getpagesize.h cpp\Incremental.h cpp\indstream.h'
rfiles = rfiles||' cpp\parsestream.h cpp\stdexcept cpp\stdiostream.h'
rfiles = rfiles||' cpp\streambuf.h cpp\strstream.h cpp\typemacros.h'
rfiles = rfiles||' cpp\gen\SplayNode.ccP cpp\gen\SplayNode.hP'
rfiles = rfiles||' cpp\std\exception.h cpp\std\ldcomplex.h cpp\std\stdexcept.h'
rfiles = rfiles||' objc\typedstream.h objc\NXConstStr.h'

'@echo off'

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

if SysSearchPath('PATH', 'sed.exe') == '' then do
  say 'sed.exe not found -- see INSTALL.DOC'
  exit
end

do i = 1 to words(pfiles)
  file = word(pfiles, i)
  if stream(file, 'C', 'QUERY EXISTS') \= '' then do
    say 'Patching' file
    'sed -f short.sed >tmp' file
    if rc \= 0 then do
      say 'sed failed!'
      exit
    end
    'touch -r' file 'tmp'
    'del' file
    'move tmp' file '>nul'
  end
end

say 'Renaming files'
do i = 1 to words(rfiles)
  file = word(rfiles, i)
  name = filespec('name', file)
  if pos('.', name) > 0 then do
    parse var name base'.'ext
    newname = left(base, 8)||'.'||left(ext, 3)
  end
  else
    newname = left(name, 8)
  if stream(file, 'C', 'QUERY EXISTS') \= '' then
    'ren' file newname
end

say 'Done'
