#!/bin/sh
# maketexnam -- find PK and TFM names.
# te@informatik.uni-hannover.de, kb@mail.tug.org, and infovore@xs4all.nl.
# Public domain.

version='$Id: mktexnam,v 1.20 1998/03/16 18:25:12 olaf Exp $'
usage="Usage: $0 NAME [DPI MODE] [DESTDIR].
  Output the PK, TFM, and MF names for a font NAME."
mt_max_args=4

# Common code for all scripts.
: ${MT_TEXMFMAIN=`kpsewhich --expand-path='$TEXMFMAIN'`}
: ${MT_MKTEX_OPT=`kpsewhich --format='web2c files' mktex.opt`}
test -n "$MT_MKTEX_OPT" || MT_MKTEX_OPT="$MT_TEXMFMAIN/web2c/mktex.opt"
if test ! -f "$MT_MKTEX_OPT"; then
  echo "$0: Cannot find mktex.opt; check your installation." >&2
  exit 1
fi

. "$MT_MKTEX_OPT"

NAME=$1
case $# in
1|2) DPI=$BDPI; DEST=$2;;
3|4) DPI=$2;  MODE=$3;    DEST=$4;;
*)   help;;
esac

MT_PKDESTDIR='$MT_DESTROOT/$MT_PKDESTREL'
MT_TFMDESTDIR='$MT_DESTROOT/$MT_TFMDESTREL'
MT_MFDESTDIR='$MT_DESTROOT/$MT_MFDESTREL'
MT_PKMODEPART='$MT_PKPART/$MT_MODE'
MT_PKBASE='$NAME.${DPI}pk'
MT_TFMBASE='$NAME.tfm'
MT_MFBASE='$NAME.mf'
MT_DEFAULT_SUPPLIER=unknown
MT_DEFAULT_TYPEFACE=unknown
MT_DEFAULT_NAMEPART=tmp
MT_DEFAULT_PKDESTREL=''
MT_DEFAULT_TFMDESTREL=''
MT_DEFAULT_MFDESTREL=''
MT_DEFAULT_DESTROOT='$KPSE_DOT'

# Find the font: test tfm first, then mf, then possible sauterized mf.
fullname=`kpsewhich "$NAME.tfm" 2>/dev/null`
test -z "$fullname" && fullname=`kpsewhich "$NAME.mf" 2>/dev/null`
if test -z "$fullname"; then
  rootname=`echo $NAME | sed 's/[0-9]*$//'`
  fullname=`kpsewhich "b-$rootname.mf" 2>/dev/null`
  # Fonts starting with wn* get special treatment:
  if test -z "$fullname"; then
    case $rootname in
      wn*) lhname=`echo $NAME | sed 's/^wn/lh/'`
           fullname=`kpsewhich "$lhname.mf" 2>/dev/null`;;
      *)   fullname=`kpsewhich "$rootname.mf" 2>/dev/null`
    esac
  fi
fi

# After all this, do we _have_ a font?
if test -z "$fullname"; then
  # We have found nothing, so force using the fontmaps as a last resort.
  # This also means mktexnam can be queried for advice on where to
  # place fonts.
  MT_FEATURES="$MT_FEATURES:fontmaps"
  MT_DESTROOT="$MT_VARTEXFONTS"
else
  # Normalize $fullname.
  fullname=`echo "$fullname" | sed 's%//*%/%g'`
  # See if $fullname comes from a standard location.
  OIFS=$IFS;IFS=$SEP
  for i in `kpsewhich --expand-path='$TEXMF/fonts'"$SEP$MT_VARTEXFONTS"`
  do
    case "$fullname" in
      $i/*)
         # We now have a preliminary value for the destination root.
         MT_DESTROOT="$i"
         # When we're done, relfmt contains one of these:
         # "/source/$MT_NAMEPART/"
         # "/$MT_NAMEPART/source/"
         # while namepart contains the actual namepart.
         relfmt=`echo "$fullname" | \
           sed -e 's%^'"$i"'\(/.*/\)[^/]*$%\1%' \
               -e 's%^/tfm/%/source/%' \
               -e 's%/tfm/$%/source/%'`
         namepart=`echo "$relfmt" | sed -e 's%/source/%/%'`
         # See if namepart is empty.
         if test "$namepart" != "/"; then
           relfmt=`echo "$relfmt" | \
             sed -e 's%'"$namepart"'%/$MT_NAMEPART/%'`
         else
           # Assume TDS.
           relfmt='/source/$MT_NAMEPART/'
           namepart=''
         fi
	 # Determine supplier and typeface from namepart.  If there is
         # only one part in the namepart, we take it to be the typeface.
         MT_SUPPLIER=`echo $namepart | sed 's%^/\([^/]*\)/\(.*\)$%\1%'`
         MT_TYPEFACE=`echo $namepart | sed 's%^/\([^/]*\)/\(.*\)$%\2%'`
         if test -z "$MT_TYPEFACE"; then
           MT_TYPEFACE="$MT_SUPPLIER";
           MT_SUPPLIER=''
         fi
         # Phew.  Now we create the relative paths for pk, tfm and source.
         MT_NAMEPART='$MT_SUPPLIER/$MT_TYPEFACE'
         MT_PKDESTREL=`echo "$relfmt" | sed 's%/source/%/pk/$MT_MODE/%'`
         MT_TFMDESTREL=`echo "$relfmt" | sed 's%/source/%/tfm/%'`
         MT_MFDESTREL=`echo "$relfmt"`
         # And we're done with the loop now.
         break
    esac
  done
  IFS=$OIFS
fi

# In case some variables remain unset.
: ${MT_DESTROOT=$MT_DEFAULT_DESTROOT}
: ${MT_SUPPLIER=$MT_DEFAULT_SUPPLIER}
: ${MT_TYPEFACE=$MT_DEFAULT_TYPEFACE}
: ${MT_NAMEPART=$MT_DEFAULT_NAMEPART}
: ${MT_PKDESTREL=$MT_DEFAULT_PKDESTREL}
: ${MT_TFMDESTREL=$MT_DEFAULT_TFMDESTREL}
: ${MT_MFDESTREL=$MT_DEFAULT_MFDESTREL}

# Handle the options.
test -n "$MT_MKTEXNAM_OPT" && . "$MT_MKTEXNAM_OPT"

# Adjust MT_DESTROOT, if necessary.
if test "x$MT_DESTROOT" != "x$MT_DEFAULT_DESTROOT"; then
  # Do we have write access and permission?
  access -w "$MT_DESTROOT" || USE_ALTERNATE=1
  test -w "$MT_DESTROOT" || USE_ALTERNATE=1
  # We distinguish system trees from the rest.
  systexmf="`kpsewhich --expand-path='{$SYSTEXMF}/fonts'`$SEP$MT_VARTEXFONTS"
  case "$SEP$systexmf$SEP" in
    *$SEP$MT_DESTROOT$SEP*) # A system tree, check for varfonts.
      if test "x$USE_VARTEXFONTS" = x1 || test "x$USE_ALTERNATE" = x1; then
        MT_DESTROOT=$MT_VARTEXFONTS
      fi ;;
    *) # A non-system tree.
      test "x$USE_ALTERNATE" = x1 && MT_DESTROOT=$MT_DEFAULT_DESTROOT ;;
  esac
fi

case "$DEST" in
  "") ;;
  /* | [A-z]:/*) # Absolute, explicit destdir => use it.
      MT_PKDESTDIR=$DEST
      MT_TFMDESTDIR=$DEST
      MT_MFDESTDIR=$DEST
      MT_NAMEPART=;;
   *) # Relative destdir => append to the default.
      MT_NAMEPART=$DEST;;
esac

eval MT_MODE=\"$MODE\"
eval MT_NAMEPART=\"$MT_NAMEPART\"
eval MT_DESTROOT=\"$MT_DESTROOT\"
eval MT_PKDESTREL=\"$MT_PKDESTREL\"
eval MT_TFMDESTREL=\"$MT_TFMDESTREL\"
eval MT_MFDESTREL=\"$MT_MFDESTREL\"
eval MT_PKDESTDIR=\"$MT_PKDESTDIR\"
eval MT_TFMDESTDIR=\"$MT_TFMDESTDIR\"
eval MT_MFDESTDIR=\"$MT_MFDESTDIR\"
eval MT_PKNAME=\"$MT_PKDESTDIR/$MT_PKBASE\"
eval MT_TFMNAME=\"$MT_TFMDESTDIR/$MT_TFMBASE\"
eval MT_MFNAME=\"$MT_MFDESTDIR/$MT_MFBASE\"

echo "$MT_PKNAME$SEP$MT_TFMNAME$SEP$MT_MFNAME" | sed 's%//*%/%g'
