/********************************************************************
 *                                                                  *
 *                 Rechtschreibkontrolle fr TeX                    *
 *                                                                  *
 *                       Martin Eckl 1992 - 1994                    *
 *                    changes by Udo Brocker 10.5.1994              *
 *                                                                  *
 ********************************************************************/
/*    Copyright (C) 1992-1994 Martin Eckl

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define VER "1.2"
#define SEEK_SET 0
#define SEEK_END 2
#define FALSE 0
#define TRUE -1

#define GERMAN 1
/* Delete this line line for program messages in English!*/


/* Meaning of the following #define commands:

	TC 1 Uses special Turbo/Borland C commands for color output;
		  If you compile with Turbo/Borland C in spite of TC 0,
		  only 64kB dynamic memory will be used - too less for
		  working properly.
		  All other compilers (I know) need TC 0.

	NOSTDOUTBUF 1 executex an ANSI-C command to stop buffering
		  stdout. This is necessary if you are using djgpp.


	CLOSE 1 prevents calling fclose with a NULL pointer.
		  This would produce a runtime error if you are using djgpp.

	VERZEICHNISTRENNER
		  This string will be inserted between the path and the filename.
		  Under DOS: VERZEICHNISTRENNER "\\",
		  under UNIX: VERZEICHNISTRENNER "/".

	STRCMP 1 uses an own strcmp funtion; this must be used, if the
		  original function uses signed char.

	OPTIONENZEICHEN is the leading character of anoption. UNIX usually
		  uses '-', most other operation systems use '/', but in principle
		  this is arbitrary.

	REALLOC 1 replaces all realloc(NULL,size) by malloc(size);
		  this is necessary under SUN OS.

*/

#if defined(__TURBOC__)

	#define TC 1
	#define NOSTDOUTBUF 0
	#define CLOSE 0
	#define VERZEICHNISTRENNER "\\"
	#define STRCMP 0
	#define OPTIONENZEICHEN '/'
	#define REALLOC 0
	#define MAXFILENAME 50

	#ifdef __TINY__
		#error Modell muss mindestens Compact sein!
	#endif
	#ifdef __SMALL__
		#error Modell muss mindestens Compact sein!
	#endif
	#ifdef __MEDIUM__
		#error Modell muss mindestens Compact sein!
	#endif


#elif defined(__DJGPP__)

	#define TC 0
	#define NOSTDOUTBUF 1
	#define CLOSE 1
	#define VERZEICHNISTRENNER "\\"
	#define STRCMP 0
	#define OPTIONENZEICHEN '/'
	#define REALLOC 0
	#define MAXFILENAME 250

#elif defined(__SUN__)

	#define TC 0
	#define NOSTDOUTBUF 0
	#define CLOSE 0
	#define VERZEICHNISTRENNER "/"
	#define STRCMP 1
	#define OPTIONENZEICHEN '-'
	#define SPELLPATH "/usr/local/tex/texspell"
	#define REALLOC 1
	#define MAXFILENAME 250

	/*char* malloc();*/
#elif defined(__RS6000__)

	#define TC 0
	#define NOSTDOUTBUF 1
	#define CLOSE 0
	#define VERZEICHNISTRENNER "/"
	#define STRCMP 1                   /* ? */
	#define OPTIONENZEICHEN '-'
	#define SPELLPATH "/usr/local/tex/texspell"
	#define REALLOC 0
	#define MAXFILENAME 250

#elif defined (__TOS__)  /*  noch nicht getestet*/

	#define TC 0
	#define NOSTDOUTBUF 0
	#define CLOSE 0
	#define VERZEICHNISTRENNER "\\"
	#define STRCMP 0
	#define OPTIONENZEICHEN '/'
	#define REALLOC 1
	#define MAXFILENAME 250

#else   /* (hoffentlich) brauchbare Standardeinstellungen*/

	#define TC 0
	#define NOSTDOUTBUF 0
	#define CLOSE 0
	#define VERZEICHNISTRENNER "\\"
	#define STRCMP 0
	#define OPTIONENZEICHEN '/'
	#define REALLOC 0
	#define MAXFILENAME 250

#endif




/* Wird fuer farmalloc benoetigt */
#if TC
	#include <conio.h>
	#include <alloc.h>
#endif


/* Bug in DJGPP */
#if CLOSE
	#define fclose(x) (x)==NULL?EOF:fclose(x)
#endif

/*Bug in SUN OS*/
#if REALLOC
	#define realloc(x,y) (x)==NULL?malloc(y):realloc(x,y)
#endif


#define DEUTSCHESALPHABET "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZә᠂酊냈"
#define ENGLISCHESALPHABET "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"

/*Alle Dateinamen*/

#define LISTNAME "texspell.lst"
#define ENDNAME  "texspell.end"
#define ERGNAME  "texspell.erg"
#define KEYNAME  "texspell.key"
#define DATNAME  "texspell.dat"
#define VORSILBENAME "texspell.vor"
#define ENGLISTNAME "texspeng.lst"
#define ENGENDNAME  "texspeng.end"
#define ENGERGNAME  "texspeng.erg"
#define ENGVORSILBENAME "texspeng.vor"
#define TEMPFILE    "texspell.tmp"




/* Definitionen fuer qsort */
typedef int (*fcmp) (const void *, const void *);
typedef char befehlswort[30];

FILE *ein,*aus,*wortliste,*logfile,*special,*special2,*ergfile,
	  *rekurin[5],*rekurout[5],*keyfile,*prueffile;

int anzahl_befehle,maxline,maxbefehle=50,zeile=0,anzahl_ignoriert=0,
	 maxignoriert=499,anzahl_aufgenommen=0,maxaufgenommen=40,
	 anzahl_aufgenommenspecial=0,maxaufgenommenspecial=40,
	 anzahl_aufgenommenspecial2=0,maxaufgenommenspecial2=40,
	 tiefe=0,norekur,vorschlaege=-1,
	 gtex=-1,ersetz=FALSE,abgebrochen=0,changeinput=0,folgeinput=TRUE,
	 superviser=FALSE,rekur=0,rekurzeile[5],
	 writebenutzer=FALSE,writetext=FALSE,englisch=FALSE,
	 pruef=FALSE,anzahl_vorsilben,anzahlvorschlaege,batchmode=FALSE;

long position[256],posspecial[256],posspecial2[256],poserg[256],
	  aktpos,specialpos,specialpos2,ergpos,platz,platzspecial,platzspecial2,
	  filesize,filesizespecial,filesizespecial2,filesizeerg,platzerg;

#if TC
long huge *datpoint;
long huge *datpointspecial;
long huge *datpointspecial2;
long huge *datpointerg;
long huge *datpointvor;
char huge *listmem=NULL;
char huge *listmemspecial=NULL;
char huge *listmemspecial2=NULL;
char huge *ergmem=NULL;
char huge *vorsilbemem=NULL;
char huge *keybereich, huge *maxkey;

int ansisys=TRUE;

#else
long *datpoint;
long *datpointspecial;
long *datpointspecial2;
long *datpointerg;
long *datpointvor;
char *listmem=NULL;
char *listmemspecial=NULL;
char *listmemspecial2=NULL;
char *ergmem=NULL;
char *vorsilbemem;
char *keybereich, *maxkey;

#endif

char ignoriert[500] [30],
	  linein[250],lineout[255],fertig[250],lastline[250],aufgenommen [40] [250],
	  aufgenommenspecial [40] [250],
	  aufgenommenspecial2 [40] [250],
	  *point,wort[250],Name_eingabe[MAXFILENAME],Name_ausgabe[MAXFILENAME],
	  namespecial[MAXFILENAME]="",
	  namespecial2[MAXFILENAME]="",listname[MAXFILENAME],datname[MAXFILENAME],
	  ergname[MAXFILENAME],vorname[MAXFILENAME],
	  rekurinname[5][MAXFILENAME],rekuroutname[5][MAXFILENAME],
	  dummyname[MAXFILENAME],
	  endungsliste[20][25][6],endname[MAXFILENAME],keyname[MAXFILENAME],
	  Ausgabepuffer[100],
	  Gefunden[6][50],Rest[50],defaultliste='s',
	  vorschlagpuffer[20][50];

befehlswort *befehl1,*befehl2;

void kontrolle(char *lineout);

#include "taus.c"

#if STRCMP

/********************************************************************
 *                    strcmp                                    UB  *
 ********************************************************************/

int strcmp(const char *a, const char *b)

/********************************************************************
 * eigenes strcmp                                                   *
 * da manche strcmp routine signed char betrachten                  *
 ********************************************************************/

{ 
  
  for(;*((unsigned char*)a) == *((unsigned char*)b);a++,b++) 
    if (*a == 0)
      return 0;
   

  if (*((unsigned char*)a) < *((unsigned char*)b)) return -1;
 
  return 1;
}
#endif


/********************************************************************
 *                    leseposspecial                                *
 ********************************************************************/
void leseposspecial (name,datei,speicherbereich,zeigerarray,
anfangsbuchstaben,filegroesse,wortzahl)

/********************************************************************
 * Hier werden die Arrays gefuellt, mit denen die Woerter in den    *
 * Listen gesucht werden koennen                                    *
 ********************************************************************/

char *name;
FILE *datei;
long *anfangsbuchstaben,*filegroesse,*wortzahl;
#if TC
long huge **zeigerarray ;
char huge **speicherbereich;
#else
long **zeigerarray ;
char **speicherbereich;
#endif
{char c,help[250];
unsigned char zeichen=' ',altchar;
long i,ii,anzahl=0;
int j;

  if(strcmp(name,"")==0){return;}

  fseek(datei,0,SEEK_END);

#if TC
	if(*speicherbereich!=NULL){farfree((void*)*speicherbereich);}
	if ((*speicherbereich=(char*)farmalloc((unsigned long)(*filegroesse=(ftell(datei)+1)*sizeof(char))))==NULL){
#ifdef GERMAN
		fprintf(stderr,"\nZu wenig Speicher!\n");exit(2);
#else
		fprintf(stderr,"\nNot enough memory!\n");exit(2);
#endif
	}/*Ende if*/
#else
	if(*speicherbereich!=NULL){free((void*)*speicherbereich);}
	if ((*speicherbereich=(char*)malloc((size_t)(*filegroesse=(ftell(datei)+1)*sizeof(char))))==NULL){
#ifdef GERMAN
		fprintf(stderr,"\nZu wenig Speicher!\n");exit(2);
#else
		fprintf(stderr,"\nNot enough memory!\n");exit(2);
#endif
	}/*Ende if*/
#endif

	rewind(datei);
	altchar=0;
	c=fgetc(datei);
	if(c==13){c='\0';}
	if(c==10){c='\0';}

	(*speicherbereich)[0]=c;

	help[0]=c;
	ii=1;
	i=1;
	(*zeigerarray)[anzahl++]=0;

	while((c=fgetc(datei))!=(char)EOF){
		if(c==13){c='\0';}
		if(c==10){c='\0';}

		(*speicherbereich)[ii]=c;
		help[i]=c;
		if((help[i-1]==0)&&(help[i]!=0)){

			if ((unsigned char)help[0]!=zeichen){
				zeichen=help[0];

				for (j=altchar+1;j<=zeichen;j++){

					anfangsbuchstaben[j]=anzahl-1;

				}/*Ende for*/
				altchar=zeichen;
			}/*Ende if*/

			(*zeigerarray)[anzahl]=ii;
			if (anzahl+1==*wortzahl) {

#if TC
				if((*zeigerarray=(long*)farrealloc((void*)*zeigerarray,(unsigned long)((*wortzahl+50)*sizeof(long))))==NULL){
#ifdef GERMAN
					fprintf(stderr,"\nZu wenig Speicher!\n");
#else
					fprintf(stderr,"\nNot enough memory!\n");exit(2);
#endif
					exit(2);
				}
#else
				if((*zeigerarray=(long*)realloc((void*)*zeigerarray,(size_t)((*wortzahl+50)*sizeof(long))))==NULL){
#ifdef GERMAN
					fprintf(stderr,"\nZu wenig Speicher!\n");
#else
					fprintf(stderr,"\nNot enough memory!\n");exit(2);
#endif
					exit(2);
				}
#endif
				*wortzahl+=50;

			}/*Ende if*/

			i=0;
			anzahl++;
			help[0]=c;


		}/*Ende if*/

		ii++;
		i++;

	}/*Ende while*/

/* Wort mit der Nummer Anzahl ist nicht mehr definiert*/

	for (j=zeichen+1;j<=255;j++){
		anfangsbuchstaben[j]=anzahl-1;
	}/*Ende for*/

	(*speicherbereich)[ii-1]='\0';   /*letztes Wort abschliessen,
												  dabei Dateiendezeichen ueberschreiben*/


}/*Ende lesposspecial*/


/********************************************************************
 *                    islow/tolow/toup/isalpha                      *
 ********************************************************************/

/********************************************************************
 * Hier werden spezielle Zeichenverarbeitungsfunktionen fuer das    *
 * deutsche (bzw. internationale ) Alphabet definiert               *
 ********************************************************************/

int neuisalpha (char c)

{       if(strchr(DEUTSCHESALPHABET,c)==NULL){
		return(FALSE);
	}else{
		return(TRUE);
	}/*Ende if*/


}/*Ende neuisalpha*/

int neuislow (char c)

{
	switch (c) {
		case '\\':return(0);
		case '': return(-1);
		case '': return(-1);
		case '': return(-1);
		case '': return(-1);
		case '': return(-1);
		case '': return(-1);
		case '': return(-1);
		case '': return(-1);
		case '': return(-1);
		case '': return(-1);
		case '': return(-1);
		case '': return(-1);
		case '': return(-1);
		case '': return(-1);
		case '': return(-1);
		case '': return(-1);
		case '': return(-1);

		default : return((unsigned char)c>127?0:islower(c));

		/* Alle Zeichen >127 muessen grosse Umlaute sein*/
		/* da die kleinen alle Aufgefuehrt sind         */

	}/*Ende switch */
}/*Ende islow*/

char neutolow (char c)

{

	switch (c) {
		case '': return('');
      case '': return('');
		case '': return('');
		case '': return('');
		case '': return('');
		case '': return('');
		case '': return('');
		case '': return('');
		case '': return('');
		case '': return('');
		case '': return('');
		case '': return('');
		case '': return('');
		case '': return('');
		case '': return('');
		case '': return('');
		default : return((unsigned char)c>127?c:tolower(c));
		/*Die Zeichen > 127, die Grossbuchstaben darstellen, sind */
		/*alle aufgefuehrt, der Rest sind  daher Kleinbuchstaben*/
	}/*Ende switch */

}/*Ende tolow */

char neutoup (char c)
{

	switch (c) {
		case '': return('');
		case '': return('');
		case '': return('');
		case '': return('');
		case '': return('');
		case '': return('');
		case '': return('');
		case '': return('');
		case '': return('');
		case '': return('');
		case '': return('');
		case '': return('');
		case '': return('');
		case '': return('');
		case '': return('');
		case '': return('');
		default : return((unsigned char)c>127?c:toupper(c));
		/*Die Zeichen > 127, die Kleinbuchstaben darstellen, sind */
		/*alle aufgefuehrt, der Rest sind  daher Grossbuchstaben*/

	}/*Ende switch */

}/*Ende tolow */

/********************************************************************
 *                    neuezeile                                     *
 ********************************************************************/

char *neuezeile (void)

/********************************************************************
 * Liest eine neue Zeile aus dem TeX-Text ein                       *
 ********************************************************************/

{
	zeile++;
	if(((zeile%10)==0)&&(batchmode==FALSE)) {printf("[%i]",zeile);}
	strcpy(lastline,linein);
	return(fgets(linein,250,ein));

}/*Ende neuezeile*/


/********************************************************************
 *                        sort_function                             *
 ********************************************************************/



int sort_function(const char *a, const char *b)

/********************************************************************
 * Funktion, die an qsort uebergeben wird                           *
 ********************************************************************/

{
  return( strcmp(a,b) );
}


/********************************************************************
 *                 maketempname                                     *
 ********************************************************************/

void maketempname(char *help)

/*********************************************************************
 * Diese Funktion uebernimmt den Filenamen *name und macht daraus    *
 * den Namen einer temporaeren Datei, die im gleichen Verzeichnis    *
 * wie *name steht.                                                  *
 *********************************************************************/

{int i;
	for(i=strlen(help)-1;i>=0;i--){
		if(strncmp(&help[i],VERZEICHNISTRENNER,1)==0){help[i+1]='\0';break;}
	}/*Ende for*/

	if (i!=-1){
		strcat(help,TEMPFILE);
	}else{
		strcpy(help,TEMPFILE);
	}
}


/********************************************************************
 *                        schreibeaufgenommen                       *
 ********************************************************************/

void schreibeaufgenommen (void)

/********************************************************************
 * Leert den Puffer, in dem die Woerter stehen, die in die          *
 * Standardliste aufgenommen wurden.                                *
 ********************************************************************/

{  FILE *tempin,*tempout;
	char help[250],tmpname[250],c;
	int i,j;
		if (anzahl_aufgenommen == 0) {return;}
#ifdef GERMAN
		printf("\nSchreibe die aufgenommenen W"oE"rter in die Standardliste!\n");
#else
		printf("\nWriting words to standardlist!\n");
#endif
		qsort((void *)aufgenommen,(size_t)anzahl_aufgenommen,(size_t)250,(fcmp)sort_function);

		if (superviser==TRUE) {
			/* fclose (wortliste);/* nicht mehr noetig; Datei ist sowieso zu*/
			strcpy(tmpname,listname);
			maketempname(tmpname);
			remove(tmpname);
			if(rename (listname,tmpname)!=0){
#ifdef GERMAN
				fprintf(stderr,"\nFehler beim Schreiben in Standardliste\n");
				fprintf(stderr,"Datei %s m"oE"glicherweise schreibgesch"uE"tzt!\n",listname);
#else
				fprintf(stderr,"\nError while writing to the standardlist\n");
				fprintf(stderr,"File %s is probably write protected!\n",listname);

#endif
				if ((wortliste = fopen (listname,"rb"))==NULL) {
#ifdef GERMAN
					fprintf(stderr,"Fehler beim Wieder"oE"ffnen von %s \n",listname);
#else
					fprintf(stderr,"Error when reopening %s \n",listname);
#endif
					exit(1);
				}/*Ende if*/
				anzahl_aufgenommen=0;
				return;
			}/*Ende if*/


			tempin=  fopen(tmpname,"r");
			tempout= fopen(listname,"w+");
		}else{
			strcpy(tmpname,ergname);
			maketempname(tmpname);
			/* fclose (ergfile);/* nicht mehr noetig; Datei ist sowieso zu*/
			remove(tmpname);
			if(rename (ergname,tmpname)!=0){
#ifdef GERMAN
				fprintf(stderr,"\nFehler beim Schreiben in Standardliste!\n");
				fprintf(stderr,"Datei %s m"oE"glicherweise schreibgesch"uE"tzt!\n",ergname);
#else
				fprintf(stderr,"\nError while writing to the standardlist!\n");
				fprintf(stderr,"File %s is probably write protected!\n",ergname);
#endif
				if ((ergfile = fopen (ergname,"rb"))==NULL) {
#ifdef GERMAN
					fprintf(stderr,"Fehler beim Wieder"oE"ffnen von %s \n",ergname);
#else
					fprintf(stderr,"Error when reopening %s \n",ergname);
#endif
					exit(1);
				}/*Ende if*/
				anzahl_aufgenommen=0;
				return;
			}/*Ende if*/


			tempin=  fopen(tmpname,"r");
			tempout= fopen(ergname,"w+");
		}/*ende if*/
		help[0]=255;
		help[1]=0;  /*Falls nichts gelesen wird, soll ein moeglichst grosser*/
						/*String in help stehen*/
		j=fscanf(tempin,"%s\n",&help);  /*In j merken, ob der Inhalt von help*/
													/*gueltig ist*/

		i=0;
		while (i<anzahl_aufgenommen){
			while (strcmp(help,aufgenommen[i])<0){

				fprintf(tempout,"%s\n",help);
				help[0]=255;
				help[1]=0;
				j=fscanf(tempin,"%s\n",&help);
			} /*Ende while*/

			fprintf(tempout,"%s\n",aufgenommen[i]);
			i++;
		}/*Ende while*/


		if(j!=EOF){fprintf(tempout,"%s\n",help);}

		while (fscanf(tempin,"%s\n",&help)!=EOF){
			fprintf(tempout,"%s\n",help);
		}/*Ende while*/

		fclose(tempin);
		fclose(tempout);

		if (superviser==TRUE){
			if ((wortliste = fopen (listname,"rb"))==NULL) {
#ifdef GERMAN
				fprintf(stderr,"Fehler beim Wieder"oE"ffnen von %s!",listname);
#else
				fprintf(stderr,"Error when reopening %s!",listname);
#endif
				exit(1);
			}/*Ende if*/

			leseposspecial(listname,wortliste,&listmem,&datpoint,position,
			&filesize,&platz);

			fclose(wortliste);

		}else{
			if ((ergfile = fopen (ergname,"rb"))==NULL) {
#ifdef GERMAN
				fprintf(stderr,"Fehler beim Wieder"oE"ffnen von %s",ergname);
#else
				fprintf(stderr,"Error when reopening %s!",ergname);
#endif
				exit(1);
			}/*Ende if*/
		leseposspecial(ergname,ergfile,&ergmem,&datpointerg,poserg,
		&filesizeerg,&platzerg);

		fclose(ergfile);

		}/*Ende if*/
		anzahl_aufgenommen=0;
		remove(tmpname);

}/*Ende schreibeaufgenommen */


/************************************************************************
 *                            combine                                   *
 ************************************************************************/

int combine(char *s1, char *s2)
{
int laenge2,anfang;
char dummy[2];

	if((unsigned char)s2[(laenge2=strlen(s2))-1]>235){
		if((unsigned char)s2[laenge2-1]==255){return FALSE;}
		if(strncmp(s1,s2,laenge2-1)!=0){return FALSE;} /*s1 und s2 unterscheiden */
																		/*sich vor der Endung*/
		dummy[0]=s2[laenge2-1];
		dummy[1]='\0';

		s2[laenge2-1]=',';

		s2[laenge2]='\0';
		strcat(s2,&s1[laenge2-1]);
		strcat(s2,",");
		strcat(s2,dummy);
		strcat(s2,",");
		return TRUE;

	}else if((unsigned char)s2[laenge2-1]==166){
		if(strncmp(s1,s2,anfang=strcspn(s2,","))!=0){return FALSE;}

		s2[laenge2-1]='\0';

		strcat(s2,&s1[anfang]);
		strcat(s2,",");
		return TRUE;

	}else{
		return FALSE;
	}/*Ende if*/





}/*Ende combine*/

/********************************************************************
 *                        schreibeaufgenommenspecial                *
 ********************************************************************/

void schreibeaufgenommenspecial (void)

/********************************************************************
 * Leert den Puffer, in dem die Woerter stehen, die in die          *
 * Benutzerliste aufgenommen wurden.                                *
 ********************************************************************/


{  FILE *tempin,*tempout;
	char help[250],c,tmpname[250];
	int i,j,k;
		if (anzahl_aufgenommenspecial == 0) {return;}
#ifdef GERMAN
		printf("\nSchreibe die aufgenommenen W"oE"rter in die Benutzerliste!\n");
#else
		printf("\nWriting words to userlist!\n");
#endif
		qsort((void *)aufgenommenspecial,(size_t)anzahl_aufgenommenspecial,(size_t)250,(fcmp)sort_function);

		/*fclose (special);/* nicht mehr noetig; Datei ist sowieso zu*/
			strcpy(tmpname,namespecial);
			maketempname(tmpname);

		remove(tmpname);
		if(rename (namespecial,tmpname)!=0){
#ifdef GERMAN
			fprintf(stderr,"\nFehler beim Schreiben in Benutzerliste\n");
			fprintf(stderr,"Datei %s m"oE"glicherweise schreibgesch"uE"tzt!\n",namespecial);
#else
			fprintf(stderr,"\nError while writing to userlist\n");
			fprintf(stderr,"File %s is probably write protected!\n",namespecial);
#endif
			if ((special = fopen (namespecial,"rb"))==NULL) {
#ifdef GERMAN
				fprintf(stderr,"Fehler beim Wieder"oE"ffnen von %s \n",namespecial);
#else
				fprintf(stderr,"Error when reopening %s \n",namespecial);
#endif
				exit(1);
			}/*Ende if*/
			anzahl_aufgenommenspecial=0;
			return;
		}/*Ende if*/


		tempin=  fopen(tmpname,"r");
		tempout= fopen(namespecial,"w+");

		help[0]=255;
		help[1]=0;  /*Falls nichts gelesen wird, soll ein moeglichst grosser*/
						/*String in help stehen*/
		j=fscanf(tempin,"%s\n",&help);   /*Falls Datei nur aus Dummyeintrag*/
													/*besteht, wird dieser entfernt*/
													/*In j merken, ob der Inhalt von help*/
													/*gueltig ist*/
		i=0;
		while (i<anzahl_aufgenommenspecial){

			while (((k=combine(aufgenommenspecial[i],help))==FALSE)&&(strcmp(help,aufgenommenspecial[i])<0)){


				fprintf(tempout,"%s\n",help);
				help[0]=255;               /*Fall nichts mehr aus der Datei kommt*/
				help[1]=0;
				j=fscanf(tempin,"%s\n",&help);
			} /*Ende while combine */

			if(k==FALSE){ /*wie bisher*/
				fprintf(tempout,"%s\n",aufgenommenspecial[i]);
				i++;
			}else{
					  /* geht noch mehr zu kombinieren?*/
				while((k==TRUE)&&((++i)<anzahl_aufgenommenspecial)){/*weiter kombinieren*/
					k=combine(aufgenommenspecial[i],help);
				}

				if(k==FALSE){ /* => i!=anzahl_aufgenommen, d.h.noch Woerter
										uebrig*/

					if(strcmp(help,aufgenommenspecial[i])>0){
						fprintf(tempout,"%s\n",aufgenommenspecial[i]);
						i++;
					}

				}/*Ende if*/
			}/*Ende if*/

		}/*Ende while i<anzahl_aufgenommenspecial*/

		
		if(j!=EOF){fprintf(tempout,"%s\n",help);} /*nur schreiben, wenn help */
																/*gueltig*/

		while (fscanf(tempin,"%s\n",&help)!=EOF){
			fprintf(tempout,"%s\n",help);
		}/*Ende while*/

		fclose(tempin);
		fclose(tempout);

		if ((special = fopen (namespecial,"rb"))==NULL) {
#ifdef GERMAN
			fprintf(stderr,"Fehler beim Wieder"oE"ffnen von %s \n",namespecial);
#else
			fprintf(stderr,"Error when reopening %s \n",namespecial);
#endif
			exit(1);
		}/*Ende if*/

		leseposspecial(namespecial,special,&listmemspecial,&datpointspecial,posspecial,
		&filesizespecial,&platzspecial);
		fclose(special);

		anzahl_aufgenommenspecial=0;
		remove(tmpname);

}/*Ende schreibeaufgenommen */

/********************************************************************
 *                        schreibeaufgenommenspecial2               *
 ********************************************************************/

void schreibeaufgenommenspecial2 (void)

/********************************************************************
 * Leert den Puffer, in dem die Woerter stehen, die in die          *
 * Textwoerterliste aufgenommen wurden.                             *
 ********************************************************************/



{  FILE *tempin,*tempout;
	char help[250],c,tmpname[250];
	int i,j,k;
		if (anzahl_aufgenommenspecial2 == 0) {return;}
#ifdef GERMAN
		printf("\nSchreibe die aufgenommenen W"oE"rter in die Textliste!\n");
#else
		printf("\nWriting words to textlist!\n");
#endif
		qsort((void *)aufgenommenspecial2,(size_t)anzahl_aufgenommenspecial2,(size_t)250,(fcmp)sort_function);
		/* fclose (special2); /* nicht mehr noetig; Datei ist sowieso zu*/
			strcpy(tmpname,namespecial2);
			maketempname(tmpname);

		remove(tmpname);
			if(rename (namespecial2,tmpname)!=0){
#ifdef GERMAN
			fprintf(stderr,"\nFehler beim Schreiben in Textliste\n");
			fprintf(stderr,"Datei %s m"oE"glicherweise schreibgesch"uE"tzt!\n",namespecial2);
#else
			fprintf(stderr,"\nError while writing to textliste\n");
			fprintf(stderr,"File %s is probably write protected!\n",namespecial2);
#endif
			if ((special2 = fopen (namespecial2,"rb"))==NULL) {
#ifdef GERMAN
				fprintf(stderr,"Fehler beim Wieder"oE"ffnen von %s \n",namespecial2);
#else
				fprintf(stderr,"Error when reopening %s \n",namespecial2);
#endif
				exit(1);
			}/*Ende if*/

			anzahl_aufgenommenspecial2=0;
			return;
			}/*Ende if*/

		tempin=  fopen(tmpname,"r");
		tempout= fopen(namespecial2,"w+");
		help[0]=255;
		help[1]=0;  /*Falls nichts gelesen wird, soll ein moeglichst grosser*/
						/*String in help stehen*/
		j=fscanf(tempin,"%s\n",&help);  /*In j merken, ob der Inhalt von help*/
													/*gueltig ist*/

		i=0;
		while (i<anzahl_aufgenommenspecial2){
			while (((k=combine(aufgenommenspecial2[i],help))==FALSE)&&(strcmp(help,aufgenommenspecial2[i])<0)){


				fprintf(tempout,"%s\n",help);
				help[0]=255;               /*Fall nichts mehr aus der Datei kommt*/
				help[1]=0;
				j=fscanf(tempin,"%s\n",&help);
			} /*Ende while combine */

			if(k==FALSE){ /*wie bisher*/
				fprintf(tempout,"%s\n",aufgenommenspecial2[i]);
				i++;
			}else{
					  /* geht noch mehr zu kombinieren?*/
				while((k==TRUE)&&((++i)<anzahl_aufgenommenspecial2)){/*weiter kombinieren*/
					k=combine(aufgenommenspecial2[i],help);
				}

				if(k==FALSE){ /* => i!=anzahl_aufgenommenspecial2, d.h.noch Woerter
										uebrig*/

					if(strcmp(help,aufgenommenspecial2[i])>0){
						fprintf(tempout,"%s\n",aufgenommenspecial2[i]);
						i++;
					}

				}/*Ende if*/
			}/*Ende if*/

		}/*Ende while*/

		
		if(j!=EOF){fprintf(tempout,"%s\n",help);}

		while (fscanf(tempin,"%s\n",&help)!=EOF){
			fprintf(tempout,"%s\n",help);
		}/*Ende while*/

		fclose(tempin);
		fclose(tempout);

		if ((special2 = fopen (namespecial2,"rb"))==NULL) {
#ifdef GERMAN
			fprintf(stderr,"Fehler beim Wieder"oE"ffnen von %s \n",namespecial2);
#else
			fprintf(stderr,"Error when reopening %s \n",namespecial2);
#endif
			exit(1);
		}/*Ende if*/

		leseposspecial(namespecial2,special2,&listmemspecial2,&datpointspecial2,posspecial2,
		&filesizespecial2,&platzspecial2);

		fclose(special2);

		anzahl_aufgenommenspecial2=0;
		remove(tmpname);

}/*Ende schreibeaufgenommen2 */

/************************************************************
 *                     ende                                 *
 ************************************************************/

void ende (int i)

/***********************************************************************
 * Veranlasst das Leeren aller Puffer und das Schliessen aller Dateien *
 * Ende wird nur aufgerufen, wenn das Programm Fehlerfrei beendet wurde*
 ***********************************************************************/

{
	schreibeaufgenommen();
	schreibeaufgenommenspecial();
	schreibeaufgenommenspecial2();

	fclose(ein);
	fclose(aus);
	fclose(wortliste);
	fclose(logfile);
	if (strcmp(namespecial,"")!=0){fclose(special);}
	if (strcmp(namespecial2,"")!=0){fclose(special2);}

	fclose(ergfile);

	if(pruef==TRUE){fclose(prueffile);}

	remove(TEMPFILE);
	rename(Name_eingabe,TEMPFILE);
	remove(Name_eingabe);
	rename(Name_ausgabe,Name_eingabe);
	rename(TEMPFILE,Name_ausgabe);
	remove(TEMPFILE);
	free((long*)datpoint);
	fprintf(stdout,"\n");
	exit(i);

}/*Ende ende*/




/********************************************************************
 *                    fehler                                        *
 ********************************************************************/

void fehler (int i,char name[])

/********************************************************************
 * Gibt Fehlermeldungen aus und beendet das Programm                *
 ********************************************************************/

{  switch (i){
#ifdef GERMAN
	case 1:
		fprintf(stderr,"Die Datei '%s' konnte nicht ge"oE"ffnet werden!\n",name);
		break;

	case 2:
		fprintf(stderr,"Die Eingabedatei %s konnte nicht ge"oE"ffnet werden!\n",name);
		break;

	case 3:
		fprintf(stderr,"Die Ausgabedatei %s konnte nicht ge"oE"ffnet werden!\n",name);
		break;

	case 4:
		fprintf(stderr,"Der Befehl %s wurde nicht gefunden!\n",name);
		break;

	case 5:
		fprintf(stderr,"Nicht genug Speicher frei!\n");
		break;

	case 7:
		fprintf(stderr,"Zu viele Endungslisten definiert!\n");
		break;

	default:
		fprintf(stderr,"Fehler bei der Programmausf"uE"hrung!");
		break;

#else
	case 1:
		fprintf(stderr,"Couldn't open file '%s'!\n",name);
		break;

	case 2:
		fprintf(stderr,"Couldn't open the input file %s!\n",name);
		break;

	case 3:
		fprintf(stderr,"Couldn't open the output file %s!\n",name);
		break;

	case 4:
		fprintf(stderr,"Couldn't find the %s directive!\n",name);
		break;

	case 5:
		fprintf(stderr,"Not enough memory left!\n");
		break;

	case 7:
		fprintf(stderr,"Too many ending lists defined!\n");
		break;

	default:
		fprintf(stderr,"Error in program execution!");
		break;


#endif

	}/*Ende switch*/
	schreibeaufgenommen();
	schreibeaufgenommenspecial();
	schreibeaufgenommenspecial2();
	free((long*)datpoint);
	exit(2);

}/*Ende fehler*/


/********************************************************************
 *                    anleitung                                     *
 ********************************************************************/

void anleitung (void){

/********************************************************************
 * Gibt die Kurzanleitung aus                                       *
 ********************************************************************/
#define OP OPTIONENZEICHEN

#ifdef GERMAN
	fprintf(stderr,
	"\n\nTEXSPELL  Quelle[.ext] [n] [list1.lst] [list2.lst] [%cp] [%cu] [%cv] [%ci] [%ce] [%cg] [%cb] [%ct]"
 #if TC
	" [%ca]"
 #endif
	" [%cc FILENAME] [%cq]"
	"\n"
	"\nF"uE"hrt f"uE"r den Text 'Quelle.ext' Rechtschreibkontrolle durch.\n"
	"Standard-Erweiterung f"uE"r Quelle ist 'tex'.\n"
	"Am Anfang werden n Zeilen "uE"berlesen.\n"
	"Zus"aE"tzlich zur normalen Liste wird noch 'list1.lst' \n"
	"(Benutzerw"oE"rterliste) und 'list2.lst' (Textw"oE"rterliste) zur Erkennung \n"
	"verwendet!\n"
	"%cp schaltet die deutschen TeX-Befehle aus.\n"
	"%cu schaltet die Umlautersetzung ein.\n"
	"%cv stellt die Korrekturvorschl"aE"ge ab.\n"
	"%ci schaltet Verfolgung von \\input - Befehlen ab.\n"
	"%ce verwendet die englische W"oE"rterliste.\n"
	"%cg verwendet die deutsche W"oE"rterliste (default).\n"
	"%cb stellt die Benutzerliste als Defaultliste ein.\n"
	"%ct stellt die Textliste als Defaultliste ein.\n"
 #if TC
	"%ca schaltet die Verwendung von Farben aus\n"
	"   (sinnvoll, wenn ANSI.SYS nicht installiert ist)\n"
 #endif
	"%cc FILENAME schreibt alle unbekannten W"oE"rter ohne nachzufragen in die\n"
	"   Datei FILENAME\n"
	"%cq gibt ohne Dialog Meldungen "uE"ber unbekannte W"oE"rter aus.\n"
	"texspell %cl zeigt Informationen "uE"ber die Software Lizenz an.\n"
	"\n"
	"TeXSPELL Version "VER", (c) 1992 - 94 Martin Eckl \n"
	,OP,OP,OP,OP,OP,OP,OP,OP,OP,OP,OP,OP,OP,OP,OP,OP,OP,OP,OP,OP,OP,OP,OP);
	exit(2);

#else
	fprintf(stderr,
	"\n\nTEXSPELL  source[.ext] [n] [list1.lst] [list2.lst] [%cp] [%cu] [%cv] [%ci] [%ce] [%cg] [%cb] [%ct]"
 #if TC
	" [%ca]"
 #endif
	" [%cc FILENAME] [%cq]"
	"\n"
	"\nChecks the text 'source.ext' for correct spelling.\n"
	"Default extension for source is 'tex'.\n"
	"At the beginning n lines are ignored.\n"
	"In addition to the normal list 'list1.lst'\n"
	"(userlist) and 'list2.lst' (textlist) are used \n"
	"for recognizing words!\n"
	"%cp turns off German TeX commands.\n"
	"%cu turns on the umlaut translation.\n"
	"%cv turns off correction suggestions.\n"
	"%ci turns off \\input directive follow-up.\n"
	"%ce uses the English word list (default).\n"
	"%cg uses the German word list.\n"
	"%cb sets the userlist to the defaultlist.\n"
	"%ct sets the textlist to the defaultlist.\n"
 #if TC
	"%ca turns off the use of colours.\n"
	"   (useful, if ANSI.SYS is not installed)\n"
 #endif
	"%cc FILENAME writes all unknown words to the\n"
	"    file FILENAME without confirmation.\n"
	"%cq prints out messages about unknown words without dialogue.\n"
	"texspell %cl displays software licence information.\n"
	"\n"
	"TeXSPELL Version "VER", (c) 1992 - 94 Martin Eckl \n"
	,OP,OP,OP,OP,OP,OP,OP,OP,OP,OP,OP,OP,OP,OP,OP,OP,OP,OP,OP,OP,OP,OP,OP);
	exit(2);

#endif

#undef OP
}/*Ende Anleitung*/

/********************************************************************
 *                    anlegen                                       *
 ********************************************************************/
void anlegen(void)

/********************************************************************
 * Wenn eine Benutzerwoerterliste angegeben wird, die noch nicht    *
 * existiert, wird sie von dieser Funktion angelegt                 *
 ********************************************************************/

{
	if ((special = fopen (namespecial,"w+"))==NULL) {fehler(1,namespecial);}

	fprintf(special,"A\n");/*Dummyeintrag, der von %s nicht gelesen wird!!*/
	fclose(special);

	if ((special = fopen (namespecial,"rb"))==NULL) {fehler(1,namespecial);}
	writebenutzer=TRUE;

}/*Ende anlegen*/


/********************************************************************
 *                    anlegen2                                      *
 ********************************************************************/
void anlegen2(void)

/********************************************************************
 * Wenn eine Textwoerterliste angegeben wird, die noch nicht        *
 * existiert, wird sie von dieser Funktion angelegt                 *
 ********************************************************************/


{  char help[3];
	if ((special2 = fopen (namespecial2,"w+"))==NULL) {fehler(1,namespecial2);}
	fprintf(special2,"A\n");/*Dummyeintrag, der von %s nicht gelesen wird!!*/
	fclose(special2);
	if ((special2 = fopen (namespecial2,"rb"))==NULL) {fehler(1,namespecial2);}
	writetext=TRUE;

}/*Ende anlegen2*/


/********************************************************************
 *                    anlegenerg                                    *
 ********************************************************************/
int anlegenerg(char *ergname)

/********************************************************************
 * Wenn die Ergaenzungswoerterliste noch nicht existiert, wird sie  *
 * von dieser Funktion angelegt.                                    *
 ********************************************************************/         

{  char help[3];
	if ((ergfile = fopen (ergname,"w+"))==NULL) {return(FALSE);}
	fprintf(ergfile," \n");/*Dummyeintrag, der von %s nicht gelesen wird!!*/
	fclose(ergfile);

	if ((ergfile = fopen (ergname,"rb+"))==NULL) {return(FALSE);}
	return(TRUE);
}/*Ende anlegenerg*/


/********************************************************************
 *                    einlesen                                      *
 ********************************************************************/

/* Zum ausprobieren, ob die Listen beschreibbar sind, keinen Binaermodus
	verwenden!*/


void einlesen (char *pfad)

/**********************************************************************
 * In diesem Unterprogramm werden die Informationen aus den Hilfs-    *
 * dateien eingelesen und alle bnenoetigten Dateien geoeffnet.                   *
 **********************************************************************/

{

FILE *liste ;
int i,j,help,erfolg;
long dummy,ii;
char c,*hilfspoint,dummyname[150];

/**************************************************************************/
	if((liste=fopen(vorname,"rb"))==NULL) {fehler(1,vorname);}
  fseek(liste,0,SEEK_END);
  datpointvor=NULL;
#if TC
	if ((vorsilbemem=(char*)farmalloc((unsigned long)(ftell(liste)+2)*sizeof(char)))==NULL){
#ifdef GERMAN
		fprintf(stderr,"\nZu wenig Speicher!\n");exit(2);
#else
		fprintf(stderr,"\nNot enough memory!\n");exit(2);
#endif
	}/*Ende if*/
#else
	if ((vorsilbemem=(char*)malloc((size_t)(ftell(liste)+2)*sizeof(char)))==NULL){
#ifdef GERMAN
		fprintf(stderr,"\nZu wenig Speicher!\n");exit(2);
#else
		fprintf(stderr,"\nNot enough memory!\n");exit(2);
#endif
	}/*Ende if*/
#endif

	fclose(liste);
	ii=0;
	i=0;
	help=0;

	if((liste=fopen(vorname,"r"))==NULL) {fehler(1,vorname);}
	while(fgets(dummyname,150,liste)!=NULL){  /*fgets liest \n mit*/
	  if (i==help) {

#if TC
				if((datpointvor=(long*)farrealloc((void*)datpointvor,(unsigned long)((help+50)*sizeof(long))))==NULL){
#ifdef GERMAN
					fprintf(stderr,"\nZu wenig Speicher!\n");
#else
					fprintf(stderr,"\nNot enough memory!\n");
#endif
					exit(2);
				}
#else
				if((datpointvor=(long*)realloc((void*)datpointvor,(size_t)((help+50)*sizeof(long))))==NULL){
#ifdef GERMAN
					fprintf(stderr,"\nZu wenig Speicher!\n");
#else
					fprintf(stderr,"\nNot enough memory!\n");
#endif
					exit(2);
				}
#endif
				help+=50;

			}/*Ende if*/

	  datpointvor[i++]=ii;
	  for(j=0;(vorsilbemem[ii]=dummyname[j])!='\0';j++){
		if((unsigned char)vorsilbemem[ii]==10){vorsilbemem[ii]='\0';}
		if((unsigned char)vorsilbemem[ii]==13){vorsilbemem[ii]='\0';}
		ii++;
	  }

	}/*Ende while*/
	anzahl_vorsilben=i;
	fclose(liste);


/**************************************************************************/
	i=0;
	if((keyfile=fopen(keyname,"rb"))==NULL) {fehler(1,keyname);}
  fseek(keyfile,0,SEEK_END);

#if TC
	if ((keybereich=(char*)farmalloc((unsigned long)(ftell(keyfile)+2)*sizeof(char)))==NULL){
#ifdef GERMAN
		fprintf(stderr,"\nZu wenig Speicher!\n");exit(2);
#else
		fprintf(stderr,"\nNot enough memory!\n");
#endif
	}/*Ende if*/
#else
	if ((keybereich=(char*)malloc((size_t)(ftell(keyfile)+2)*sizeof(char)))==NULL){
#ifdef GERMAN
		fprintf(stderr,"\nZu wenig Speicher!\n");exit(2);
#else
		fprintf(stderr,"\nNot enough memory!\n");
#endif
	}/*Ende if*/
#endif

	rewind(keyfile);
	while((c=fgetc(keyfile))!=(char)EOF){
		if(c==13){c='\0';}
		if(c==10){c='\0';}

		keybereich[i++]=c;
	}/*Ende while*/
		keybereich[i]='A';
		maxkey=&keybereich[i];  /*Dieser String liegt schon ausserhalb */
										/*von maxkey, ist aber noch definier*/
		keybereich[i+1]='\0';

									/*texspell.key*/
		fclose(keyfile);
/***************************************************************************/
	i=0;
	j=0;
	if ((liste = fopen (endname,"r"))==NULL) {fehler(1,endname);} /*texspell.end da?*/


	 while(fscanf(liste,"%s",&endungsliste[i][j])!=EOF){

	 if(endungsliste[i][j][0]=='-'){endungsliste[i][j][0]='\0';}

		if (endungsliste[i][j][0]=='*'){
			i++;
			j=0;
			if (i>20){fehler(7,"");}
		}else{
			j++;
		}/*Ende if*/




	 }/*Ende while*/

	fclose(liste);
	i=0;
/***************************************************************************/

	if ((liste = fopen (datname,"r"))==NULL) {fehler(1,datname);} /*texspell.dat da?*/
	befehl1=NULL;
	befehl2=NULL;

	while(fgets(linein,250,liste)!=NULL){
		if(linein[0]=='%'){continue;}
		if((befehl1=(befehlswort*)realloc(befehl1,(i+1)*sizeof(befehlswort)))==NULL){
			fehler(5,"");
		}
		if((befehl2=(befehlswort*)realloc(befehl2,(i+1)*sizeof(befehlswort)))==NULL){
			fehler(5,"");
		}

		strcpy(befehl1[i],strtok(linein," \n"));
      hilfspoint=strtok(NULL," \n");

		if (hilfspoint==NULL) {
			strcpy(befehl2[i],"\n");
		}else{
			strcpy(befehl2[i],hilfspoint);
		}/*Ende if*/
		if (befehl1[i]!=NULL) {i++;}

	}/*Ende while */


	anzahl_befehle=i;

	fclose(liste);

/***************************************************************************/

	if ((wortliste = fopen (listname,"rb"))==NULL) {fehler(1,listname);}

		leseposspecial(listname,wortliste,&listmem,&datpoint,position,
		&filesize,&platz);

		fclose(wortliste);

/***************************************************************************/

	if ((logfile   = fopen ("texspell.log","w+"))==NULL) {fehler(1,"texspell.log");}
	/*logfile oeffnen*/

/***************************************************************************/

	if (strcmp(namespecial,"")!=0){                         /*Benutzerliste?*/
		writebenutzer=TRUE;

		if((special   = fopen (namespecial,"r+"))==NULL){   /*schreiben erlaubt?*/

			writebenutzer=FALSE;                             /*wenn nicht, dann*/
																			 /*Liste zum lesen*/
																			 /*oeffnen*/

			if ((special   = fopen (namespecial,"r"))==NULL) {  /*Benutzerliste oeffnen*/
					strcpy(dummyname,namespecial);
				if(strcspn(namespecial,":"VERZEICHNISTRENNER)==strlen(namespecial)){    /*nicht da? */
					strcpy(dummyname,pfad);
					strcat(dummyname,VERZEICHNISTRENNER);
					strcat(dummyname,namespecial);
				}/*ende if*/
			}/*Ende if*/
		}else{
			help=fgetc(special);
			rewind(special);
			if(fputc(help,special)==EOF){writebenutzer=FALSE;}
			if(fclose(special)==EOF){writebenutzer=FALSE;}
												 /*wenn nicht, dann*/
			special   = fopen (namespecial,"r+");
		}/*Ende if else*/
		if(special!=NULL){

		fclose(special);    /* Datei zum nur-lesen oeffnen*/
		if ((special   = fopen (namespecial,"rb"))==NULL) {fehler(1,namespecial);}
		leseposspecial(namespecial,special,&listmemspecial,&datpointspecial,posspecial,
		&filesizespecial,&platzspecial);   /*Markierungen einlesen*/
		fclose(special);

		}else{

					 /****************************************/

			writebenutzer=TRUE;

			if((special   = fopen (dummyname,"r+"))==NULL){   /*schreiben erlaubt?*/

				writebenutzer=FALSE;                             /*wenn nicht, dann*/
																				 /*Liste zum lesen*/
																				 /*oeffnen*/

				if ((special   = fopen (dummyname,"r"))==NULL) {  /*Benutzerliste oeffnen*/

																					  /*nicht da? Meldung*/

#ifdef GERMAN
						fprintf(stderr,"Die Datei '%s' ist nicht da. \n",namespecial);
#else
						fprintf(stderr,"The file '%s' does not exist. \n",namespecial);
#endif
					do {

#ifdef GERMAN
						fprintf(stderr,"(A)nlegen, (o)hne Benutzerliste weitermachen, (Q)uit, (h)elp?\n?");
						rewind(stdin);
						scanf("%1c",&c);
						c=tolower(c);
#else
						fprintf(stderr,"(c)reate file, continue (w)ithout userfile, (Q)uit, (h)elp?\n?");
						rewind(stdin);
						scanf("%1c",&c);
						c=tolower(c);
						if(c=='c'){
							c='a';
						}else if(c=='w'){
							c='o';
						}/*Ende if*/


#endif
						if(c=='h'){
#ifdef GERMAN
							fprintf(stdout,"\nSie haben in der Kommandozeile eine W"oE"rterliste angegeben,\n");
							fprintf(stdout,"die noch nicht existiert.\n");
							fprintf(stdout,"(A)nlegen erzeugt diese Liste,\n");
							fprintf(stdout,"wenn Sie (o)hne Benutzerliste weitermachen, ignoriert TeXSPELL\n");
							fprintf(stdout,"diese Angabe.\n\n");
#else
							fprintf(stdout,"\nOn the command line, you\'ve specified a word list that\n");
							fprintf(stdout,"doesn\'t exist.\n");
							fprintf(stdout,"(c)reate creates this list,\n");
							fprintf(stdout,"if you continue (w)ithout this list, TeXSPELL will\n");
							fprintf(stdout,"ignore this list.\n\n");

#endif
						}/*Ende if*/
					}while ((c!='a') && (c!='o') && (c!='q'));
					switch (c){
						case 'q':
									fclose(ein);
									fclose(aus);
									fclose(wortliste);         /*Ende*/
									fclose(logfile);
									fclose(special);

									exit(1);
									break;
						case 'o':strcpy(namespecial,"");    /*keine Benutzerliste*/
									break;
						case 'a':anlegen();
									break;                     /*Liste anlegen*/
					}/*Ende switch*/
				}else{
					strcpy(namespecial,dummyname);    /*neuer name nur dann, wenn die*/
				}/*Ende if*/                         /*Liste schon exisiiert!*/
			}else{
				strcpy(namespecial,dummyname);
				help=fgetc(special);
				rewind(special);
				if(fputc(help,special)==EOF){writebenutzer=FALSE;}
				if(fclose(special)==EOF){writebenutzer=FALSE;}
													 /*wenn nicht, dann*/
				special   = fopen (dummyname,"r+");
			}/*Ende if else*/


		fclose(special); /* Datei zum nur-lesen oeffnen*/
		if(namespecial[0]!='\0'){if ((special   = fopen (namespecial,"rb"))==NULL) {fehler(1,namespecial);}}

		leseposspecial(namespecial,special,&listmemspecial,&datpointspecial,posspecial,
		&filesizespecial,&platzspecial);   /*Markierungen einlesen*/
		fclose(special);

		 }/*ende if*/
	}/*Ende if*/

/***************************************************************************/


	if (strcmp(namespecial2,"")!=0){
		writetext=TRUE;

		if ((special2   = fopen (namespecial2,"r+"))==NULL) { /*schreiben moeglich?*/

			writetext=FALSE;          /*Wenn nicht, dann verbieten*/

			if ((special2   = fopen (namespecial2,"r"))==NULL) {
					strcpy(dummyname,namespecial2);
				if(strcspn(namespecial2,":"VERZEICHNISTRENNER)==strlen(namespecial2)){                                                            /*nicht da? */
					strcpy(dummyname,pfad);
					strcat(dummyname,VERZEICHNISTRENNER);
					strcat(dummyname,namespecial2);
				}/*Ende if*/
			}/*Ende if*/
		}else{
			help=fgetc(special2);
			rewind(special2);
			if(fputc(help,special2)==EOF){writetext=FALSE;}                             /*wenn nicht, dann*/
			if(fclose(special2)==EOF){writetext=FALSE;}
												 /*wenn nicht, dann*/
			special2   = fopen (namespecial2,"r+");

		}/*Ende if*/
		if(special2!=NULL){
		fclose(special2);   /* Datei zum nur-lesen oeffnen*/
		if ((special2   = fopen (namespecial2,"rb"))==NULL) {fehler(1,namespecial2);}

			leseposspecial(namespecial2,special2,&listmemspecial2,&datpointspecial2,posspecial2,
			&filesizespecial2,&platzspecial2);

			fclose(special);
		}else{

						/***************************/

			writetext=TRUE;

			if ((special2   = fopen (dummyname,"r+"))==NULL) { /*schreiben moeglich?*/

				writetext=FALSE;          /*Wenn nicht, dann verbieten*/

				if ((special2   = fopen (dummyname,"r"))==NULL) {
#ifdef GERMAN
						fprintf(stderr,"Die Datei '%s' ist nicht da. \n",namespecial2);
					do {
						fprintf(stderr,"(A)nlegen, (o)hne Textw"oE"rterliste weitermachen, (Q)uit, (h)elp?\n?");
						rewind(stdin);
						scanf("%1c",&c);
						c=tolower(c);
#else
						fprintf(stderr,"The file '%s' doesn\'t exist. \n",namespecial2);
					do {
						fprintf(stderr,"(c)reate file, continue (w)ithout textwordlist, (Q)uit, (h)elp?\n?");
						rewind(stdin);
						scanf("%1c",&c);
						c=tolower(c);
						if(c=='c'){
							c='a';
						}else if(c=='w'){
							c='o';
						}/*Ende if*/


#endif
						if(c=='h'){
#ifdef GERMAN
							fprintf(stdout,"\nSie haben in der Kommandozeile eine W"oE"rterliste angegeben,\n");
							fprintf(stdout,"die noch nicht existiert.\n");
							fprintf(stdout,"(A)nlegen erzeugt diese Liste,\n");
							fprintf(stdout,"wenn Sie (o)hne Textw"oE"rterliste weitermachen, ignoriert TeXSPELL\n");
							fprintf(stdout,"diese Angabe.\n\n");
#else
							fprintf(stdout,"\nOn the command line you have specified a word list that\n");
							fprintf(stdout,"doesn\'t exist.\n");
							fprintf(stdout,"(c)reate creates this list,\n");
							fprintf(stdout,"if you continue (w)ithout this list, TeXSPELL will\n");
							fprintf(stdout,"ignore this list.\n\n");
#endif

						}/*Ende if*/

					}while ((c!='a') && (c!='o') && (c!='q'));
					switch (c){
						case 'q':
									fclose(ein);
									fclose(aus);
									fclose(wortliste);
									fclose(logfile);
									fclose(special);
									fclose(special2);

									exit(1);
									break;
						case 'o':strcpy(namespecial2,"");
									break;
						case 'a':anlegen2();
									break;
					}/*Ende switch*/
				}else{
					strcpy(namespecial2,dummyname);
				}/*Ende if*/
			}else{
				strcpy(namespecial2,dummyname);
				help=fgetc(special2);
				rewind(special2);
				if(fputc(help,special2)==EOF){writetext=FALSE;}/*wenn nicht, dann*/
				if(fclose(special2)==EOF){writetext=FALSE;}
													 /*wenn nicht, dann*/
				special2   = fopen (dummyname,"r+");

			}/*Ende if*/
		fclose(special2);
		if(namespecial2[0]!='\0'){if ((special2   = fopen (namespecial2,"rb"))==NULL) {fehler(1,namespecial2);}}

			leseposspecial(namespecial2,special2,&listmemspecial2,&datpointspecial2,posspecial2,
			&filesizespecial2,&platzspecial2);
		fclose(special2);

		}/*Ende if*/
	}/*Ende if*/

/***************************************************************************/


	if (strcmp(ergname,"")!=0){
		erfolg=FALSE;

				strcpy(dummyname,pfad);
				strcat(dummyname,VERZEICHNISTRENNER);
				strcat(dummyname,ergname);

		if ((ergfile   = fopen (dummyname,"r+"))!=NULL) { /*Datei im TeXSPELL-*/
			erfolg=TRUE;                                   /*verzeichnis?*/
			help=fgetc(ergfile);
			rewind(ergfile);
			if(fputc(help,ergfile)==EOF){erfolg=FALSE;}
			if(fclose(ergfile)==EOF){erfolg=FALSE;}
			if(erfolg==TRUE){
				strcpy(ergname,dummyname);
				ergfile   = fopen (dummyname,"r+");
			}/*Ende if*/
		}/*endeif*/

		if(erfolg==FALSE){
			if ((ergfile   = fopen (ergname,"r+"))!=NULL) { /*Datei im aktuellen*/
																			/*Verzeichnis?*/
				erfolg=TRUE;
				help=fgetc(ergfile);
				rewind(ergfile);
				if(fputc(help,ergfile)==EOF){erfolg=FALSE;}
				if(fclose(ergfile)==EOF){erfolg=FALSE;}
				if(erfolg==TRUE){
					ergfile   = fopen (ergname,"r+");
				}/*Ende if*/
			}/*endeif*/
		}/*Endif*/
						 /*Datei im TeXSPELL-*/
		if(erfolg==FALSE){                         /*verzeichnis anlegen*/
		  erfolg=anlegenerg(&dummyname[0]);
			if(erfolg==TRUE){
				strcpy(ergname,dummyname);
			}/*Ende if*/
		}/*endif*/

		if(erfolg==FALSE){                         /*Datei im aktuellen Verzeichnis*/
		  erfolg=anlegenerg(&ergname[0]);          /*anlegen*/
		}/*endif*/

		if(erfolg==FALSE){        /*Wenn gar nichts klappt: Fehlermeldung*/
			fehler(1,ergname);
		}else{

		fclose(ergfile);    /* Datei zum nur-lesen oeffnen*/
		if ((ergfile   = fopen (ergname,"rb"))==NULL) {fehler(1,ergname);}

		leseposspecial(ergname,ergfile,&ergmem,&datpointerg,poserg,
		&filesizeerg,&platzerg);

		fclose(ergfile);

		}/*Ende if*/

	}/*Ende if*/

/***************************************************************************/

	linein[0]='\0'; /* Variable wieder loeschen!!!*/

}/*Ende einlesen */


/********************************************************************
 *                ueberlesen                                        *
 ********************************************************************/


int ueberlesen (void){

/********************************************************************
 * Dieses Unterprogramm ueberpeuft, ob der Befehl, auf den point    *
 * zeigt, in der Befehlsliste steht. Wenn ja, dann wird die Nummer  *
 * des Befehls zurueckgegeben, sonst eine 0.                        *
 ********************************************************************/

int i;

	 i=0;

    while ( (i<anzahl_befehle) && (strncmp(point,befehl1[i],strlen(befehl1[i]))!=0) ){
	 i++ ; }


    return(i);

}/*Ende ueberlesen*/



/************************************************************
 *                     kontrolle_ignoriert                  *
 ************************************************************/


int kontrolle_ignoriert (void)

/************************************************************
 * Uberpeuft, ob das momentane Wort vorher schon mal        *
 * ignoriert worden ist.                                    *
 ************************************************************/

{int i=0,j;

	do {
		j=strcmp(wort,ignoriert[i++]);
	}while ((j!=0) && (i<anzahl_ignoriert));

  return(j);

}/*Ende kontrolle_ignoriert*/

/************************************************************
 *                     kontrolle_aufgenommen                *
 ************************************************************/

int kontrolle_aufgenommen (void)

/************************************************************
 * Ueberpeuft, ob das momentane Wort schon in die Standard- *
 * liste aufgenommen worden ist, aber noch nicht in die     *
 * Liste geschrieben worden ist.                            *
 ************************************************************/


{int i=0,j;

	do {
		j=strcmp(wort,aufgenommen[i++]);
	}while ((j!=0) && (i<anzahl_aufgenommen));

  return(j);

}/*Ende kontrolle_ignoriert*/

/************************************************************
 *                     kontrollespecial                    *
 ************************************************************/

int kontrollespecial (void)

/************************************************************
 * Ueberpeuft, ob das momentane Wort schon in die Benutzer- *
 * liste aufgenommen worden ist, aber noch nicht in die     *
 * Liste geschrieben worden ist.                            *
 ************************************************************/


{int i=0,j;

	do {
		j=strcmp(wort,aufgenommenspecial[i++]);
	}while ((j!=0) && (i<anzahl_aufgenommenspecial));

  return(j);

}/*Ende kontrolle_special*/

/************************************************************
 *                     kontrollespecial2                    *
 ************************************************************/

int kontrollespecial2 (void)


/************************************************************
 * Ueberpeuft, ob das momentane Wort schon in die Text-     *
 * liste aufgenommen worden ist, aber noch nicht in die     *
 * Liste geschrieben worden ist.                            *
 ************************************************************/


{int i=0,j;

	do {
		j=strcmp(wort,aufgenommenspecial2[i++]);
	}while ((j!=0) && (i<anzahl_aufgenommenspecial2));

  return(j);

}/*Ende kontrolle_special2*/

/************************************************************
 *                     endungen                             *
 ************************************************************/
int endungen (char *endung,unsigned char markierung)

/********************************************************************
 * Diese Funktion ueberprueft, ob das letzte Zeichen des momentanen *
 * Lexikoneintrags (das in markierung uebergeben wird), fuer ein    *
 * Endung steht. Wenn ja, dann wird ein Zeiger auf diese Endung     *
 * zurueckgegeben                                                   *
 ********************************************************************/

{  int i=1,nummer,j=0;

	if ((tiefe>2) || ((tiefe==2)&&(norekur==0))){ /*bei zusammengestzten */
																/* Woertern auch ueberpruefen*/
																/*ob der Wortsztamm alleine*/
																/*(ohne Endung) im Wort*/
																/*vorkommt*/
		i=strcmp(endung,"");
	}/*Ende if*/

	if(i==0){                                     /*Wenn nicht, dann ganz*/
																 /*normal weiter*/
		return(i);
	}else{
		nummer=254-markierung;
		while ((i!=0)&&(endungsliste[nummer][j][0]!='*')){
			i=strcmp(endung,endungsliste[nummer][j]);
			j++;
		}/*Ende while*/
		return i;
	}/*Ende if*/

}/*Ende endungen*/

/******************************************************************
 *                    Vorsilben                                   *
 ******************************************************************/
int vorsilben(char silbe[250])
{int tief,hoch,mitte,i=1;
char *puffer,dummy;

	dummy=silbe[0];
	silbe[0]=neutolow(silbe[0]);
	tief=0;     /*binaeres */
	hoch=anzahl_vorsilben-1;   /*suchen*/
	mitte=hoch/2+tief/2;
	while((hoch>=tief) && (i!=0)) {
		puffer=(char*)(vorsilbemem+*(datpointvor+mitte));

		i=strcmp(puffer,silbe);

		if (i<0) {tief=mitte+1;}
		else if (i>0) {hoch=mitte-1;}

		mitte=tief/2+hoch/2+(tief%2+hoch%2)/2;
	}/*Ende while*/

	silbe[0]=dummy;
	return i;

}/*Ende vorsilben*/



/************************************************************
 *                     such                                 *
 ************************************************************/

int such  (char suchwort[250])

/**********************************************************************
 * Kernstueck des Programms: Das Wort suchwort wird in den Listen     *
 * gesucht. Wenn es gefunden wird, liefert such 0 zurueck.            *
 * Das Programm ruft sich rekursiv auf.                               *
 **********************************************************************/

{  char *puffer,zwischen,dummy[250],*dumpoint,puffer2[250],
			*suchwort2;
	int i=0,j,k,l,flag=-1,wortlen,markiert=0,lexlen,pos;
	unsigned long alt;
	signed long hoch, tief,mitte,mittespecial,mittespecial2,mitteerg;


	/*unbedingt signed Variablen, sonst bei tief=0; tief=tief-1 Fehler*/

		if (strlen(suchwort)<=1) {return(0);}              /*Suche sinnvoll?*/
		tiefe++;                                           /*Rekursionstiefe erhoehen*/
		while(flag==-1){                                   /*flag==0 ==> Suche abbrechen*/
			i=-1;                                           /*Wort noch nicht gefunden*/
/****************************************************************************/
			tief=position[(unsigned char)suchwort[0]];
			hoch=position[(unsigned char)suchwort[0]+1];         /*binaeres Suchen*/
			mitte=hoch/2+tief/2;                                 /*in der         */
			while((hoch>=tief) && (i!=0)) {          /*Standardliste  */

						 /*     strcpy(puffer,(char*)(listmem+*(datpoint+mitte)));*/
						 puffer=(char*)(listmem+*(datpoint+mitte));


					lexlen=strlen(puffer);
					if (neuisalpha(puffer[lexlen-1])==0){        /*wort markiert?*/

						if(puffer[lexlen-1]==''){                                       /*Wortliste?*/

							lexlen=strcspn(puffer,",");

							if((i=strncmp(puffer,suchwort,lexlen))==0){
								suchwort2=&suchwort[lexlen];    /*Rest von Wort*/

								dumpoint=&puffer[lexlen+1];            /*Zeichen HINTER*/
																					/*Komma*/
								lexlen=strcspn(dumpoint,",");

								do{
				
									if((strncmp(dumpoint,suchwort2,lexlen-1))==0){                                                                                                                    /*dann Endungen*/
										i=endungen(&suchwort2[lexlen-1],dumpoint[lexlen-1]);
									}/*ende if*/

									dumpoint=&dumpoint[lexlen+1];            /*Zeichen HINTER*/
																						/*Komma*/
									lexlen=strcspn(dumpoint,",");

								}while ((strlen(dumpoint)>1) && (i!=0)) ;

							}



						}else{
							if((strncmp(puffer,suchwort,lexlen-1))==0){                                                                                                                       /*dann Endungen*/
								i=endungen(&suchwort[lexlen-1],puffer[lexlen-1]);
							}/*ende if*/
							if(i!=0){i=strcmp(puffer,suchwort);}
		  }/*Ende if*/
					}else{

					i=strcmp(puffer,suchwort);                    /*sonst wie gehabt*/

					}/*Ende if else*/

					if (i<0) {tief=mitte+1;}
					else if (i>0) {hoch=mitte-1;}

	       mitte=tief/2+hoch/2+(tief%2+hoch%2)/2;
			}/*Ende while*/

/****************************************************************************/
				if(i!=0){      /* Ergnzungsliste verwenden?*/


					tief=poserg[(unsigned char)suchwort[0]];     /*binaeres */
					hoch=poserg[(unsigned char)suchwort[0]+1];   /*suchen*/
					mitteerg=hoch/2+tief/2;
					while((hoch>=tief) && (i!=0)) {
								 /*     strcpy(puffer,(char*)(ergmem+*(datpointerg+mitteerg)));*/
						 puffer=(char*)(ergmem+*(datpointerg+mitteerg));

							i=strcmp(puffer,suchwort);

							if (i<0) {tief=mitteerg+1;}
							else if (i>0) {hoch=mitteerg-1;}

							mitteerg=tief/2+hoch/2+(tief%2+hoch%2)/2;
					}/*Ende while*/

				}/*Ende if*/
/*****************************************************************************/
				if(i!=0) {i=kontrolle_ignoriert();}else{tiefe--;return(0);}
				if(i!=0) {i=kontrolle_aufgenommen();}else{tiefe--;return(0);}
/****************************************************************************/

				if((i!=0) && (strcmp(namespecial,"")!=0)){  /*Benutzerliste verwenden?*/


					tief=posspecial[(unsigned char)suchwort[0]];     /*binaeres */
					hoch=posspecial[(unsigned char)suchwort[0]+1];   /*suchen*/
					mittespecial=hoch/2+tief/2;
					while((hoch>=tief) && (i!=0)) {
						 /*                     strcpy(puffer,(char*)(listmemspecial+*(datpointspecial+mittespecial)));*/
						 puffer=(char*)(listmemspecial+*(datpointspecial+mittespecial));

/************************ Anfang eingefuegt ******************************/
					lexlen=strlen(puffer);
					if (neuisalpha(puffer[lexlen-1])==0){        /*wort markiert?*/
						if(puffer[lexlen-1]==''){                                       /*Wortliste?*/

							lexlen=strcspn(puffer,",");

							if((i=strncmp(puffer,suchwort,lexlen))==0){
								suchwort2=&suchwort[lexlen];    /*Rest von Wort*/

								dumpoint=&puffer[lexlen+1];            /*Zeichen HINTER*/
																					/*Komma*/
								lexlen=strcspn(dumpoint,",");

								do{
				
									if((strncmp(dumpoint,suchwort2,lexlen-1))==0){                                                                                                                    /*dann Endungen*/
										i=endungen(&suchwort2[lexlen-1],dumpoint[lexlen-1]);
									}/*ende if*/

									dumpoint=&dumpoint[lexlen+1];            /*Zeichen HINTER*/
																						/*Komma*/
									lexlen=strcspn(dumpoint,",");

								}while ((strlen(dumpoint)>1) && (i!=0)) ;

							}



						}else{
							if((strncmp(puffer,suchwort,lexlen-1))==0){                                                                                                                       /*dann Endungen*/
								i=endungen(&suchwort[lexlen-1],puffer[lexlen-1]);
							}/*ende if*/
							if(i!=0){i=strcmp(puffer,suchwort);}
		  }/*Ende if*/
					}else{
/********************* Ende eingefuegt ***********************************/

							i=strcmp(puffer,suchwort);
					}/*ende if*/

							if (i<0) {tief=mittespecial+1;}
							else if (i>0) {hoch=mittespecial-1;}

							mittespecial=tief/2+hoch/2+(tief%2+hoch%2)/2;
					}/*Ende while*/

				}/*Ende if*/

/****************************************************************************/
				if(i!=0) {i=kontrollespecial();}else{tiefe--;return(0);}

/****************************************************************************/

				if((i!=0) && (strcmp(namespecial2,"")!=0)){      /*Textliste verwenden?*/


					tief=posspecial2[(unsigned char)suchwort[0]];     /*binaeres */
					hoch=posspecial2[(unsigned char)suchwort[0]+1];   /*suchen*/
					mittespecial2=hoch/2+tief/2;
					while((hoch>=tief) && (i!=0)) {
						  /*                    strcpy(puffer,(char*)(listmemspecial2+*(datpointspecial2+mittespecial2)));*/
						 puffer=(char*)(listmemspecial2+*(datpointspecial2+mittespecial2));
/************************ Anfang eingefuegt ******************************/
					lexlen=strlen(puffer);
					if (neuisalpha(puffer[lexlen-1])==0){        /*wort markiert?*/
						if(puffer[lexlen-1]==''){                                       /*Wortliste?*/

							lexlen=strcspn(puffer,",");

							if((i=strncmp(puffer,suchwort,lexlen))==0){
								suchwort2=&suchwort[lexlen];    /*Rest von Wort*/

								dumpoint=&puffer[lexlen+1];            /*Zeichen HINTER*/
																					/*Komma*/
								lexlen=strcspn(dumpoint,",");

								do{
				
									if((strncmp(dumpoint,suchwort2,lexlen-1))==0){                                                                                                                    /*dann Endungen*/
										i=endungen(&suchwort2[lexlen-1],dumpoint[lexlen-1]);
									}/*ende if*/

									dumpoint=&dumpoint[lexlen+1];            /*Zeichen HINTER*/
																						/*Komma*/
									lexlen=strcspn(dumpoint,",");

								}while ((strlen(dumpoint)>1) && (i!=0)) ;

							}



						}else{
							if((strncmp(puffer,suchwort,lexlen-1))==0){                                                                                                                       /*dann Endungen*/
								i=endungen(&suchwort[lexlen-1],puffer[lexlen-1]);
							}/*ende if*/
							if(i!=0){i=strcmp(puffer,suchwort);}
		  }/*Ende if*/
					}else{
/********************* Ende eingefuegt ***********************************/

							i=strcmp(puffer,suchwort);
					}/*Ende if*/

							if (i<0) {tief=mittespecial2+1;}
							else if (i>0) {hoch=mittespecial2-1;}

							mittespecial2=tief/2+hoch/2+(tief%2+hoch%2)/2;
					}/*Ende while*/

				}/*Ende if*/
/****************************************************************************/

				if(i!=0) {i=kontrollespecial2();}
/****************************************************************************/

				if ((vorschlaege==-1) && (i!=0) && (markiert==0) && (tiefe==1)){  /*Markierungen fuer*/
																			/*vorschlag() setzen*/
					aktpos=mitte;
					if(strcmp(namespecial,"")!=0){specialpos=mittespecial; }
					if(strcmp(namespecial2,"")!=0){specialpos2=mittespecial2;}
					markiert=-1;

				}/*Ende if*/

/****************************************************************************/
/****************************************************************************/

				if (i==0) {                                 /*Wort gefunden?*/
					flag=0;                                  /*dann Suche abbrechen*/
				}else if (neuislow(suchwort[0])!=0){
					if(((wortlen=strlen(suchwort))>5) && (norekur==0)){
						l=wortlen-2;                          /*die ersten zwei */
																		  /*Buchstaben      */
					 do{                                     /*auslassen       */
						do {
							dumpoint=&suchwort[wortlen-l];     /*Zeiger auf Anfang des Wortteils*/
							strncpy(dummy,dumpoint,l+1);              /*Wortteil +\0 kopieren*/
							if(neuislow(dummy[0])==0){         /*Grossbuchstabe mitten */
								i=-1;                                                                     /*im Wort? Dann nicht suchen*/
							}else{                             /*sonst suchen*/
								dummy[0]=neutoup(dummy[0]);        /*erster Buchstabe gross*/
								norekur=-1;                        /*keine weitere Rekursion*/
								i=such(dummy);                     /*Und suchen*/
							}/*Ende if*/
						}while((l-->3)&&(i!=0));              /*l=3 wird noch durchgefuehrt*/


						if (i==0){
							if(Gefunden[tiefe-1][0]=='\0'){
								strcpy(Gefunden[tiefe-1],dummy);     /*fuer spaetere Ausgabe */
																			 /*aufheben*/
								strncpy(dummy,suchwort,wortlen-l-1); /*den Rest kopieren*/
								dummy[wortlen-l-1]='\0';             /*Ende markieren*/
								strcpy(Rest,dummy);
							}else{
								strncpy(dummy,suchwort,wortlen-l-1); /*den Rest kopieren*/
								dummy[wortlen-l-1]='\0';             /*Ende markieren*/
							}/*Ende if*/
							if(tiefe<4){norekur=0;}                           /*Rekursion zulassen*/
							dummy[0]=neutoup(dummy[0]);          /*Grossbuchstaben*/
																			 /*verwenden*/
							strcpy(puffer2,dummy);              /*such veraendert dummy*/
																			 /*darum zwischenspeichern*/
							i=such(dummy);                                   /*suchen*/
							if(i!=0){i=vorsilben(puffer2);}                  /*Vorsilbe?*/

						}/*Ende if i*/
																		  /*Schleife, bis Wort gefunden*/
					 }while((i!=0) && (l>2));                /*oder nur noch 2 Buchstaben zu */
							/*kontollieren*/

					 if((i!=0) && (tiefe>1) && (suchwort[wortlen-1]=='s')){
							suchwort[wortlen-1]='\0';
							if(tiefe<4){norekur=0; }
							suchwort[0]=neutoup(suchwort[0]);
							i=such(suchwort);

					 }/*Ende if*/

					}/*Ende if*/
					flag=0;
				}else{
					suchwort[0]=neutolow(suchwort[0]);
	    }/*Ende if*/
		}/*Ende while*/
				tiefe--;
				return(i);
}/*Ende such  */



/********************************************************************
 *                        aufnehmen                                 *
 ********************************************************************/

void aufnehmen (void)

/********************************************************************
 * In diesem Unterprogramm wird ein unbekanntes Wort in eine der    *
 * Listen aufgenommen.                                              *
 ********************************************************************/

{  FILE *tempin,*tempout;
	char help[250],c,*einfuegen;
	int i;

	if(Rest[0]!='\0'){

		do {
#ifdef GERMAN
			printf("(G)anzes Wort oder nur (u)nbekannten Teil aufnehmen?\n g\r?");
			rewind(stdin);
			scanf("%1c",&c);
			c=tolower(c);
#else
			printf("Add (w)hole word or only (u)nknown part?\n w\r?");
			rewind(stdin);
			scanf("%1c",&c);
			c=tolower(c);
			if(c=='w')c='g';
#endif
		}while ((c!='g') && (c!='u') && (c!='\n'));
		if((c=='g')||(c=='\n')){einfuegen=wort;}else{einfuegen=Rest;}

	}else{
		einfuegen=wort;
	}/*Ende if*/





	if (neuislow(einfuegen[0])==0) {
		
		do {
#ifdef GERMAN
			printf("\nSoll das Wort mit (g)ro"sS"em oder (k)leinem Anfangsbuchstaben aufgenommen werden?\n g\r?");
			rewind(stdin);
			scanf("%1c",&c);
			c=tolower(c);

#else
			printf("\nAdd word with a (c)apital or a (s)mall starting letter?\n c\r?");
			rewind(stdin);
			scanf("%1c",&c);
			c=tolower(c);
			if(c=='c'){
				 c='g';
			}else if(c=='s'){
				 c='k';
			}

#endif
		}while ((c!='g') && (c!='k') && (c!='\n'));
		if (c=='k') {
			fprintf(logfile,"k ");
			einfuegen[0]=neutolow(einfuegen[0]);
		}else{
			fprintf(logfile,"g ");

		}/*Ende if*/
	}/*Ende if*/
		c='s';
		if((writebenutzer==TRUE)&&(writetext==TRUE)){
			do {
#ifdef GERMAN
				printf("\n(S)tandard, (B)enutzer oder (T)extw"oE"rterbuch verwenden?\n %c\r?",defaultliste);
				rewind(stdin);
				scanf("%1c",&c);
				if(c=='\n'){c=defaultliste;}
				c=tolower(c);
#else
				printf("\nUse (s)tandard, (u)ser or (t)extlist?\n %c\r?",defaultliste);
				rewind(stdin);
				scanf("%1c",&c);
				if(c=='\n'){c=defaultliste;}
				if(c=='u'){c='b';}
				c=tolower(c);

#endif

			}while ((c!='s') && (c!='b') && (c!='\n') && (c!='t'));
     }else if((writebenutzer==TRUE)&&(writetext==FALSE)){
			do {
#ifdef GERMAN
				printf("\n(S)tandard oder (B)enutzerw"oE"rterbuch verwenden?\n %c\r?",defaultliste);
				rewind(stdin);
				scanf("%1c",&c);
				if(c=='\n'){c=defaultliste;}
				c=tolower(c);
#else
				printf("\nUse (s)tandard or (u)serlist?\n %c\r?",defaultliste);
				rewind(stdin);
				scanf("%1c",&c);
				if(c=='\n'){c=defaultliste;}
				if(c=='u'){c='b';}
				c=tolower(c);

#endif
			}while ((c!='s') && (c!='b') && (c!='\n'));
	  }else if((writebenutzer==FALSE)&&(writetext==TRUE)){
			do {
#ifdef GERMAN
				printf("\n(S)tandard oder (T)extw"oE"rterbuch verwenden?\n %c\r?",defaultliste);
				rewind(stdin);
				scanf("%1c",&c);
				if(c=='\n'){c=defaultliste;}
				c=tolower(c);
#else
				printf("\nUse (s)tandard or textlist?\n %c\r?",defaultliste);
				rewind(stdin);
				scanf("%1c",&c);
				if(c=='\n'){c=defaultliste;}
				c=tolower(c);

#endif
			}while ((c!='s') && (c!='t') && (c!='\n'));

	  }/*Ende if*/



	if((c=='s')){
			fprintf(logfile,"s ");

			strncpy(aufgenommen[anzahl_aufgenommen++],einfuegen,250);

		if (anzahl_aufgenommen==maxaufgenommen){
			schreibeaufgenommen();
		}/*Ende if*/



	}else if(c=='b'){
			fprintf(logfile,"b ");

			strncpy(aufgenommenspecial[anzahl_aufgenommenspecial++],einfuegen,250);
											if (anzahl_aufgenommenspecial==maxaufgenommenspecial){
			schreibeaufgenommenspecial();
		}/*Ende if-else*/

	}else{
			fprintf(logfile,"t ");

			strncpy(aufgenommenspecial2[anzahl_aufgenommenspecial2++],einfuegen,250);
											if (anzahl_aufgenommenspecial2==maxaufgenommenspecial2){
			schreibeaufgenommenspecial2();
		}/*Ende if-else*/

	}/*Ende if-else*/
}/*Ende aufnehmen */

/********************************************************************
 *                        korrigieren                               *
 ********************************************************************/

void korrigieren (void)

/*********************************************************************
 * Hier wird fuer ein falsch geschriebenes Wort die Korrektur einge- *
 * lesen. Diese Neueingabe wird wieder kontolliert.                  *
 *********************************************************************/


{
char puffer[100];
unsigned char c;
			do {
#ifdef GERMAN
				printf("\nDr"uE"cken Sie eine Buchstabentaste, um einen Vorschlag zu\n"
				uE"bernehmen oder <return> um die Korrektur selbst einzugeben:\n?");
#else
				printf("\nPress a letter key to accept a proposed word,\n"
				"or press <return> to enter the correction by hand:\n?");
#endif
				rewind(stdin);
				scanf("%1c",&c);
				c=tolower(c);
			}while ((c!='\n') && ((c<97) || (c>97-1+anzahlvorschlaege)));
	if(c=='\n'){
#ifdef GERMAN                            /*    ^^^ anzvorschl ist um 1 zu hoch*/
		printf("\n Korrektur: \n");
#else
		printf("\n Correction: \n");
#endif
		rewind(stdin);
		fgets(puffer,100,stdin);
		puffer[strlen(puffer)-1]='\0';
		kontrolle(&puffer[0]);
	}else{
		strcpy(puffer,&vorschlagpuffer[c-(unsigned char)'a'][0]);
#ifdef GERMAN
		printf("\n"UE"bernehme Vorschlag %c: ",c);
#else
		printf("\nAccepting proposition %c: ",c);
#endif

		sprintf(Ausgabepuffer,"%s\n",puffer);
		ausgeben(Ausgabepuffer);
		kontrolle(&puffer[0]);
	}/*Ende if*/
}/*Ende korrigieren */

/********************************************************************
 *                        sinnvoll                                  *
 ********************************************************************/
int sinnvoll(char wort2[250],int k)

/********************************************************************
 * Dieses Unterprogramm ueberprueft, ob das wort2 aehnlich zu wort  *
 * ist. Wenn ja, dann wird 0 zurueckgegeben.                        *
 ********************************************************************/

{  int T[251];
	int i,j,m,n,tj,tj1;
	m=strlen(Rest);
	if(m==0){m=strlen(wort);} /*Wenn Rest vorhanden, dann dessen Laenge verwenden*/

	n=strlen(wort2);
	if(n<3) return(0);
if(m>n){
		if(m<=k) return(0);
		T[0]=0;
		for(j=1;j<=m;j++) T[j]=j;

	for(i=1;i<=n;i++){
		tj1=0;
		for(j=1;j<=m;j++){
			tj=T[j];
			if(wort2[n-i] !=wort[m-j]) tj1++;
			if(tj+1<tj1) tj1=tj+1;
			if(T[j-1]+1<tj1) tj1=T[j-1]+1;
			T[j]=tj1;
			tj1=tj;
		}/*Ende for*/
	}/*Ende for*/
		if(T[m]<=k) return (-1);

	return(0);

}else{

		if(n<=k) return(0);
		T[0]=0;
		for(j=1;j<=n;j++) T[j]=j;

	for(i=1;i<=m;i++){
		tj1=0;
		for(j=1;j<=n;j++){
			tj=T[j];
			if(wort[m-i] !=wort2[n-j]) tj1++;
			if(tj+1<tj1) tj1=tj+1;
			if(T[j-1]+1<tj1) tj1=T[j-1]+1;
			T[j]=tj1;
			tj1=tj;
		}/*Ende for*/
	}/*Ende for*/
		if(T[n]<=k) return (-1);

	return(0);






}/*Ende if*/
}/*Ende sinnvoll*/

/********************************************************************
 *                        vorschlag                                 *
 ********************************************************************/
void vorschlag(void)

/********************************************************************
 * Dieses Unterprogramm durchsucht die Listen und gibt              *
 * Korrekturvorschlaege aus, wenn Woerter gefunden werden, die      *
 * aehnlich zu dem unbekannten Wort sind.                           *
 ********************************************************************/

{int i,j,wortinzeile,len,lexlen,l,nummer,aender,vorsch;
char puffer[250],puffer2[250],puffer3[250],puffer4[250],*pufpoint,*dumpoint;
unsigned char k;
#if TC
	 if(ansisys==TRUE){textcolor(LIGHTMAGENTA);}
#endif

#ifdef GERMAN
	printf("Korrekturvorschl"aE"ge:\n");
#else
	printf("Proposals for correction:\n");
#endif

	anzahlvorschlaege=0;
	wortinzeile=0;
	for(i=0;i<5;i++){
		strcpy(puffer,"");
		if(aktpos-2+i<0){continue;}
		if(aktpos-2+i>=position[255]){continue;}
		strcpy(puffer,(char*)(listmem+*(datpoint+aktpos-2+i)));

		if (neuisalpha(k=puffer[lexlen=strlen(puffer)-1])==FALSE){
						if(k==166){                                      /*Wortliste?*/

							lexlen=strcspn(puffer,",");

							strncpy(puffer2,puffer,j=lexlen);     /*Wortstamm*/
							puffer2[lexlen]='\0';
								dumpoint=&puffer[lexlen+1];            /*Zeichen HINTER*/
																					/*Komma*/
								lexlen=strcspn(dumpoint,",");

								do{
									strcpy(puffer3,puffer2);
									strncat(puffer3,dumpoint,lexlen-1);
									puffer3[j+lexlen-1]='\0';
																					/*dann Endungen*/

										nummer=254-(unsigned char)dumpoint[lexlen-1];
										aender=1;
										do{
											l=0;
											vorsch=0;
											while (endungsliste[nummer][l][0]!='*'){
												strcpy(puffer4,puffer3);
												strcat(puffer4,endungsliste[nummer][l]);

												if((sinnvoll(puffer4,aender)==-1)&&(anzahlvorschlaege<20)){
													if (wortinzeile>0) printf(", ");
													wortinzeile++;
							    vorsch++;

													sprintf(Ausgabepuffer,"%c) %s",anzahlvorschlaege+97,puffer4);
													ausgeben(Ausgabepuffer);
													strncpy(&vorschlagpuffer[anzahlvorschlaege][0],puffer4,50);
													anzahlvorschlaege++;
												}/*Ende if*/


												l++;
											}/*Ende while*/
										}while((vorsch==0)&&(aender++<2));

									dumpoint=&dumpoint[lexlen+1];            /*Zeichen HINTER*/
																						/*Komma*/
									lexlen=strcspn(dumpoint,",");

								}while ((strlen(dumpoint)>1) && (i!=0)) ;




						}else{


										strcpy(puffer2,puffer);     /*Wortstamm*/
										puffer2[lexlen]='\0';
										nummer=254-k;
										aender=1;
			      do{
											l=0;
											vorsch=0;
											while (endungsliste[nummer][l][0]!='*'){
												strcpy(puffer4,puffer2);
												strcat(puffer4,endungsliste[nummer][l]);

												if((sinnvoll(puffer4,aender)==-1)&&(anzahlvorschlaege<20)){
													if (wortinzeile>0) printf(", ");
													wortinzeile++;
							    vorsch++;

													sprintf(Ausgabepuffer,"%c) %s",anzahlvorschlaege+97,puffer4);
													ausgeben(Ausgabepuffer);
													strncpy(&vorschlagpuffer[anzahlvorschlaege][0],puffer4,50);
													anzahlvorschlaege++;
												}/*Ende if*/


												l++;
											}/*Ende while*/
										}while((vorsch==0)&&(aender++<2));
						}/*Ende if Liste */

		}else{
			if((sinnvoll(puffer,3)==-1)&&(anzahlvorschlaege<20)){
				if (wortinzeile>0) printf(", ");
					wortinzeile++;

					sprintf(Ausgabepuffer,"%c) %s",anzahlvorschlaege+97,puffer);
					ausgeben(Ausgabepuffer);
					strncpy(&vorschlagpuffer[anzahlvorschlaege][0],puffer,50);
					anzahlvorschlaege++;
			}/*Ende if*/



		}/*Ende if markiert*/

	}/*Ende for*/
	printf("\n");
/*****************************************************************/
	if(strcmp(namespecial,"")!=0){
		wortinzeile=0;

		for(i=0;i<5;i++){
			strcpy(puffer,"");
		if(specialpos-2+i<0){continue;}
		if(specialpos-2+i>=posspecial[255]){continue;}
			strcpy(puffer,(char*)(listmemspecial+*(datpointspecial+specialpos-2+i)));
		if ((neuisalpha(k=puffer[lexlen=strlen(puffer)-1])==FALSE)&&(puffer[0]!=' ')){
						if(k==166){                                      /*Wortliste?*/      /*^^^^^^^^^^^^^^ Liste leer?*/

							lexlen=strcspn(puffer,",");

							strncpy(puffer2,puffer,j=lexlen);     /*Wortstamm*/
							puffer2[lexlen]='\0';
								dumpoint=&puffer[lexlen+1];            /*Zeichen HINTER*/
																					/*Komma*/
								lexlen=strcspn(dumpoint,",");

								do{
									strcpy(puffer3,puffer2);
									strncat(puffer3,dumpoint,lexlen-1);
									puffer3[j+lexlen-1]='\0';
																					/*dann Endungen*/

										nummer=254-(unsigned char)dumpoint[lexlen-1];
										aender=1;
										do{
											l=0;
											vorsch=0;
											while (endungsliste[nummer][l][0]!='*'){
												strcpy(puffer4,puffer3);
												strcat(puffer4,endungsliste[nummer][l]);


												if((sinnvoll(puffer4,aender)==-1)&&(anzahlvorschlaege<20)){
													if (wortinzeile>0) printf(", ");
													wortinzeile++;
							    vorsch++;

													sprintf(Ausgabepuffer,"%c) %s",anzahlvorschlaege+97,puffer4);
													ausgeben(Ausgabepuffer);
													strncpy(&vorschlagpuffer[anzahlvorschlaege][0],puffer4,50);
													anzahlvorschlaege++;
												}/*Ende if*/

												l++;
											}/*Ende while*/
										}while((vorsch==0)&&(aender++<2));

									dumpoint=&dumpoint[lexlen+1];            /*Zeichen HINTER*/
																						/*Komma*/
									lexlen=strcspn(dumpoint,",");

								}while ((strlen(dumpoint)>1) && (i!=0)) ;




						}else{


										strcpy(puffer2,puffer);     /*Wortstamm*/
										puffer2[lexlen]='\0';
										nummer=254-k;
										aender=1;
			      do{
											l=0;
											vorsch=0;
											while (endungsliste[nummer][l][0]!='*'){
												strcpy(puffer4,puffer2);
												strcat(puffer4,endungsliste[nummer][l]);

												if((sinnvoll(puffer4,aender)==-1)&&(anzahlvorschlaege<20)){
													if (wortinzeile>0) printf(", ");
													wortinzeile++;
							    vorsch++;

													sprintf(Ausgabepuffer,"%c) %s",anzahlvorschlaege+97,puffer4);
													ausgeben(Ausgabepuffer);
													strncpy(&vorschlagpuffer[anzahlvorschlaege][0],puffer4,50);
													anzahlvorschlaege++;
												}/*Ende if*/


												l++;
											}/*Ende while*/
										}while((vorsch==0)&&(aender++<2));
						}/*Ende if Liste */

		}else{

			if((sinnvoll(puffer,3)==-1)&&(anzahlvorschlaege<20)){
				if (wortinzeile>0) printf(", ");
				wortinzeile++;

				sprintf(Ausgabepuffer,"%c) %s",anzahlvorschlaege+97,puffer);
				ausgeben(Ausgabepuffer);
				strncpy(&vorschlagpuffer[anzahlvorschlaege][0],puffer,50);
				anzahlvorschlaege++;
			}/*Ende if*/

		}/*Ende if markiert*/

		}/*Ende for*/
		printf("\n");


	}/*Ende if*/
/**********************************************************************/
	if(strcmp(namespecial2,"")!=0){
		wortinzeile=0;

		for(i=0;i<5;i++){
			strcpy(puffer,"");
		if(specialpos2-2+i<0){continue;}
		if(specialpos2-2+i>=posspecial2[255]){continue;}
			strcpy(puffer,(char*)(listmemspecial2+*(datpointspecial2+specialpos2-2+i)));
		/*********** eingefuegt *************/
		if ((neuisalpha(k=puffer[lexlen=strlen(puffer)-1])==FALSE)&&(puffer[0]!=' ')){
						if(k==166){                                      /*Wortliste?*/      /*^^^^^^^^^^^^^^ Liste leer?*/

							lexlen=strcspn(puffer,",");

							strncpy(puffer2,puffer,j=lexlen);     /*Wortstamm*/
							puffer2[lexlen]='\0';
								dumpoint=&puffer[lexlen+1];            /*Zeichen HINTER*/
																					/*Komma*/
								lexlen=strcspn(dumpoint,",");

								do{
									strcpy(puffer3,puffer2);
									strncat(puffer3,dumpoint,lexlen-1);
									puffer3[j+lexlen-1]='\0';
																					/*dann Endungen*/

										nummer=254-(unsigned char)dumpoint[lexlen-1];
										aender=1;
										do{
											l=0;
											vorsch=0;
											while (endungsliste[nummer][l][0]!='*'){
												strcpy(puffer4,puffer3);
												strcat(puffer4,endungsliste[nummer][l]);

												if((sinnvoll(puffer4,aender)==-1)&&(anzahlvorschlaege<20)){
													if (wortinzeile>0) printf(", ");
													wortinzeile++;
							    vorsch++;

													sprintf(Ausgabepuffer,"%c) %s",anzahlvorschlaege+97,puffer4);
													ausgeben(Ausgabepuffer);
													strncpy(&vorschlagpuffer[anzahlvorschlaege][0],puffer4,50);
													anzahlvorschlaege++;
												}/*Ende if*/


												l++;
											}/*Ende while*/
										}while((vorsch==0)&&(aender++<2));

									dumpoint=&dumpoint[lexlen+1];            /*Zeichen HINTER*/
																						/*Komma*/
									lexlen=strcspn(dumpoint,",");

								}while ((strlen(dumpoint)>1) && (i!=0)) ;




						}else{


										strcpy(puffer2,puffer);     /*Wortstamm*/
										puffer2[lexlen]='\0';
										nummer=254-k;
										aender=1;
			      do{
											l=0;
											vorsch=0;
											while (endungsliste[nummer][l][0]!='*'){
												strcpy(puffer4,puffer2);
												strcat(puffer4,endungsliste[nummer][l]);

												if((sinnvoll(puffer4,aender)==-1)&&(anzahlvorschlaege<20)){
													if (wortinzeile>0) printf(", ");
													wortinzeile++;
							    vorsch++;

													sprintf(Ausgabepuffer,"%c) %s",anzahlvorschlaege+97,puffer4);
													ausgeben(Ausgabepuffer);
													strncpy(&vorschlagpuffer[anzahlvorschlaege][0],puffer4,50);
													anzahlvorschlaege++;
												}/*Ende if*/


												l++;
											}/*Ende while*/
										}while((vorsch==0)&&(aender++<2));
						}/*Ende if Liste */

		}else{

		/************ Ende eingefuegt *****************/

			if((sinnvoll(puffer,3)==-1)&&(anzahlvorschlaege<20)){
				if (wortinzeile>0) printf(", ");
				wortinzeile++;

				sprintf(Ausgabepuffer,"%c) %s",anzahlvorschlaege+97,puffer);
				ausgeben(Ausgabepuffer);
				strncpy(&vorschlagpuffer[anzahlvorschlaege][0],puffer,50);
				anzahlvorschlaege++;
			}/*Ende if*/

		}/*Ende if markiert*/
		}/*Ende for*/
		printf("\n");
	}/*Ende if*/

#if TC
	 if(ansisys==TRUE){normvideo();}
#endif
}/*Ende vorschlag*/


/********************************************************************
 *                        unbekannt                                 *
 ********************************************************************/

void unbekannt (char *anf,char *end,int i)

/*********************************************************************
 * Dieses Unterprogramm wird aufgerufen, wenn ein unbekanntes Wort   *
 * gefunden wird. Der Benutzer muss entscheiden, was damit gemacht   *
 * werden soll.                                                      *
 *********************************************************************/

{
  char c,naechste[110];
  int j,k=0;
  long momentan;
  if(pruef==TRUE){
		fprintf(prueffile,"%s\n",wort);
		j=strlen(fertig);
		strncat(fertig,anf,end-anf);
		fertig[j+end-anf]='\0';
		strcpy(wort,"");
		return ;
  }/*Ende if pruef*/

  if(batchmode==TRUE){
#ifdef GERMAN
		printf("%s: Zeile %i: '%s' ist unbekannt\n",Name_eingabe,zeile,wort);
#else
		printf("%s: Line %i: '%s' is unknown\n",Name_eingabe,zeile,wort);
#endif
		j=strlen(fertig);
		strncat(fertig,anf,end-anf);
		fertig[j+end-anf]='\0';
		strcpy(wort,"");
		return ;
  }/*Ende if pruef*/


  if(abgebrochen==0){

	  switch(i){
		case 0:
#ifdef GERMAN
		  printf("\nUnbekanntes Wort in Zeile %i:\n",zeile);
#else
		  printf("\nUnknown word in line %i:\n",zeile);
#endif
		  Rest[0]='\0';
		  break;
		case 1:

#if TC
			printf("\n");

			 if(ansisys==TRUE){textcolor(GREEN);}
#ifdef GERMAN
			cprintf("Wort mit unbekanntem diakritischem Zeichen in Zeile %i:",zeile);
#else
			cprintf("Word with unknown symbol in line %i:",zeile);
#endif
			 if(ansisys==TRUE){normvideo();}
			printf("\n");

#else



#ifdef GERMAN
		  printf("\nWort mit unbekanntem diakritischem Zeichen in Zeile %i:\n",zeile);
#else
			printf("Word with unknown symbol in line %i:",zeile);
#endif



#endif
		  Rest[0]='\0';
		  break;
		case 2:

#ifdef GERMAN
			printf("\nUnbekannte Wortzusammensetzung in Zeile %i:\n",zeile);
#else
			printf("\nUnknown word composition in line %i:\n",zeile);
#endif

			break;
	  }/*Ende switch*/
	  fputs(lastline,stdout);   /*fputs haengt kein zusaetzliches \n mehr an*/
	  fputs(linein,stdout);
	  momentan=ftell(ein);
	  naechste[0]='\0';
	  fgets(naechste,100,ein);
	  naechste[strlen(naechste)-1]='\n'; /*Falls letzte Zeile eingelesen wurde*/
												 /*fehlt das CR*/

	  puts(naechste);
	  fseek(ein,momentan,SEEK_SET);

#if TC
		printf("\'");
		 if(ansisys==TRUE){textcolor(CYAN);}
		sprintf(Ausgabepuffer,"%s",wort);
		ausgeben(Ausgabepuffer);
		 if(ansisys==TRUE){normvideo();}
		printf("\'",wort);
#else
	  sprintf(Ausgabepuffer,"'%s'",wort);
	  ausgeben(Ausgabepuffer);
#endif

#ifdef GERMAN
	  printf(" ist unbekannt! \n");
	  fprintf(logfile,"\nZeile %i: ",zeile);
	 fprintf(logfile,"'%s' ist unbekannt! ",wort);
#else
	  printf(" is unknown! \n");
	  fprintf(logfile,"\nline %i: ",zeile);
	 fprintf(logfile,"'%s' is unknown! ",wort);

#endif
	 if(i==2){

#ifdef GERMAN
		printf("Bekannte Teile:");
		do{printf(" %s,",Gefunden[k++]);}
		while(Gefunden[k][0]!='\0');
		printf("\nUnbekannt: %s\n",Rest);

#else
		printf("Known parts:");
		do{printf(" %s,",Gefunden[k++]);}
		while(Gefunden[k][0]!='\0');
		printf("\nUnknown: %s\n",Rest);
#endif
	 }/*Ende if*/




	 if(vorschlaege==-1){vorschlag();}

	 do{
#ifdef GERMAN
			 printf("(A)ufnehmen, (I)gnorieren, (K)orrigieren, (L)"oE"schen, (Q)uit? \n i\r?");
			 rewind(stdin);
			 scanf("%1c",&c);
#else
			 printf("(T)ake up, (i)gnore, (c)orrect, (d)elete, (q)uit? \n i\r?");
			 rewind(stdin);
			 scanf("%1c",&c);
			 c=tolower(c);

			 if(c=='t'){
				  c='a';
			 }else if(c=='c'){
				  c='k';
			 }else if(c=='d'){
				  c='l';
			 }


#endif

	 }while (strchr("kalqi\n",tolower(c))==NULL);

  }else{
		c='i';
  }/*Ende if abgebrochen*/



	 if ((tolower(c)=='a')){
		fprintf(logfile,"a ");
		aufnehmen();
		j=strlen(fertig);
		strncat(fertig,anf,end-anf);
		fertig[j+end-anf]='\0';

	}else if (tolower(c)=='k') {
		fprintf(logfile,"k ");
		korrigieren();
		fprintf(logfile,"%s",wort);

	}else if (tolower(c)=='q') {
		fprintf(logfile,"q \n");
		abgebrochen=-1;
		j=strlen(fertig);
		strncat(fertig,anf,end-anf);
		fertig[j+end-anf]='\0';


	}else if (tolower(c)=='l'){
		fprintf(logfile,"l ");

	}else{
		fprintf(logfile," i");

		if(anzahl_ignoriert<maxignoriert){
			strncpy(ignoriert[anzahl_ignoriert++],wort,30);
		}/*Ende if*/

		j=strlen(fertig);
		strncat(fertig,anf,end-anf);
		fertig[j+end-anf]='\0';

	}/*Ende if*/

   strcpy(wort,"");
	printf("\n");

}/*Ende unbekannt */


/********************************************************************
 *                    anfzeichen2                                   *
 ********************************************************************/


int anfzeichen2 (char c)

/********************************************************************
 * Diese Funktion wird aufgerufen, wenn im Text \" gefunden wird,   *
 * und schreibt den richtigen Umlaut nach wort                      *
 ********************************************************************/

{  int i=0,laenge;
	char help;
	switch (c) {
		case 'a':
			strcat(wort,"");
			break;
			/*Ende case 97 */
		case 'e':
			strcat(wort,"");
			break;
			/*Ende case 97 */
		case 'o':
			strcat(wort,"");
			break;
			/*Ende case 111 */
		case 'u':
			strcat(wort,"");
			break;
			/*Ende case 117 */
		case 'A':
			strcat(wort,"");
			break;
			/*Ende case 65 */
		case 'E':
			strcat(wort,"");
			break;
			/*Ende case 97 */
		case 'O':                   /*  */
			strcat(wort,"");
			break;
			/*Ende case 79 */
		case 'U':                  /*  */
			strcat(wort,"");
			break;
			/*Ende case 85 */
		default:
			laenge=strlen(wort);
			wort[laenge]=c;
			wort[laenge+1]='\0';
			i=1;;
			break;

	}/*Ende switch */
	return(i);

}/*Ende anfzeichen2 */

/********************************************************************
 *                          anfzeichen                              *
 ********************************************************************/


char *anfzeichen (char *end)

/********************************************************************
 * Diese Funktion wird aufgerufen, wenn im Text " gefunden wird,    *
 * und schreibt den richtigen Umlaut nach wort                      *
 ********************************************************************/


{
	char help;

	switch (end[1]) {
		case 97:
			strcat(wort,"");
			end =&end [2];           /*  */
			break;
			/*Ende case 97 */
		case 'e':
			strcat(wort,"");
			end =&end [2];
			break;
			/*Ende case 65 */
		case 111:
			strcat(wort,"");
			end =&end [2];               /*  */
			break;
			/*Ende case 111 */
		case 117:
			strcat(wort,"");
			end =&end [2];               /*  */
			break;
			/*Ende case 117 */
		case 65:
			strcat(wort,"");
			end =&end [2];
			break;
			/*Ende case 65 */
		case 'E':
			strcat(wort,"");
			end =&end [2];
			break;
			/*Ende case 65 */
		case 79:                   /*  */
			strcat(wort,"");
			end =&end [2];
			break;
			/*Ende case 79 */
		case 85:                  /*  */
			strcat(wort,"");
			end =&end [2];
			break;
			/*Ende case 85 */
		case 115:                   /*  */
			strcat(wort,"");
			end =&end [2];
			break;
			/*Ende case 115 */
		case '|':
		case '-':
		case '\"':end=&end[2];
					break;

		default:        end=&end[1];
					break;

	}/*Ende switch */

	return(end);

} /*Ende anfzeichen */

/********************************************************************
 *                    aigu                                           *
 ********************************************************************/


int aigu (char c)

/********************************************************************
 * Diese Funktion wird aufgerufen, wenn im Text \' gefunden wird,   *
 * und schreibt den richtigen Umlaut nach wort                      *
 ********************************************************************/


{  int i=0,laenge;
	char help;
	switch (c) {
		case 'a':
			strcat(wort,"");
			break;
		case 'e':
			strcat(wort,"");
			break;
		case 'o':
			strcat(wort,"");
			break;
		case 'u':
			strcat(wort,"");
			break;
		case 'A':
			strcat(wort,"");
			break;
		case 'E':
			strcat(wort,"");
			break;
		case 'O':
			strcat(wort,"");
			break;
		case 'U':
			strcat(wort,"");
			break;
		default:
			laenge=strlen(wort);
			wort[laenge]=c;
			wort[laenge+1]='\0';
			i=1;;
			break;

	}/*Ende switch */
	return(i);

}/*Ende aigu */


/********************************************************************
 *                    grave                                         *
 ********************************************************************/


int grave(char c)


/********************************************************************
 * Diese Funktion wird aufgerufen, wenn im Text \` gefunden wird,   *
 * und schreibt den richtigen Umlaut nach wort                      *
 ********************************************************************/


{  int i=0,laenge;
	char help;
	switch (c) {
		case 'a':
			strcat(wort,"");
			break;
		case 'e':
			strcat(wort,"");
			break;
		case 'o':
			strcat(wort,"");
			break;
		case 'u':
			strcat(wort,"");
			break;
		case 'A':
			strcat(wort,"");
			break;
		case 'E':
			strcat(wort,"");
			break;
		case 'O':
			strcat(wort,"");
			break;
		case 'U':
			strcat(wort,"");
			break;

		default:
			laenge=strlen(wort);
			wort[laenge]=c;
			wort[laenge+1]='\0';
			i=1;;
			break;

	}/*Ende switch */
	return(i);

}/*Ende grave */
/********************************************************************
 *                    circonflex                                    *
 ********************************************************************/


int circonflex(char c)


/********************************************************************
 * Diese Funktion wird aufgerufen, wenn im Text \^ gefunden wird,   *
 * und schreibt den richtigen Umlaut nach wort                      *
 ********************************************************************/


{  int i=0,laenge;
	char help;
	switch (c) {
		case 'a':
			strcat(wort,"");
			break;
		case 'e':
			strcat(wort,"");
			break;
		case 'o':
			strcat(wort,"");
			break;
		case 'u':
			strcat(wort,"");
			break;
		case 'A':
			strcat(wort,"");
			break;
		case 'E':
			strcat(wort,"");
			break;
		case 'O':
			strcat(wort,"");
			break;
		case 'U':
			strcat(wort,"");
			break;

		default:
			laenge=strlen(wort);
			wort[laenge]=c;
			wort[laenge+1]='\0';
			i=1;;
			break;

	}/*Ende switch */
	return(i);

}/*Ende circonflex */


/************************************************************
 *                     kontrolle                            *
 ************************************************************/

void kontrolle (char *lineout)

/****************************************************************
 * Hier wird lineout in einzelne Woerter zerlegt, die nach wort *
 * geschrieben und von der Funktion such ueberprueft werden.    *
 ****************************************************************/

{  char puffer[255],*anf,*end,*endneu,zwischen;
	int i=0,j,k,l;
	if (strlen(lineout)==0) {return;}

	ersetzeumlaute(lineout);

	end=&lineout[0];

if(gtex==0){
	do{
		strcpy(wort,"");
		anf=&end[(strcspn(end,"\\"DEUTSCHESALPHABET))];
		strncat(fertig,end,anf-end);
		end=&anf[(strspn(anf,DEUTSCHESALPHABET))];
		strncpy(wort,anf,end-anf);
		wort[end-anf]='\0';
		while((strchr("{}\\",end[0])!=NULL) && (end[0]!= '\0')){

			switch(end[0]){
				case '{':
				case '}':end=&end[1];
							break;
				case '\\':if (end[1]=='\"'){
								i=anfzeichen2(end[2]);
								end=&end[3];
							}else if(end[1]=='\''){
								i=aigu(end[2]);
								end=&end[3];
							}else if(end[1]=='`'){
								i=grave(end[2]);
								end=&end[3];
							}else if(end[1]=='^'){
								i=circonflex(end[2]);
								end=&end[3];
							}else if(strncmp(end,"\\ss",3)==0){
								strcat(wort,"");
								if(end[3]==' '){
									end=&end[4];
								}else{
									end=&end[3];
								}/*Ende if*/
							}else if(end[1]=='3'){
								strcat(wort,"");
								end=&end[2];
							}else{
							end=&end[2];
							}/*Ende if*/
							break;
			}/*Ende switch*/
			endneu=&end[(strspn(end,DEUTSCHESALPHABET))];
			j=strlen(wort);
			strncat(wort,end,endneu-end);
			wort[endneu-end+j]='\0';
			end=endneu;

		}/*Ende while*/

			while((neuisalpha(*(end-1))==FALSE)&&(strcmp(end,"")!=0)&&(end-1!=anf)){
				end=end-1;
			}/*ende while*/

			if(strlen(wort)!=0){

				if (i!=0) {
					vorschlaege=0;
					unbekannt(anf,end,1);
					vorschlaege=-1;
				}else{
					zwischen=wort[0];
					if(englisch==TRUE){
						norekur=TRUE;
					}else{
						norekur=0;
					}/*Ende if*/
					for(l=0;l<5;l++){Gefunden[l][0]='\0';}/*Variablen fuer Teil-*/
					Rest[0]='\0';                         /*woerter loeschen*/
					i=such(wort);
					if (i==0) {
						j=strlen(fertig);
						strncat(fertig,anf,end-anf);
						fertig[j+end-anf]='\0';
						strcpy(wort,"");
					}else{
						wort[0]=zwischen;
						if(Gefunden[0][0]!='\0'){unbekannt(anf,end,2);
						}else{unbekannt(anf,end,0);}    /*        ^^^ bedeutet zusammengesetztes Wort*/


					}/*Ende if i*/
				}/*Ende if*/
				i=0;
			}/*Ende if strlen*/

	}while(end!=anf);

/******************************************************************/

}else{

	do{
		strcpy(wort,"");
		anf=&end[(strcspn(end,"\\\""DEUTSCHESALPHABET))];
		strncat(fertig,end,anf-end);
		end=&anf[(strspn(anf,DEUTSCHESALPHABET))];
		strncpy(wort,anf,end-anf);
		wort[end-anf]='\0';
		while((strchr("{}\\\"",end[0])!=NULL) && (end[0]!= '\0')){

			switch(end[0]){
				case '{':
				case '}':end=&end[1];
							break;
				case '\\':if (end[1]=='\"'){
								i=anfzeichen2(end[2]);
								end=&end[3];
							}else if(end[1]=='\''){
								i=aigu(end[2]);
								end=&end[3];
							}else if(end[1]=='`'){
								i=grave(end[2]);
								end=&end[3];
							}else if(end[1]=='^'){
								i=circonflex(end[2]);
								end=&end[3];
							}else if(strncmp(end,"\\ss",3)==0){
								strcat(wort,"");
								if(end[3]==' '){
									end=&end[4];
								}else{
									end=&end[3];
								}/*Ende if*/
							}else if(end[1]=='3'){
								strcat(wort,"");
								end=&end[2];
							}else{
							end=&end[2];
							}/*Ende if*/
							break;
				case '\"':end=anfzeichen(end);
							break;

			}/*Ende switch*/
			endneu=&end[(strspn(end,DEUTSCHESALPHABET))];
			j=strlen(wort);
			strncat(wort,end,endneu-end);
			wort[endneu-end+j]='\0';
			end=endneu;

		}/*Ende while*/

			while((neuisalpha(*(end-1))==FALSE)&&(strcmp(end,"")!=0)&&(end-1!=anf)){
				end=end-1;
			}/*ende while*/

				if (i!=0) {
					vorschlaege=0;
					unbekannt(anf,end,1);
					vorschlaege=-1;
				}else{
					zwischen=wort[0];
					norekur=0;
					for(l=0;l<5;l++){Gefunden[l][0]='\0';}/*Variablen fuer Teil-*/
					Rest[0]='\0';                         /*woerter loeschen*/
					i=such(wort);
					if (i==0) {
						j=strlen(fertig);
						strncat(fertig,anf,end-anf);
						fertig[j+end-anf]='\0';
						strcpy(wort,"");

					}else {
						wort[0]=zwischen;
						if(Gefunden[0][0]!='\0'){unbekannt(anf,end,2);
						}else{unbekannt(anf,end,0);}    /*        ^^^ bedeutet zusammengesetztes Wort*/

					}/*Ende if i*/
	   }/*Ende if*/
			  i=0;
	}while(end!=anf);
}/*Ende if gtex*/
		strcpy(lineout,"");
}/*Ende kontrolle */

/********************************************************************
 *                        alteeingabe                               *
 ********************************************************************/


void alteeingabe (void)

/********************************************************************
 * setzt nach der Beendigung eines eines \input - Befehls wieder    *
 * auf das alte Eingabefile zurueck.                                *
 ********************************************************************/

{

	fclose(ein);
	fclose(aus);

	remove(TEMPFILE);
	rename(Name_eingabe,TEMPFILE);
	remove(Name_eingabe);
	rename(Name_ausgabe,Name_eingabe);
	rename(TEMPFILE,Name_ausgabe);
	remove(TEMPFILE);

	rekur--;
	strcpy(Name_eingabe,rekurinname[rekur]);
	strcpy(Name_ausgabe,rekuroutname[rekur]);
	ein=rekurin[rekur];
	aus=rekurout[rekur];
   zeile=rekurzeile[rekur];

}
/********************************************************************
 *                        neuerinput                                *
 ********************************************************************/

void neuerinput(void)

/********************************************************************
 * Hier werden die auf einen \input-Befehl folgenden Zeichen        *
 * untersucht und der Dateiname der zu ladenden Datei bestimmt.     *
 ********************************************************************/


{int pos;

		changeinput=TRUE;


		kontrolle(&lineout[0]);
		pos=strcspn(point," {");
		strncat(fertig,point,pos);
		point=&point[pos];   /*erstes Zeichen hinter \input*/

		pos=strspn(point," {");
		strncat(fertig,point,pos);
		point=&point[pos];   /*erstes Zeichen des Dateinamens*/

		pos=strcspn(point," }\n\r");
		strncat(fertig,point,pos);
		dummyname[pos]='\0';    /* UB */
		strncpy(dummyname,point,pos);
		point=&point[pos];   /*erstes Zeichen hinter Dateinamen*/


}

/********************************************************************
 *                        changeeingabe                             *
 ********************************************************************/


void changeeingabe (void)

/********************************************************************
 * Dieses Unterprogramm aendert das Eingabefile, wenn im Text ein   *
 * \input-Befehl gefunden wurde. Vorher muss von neuerinput der     *
 * Dateiname bestimmt werden.                                       *
 ********************************************************************/


{   changeinput=FALSE;

	 if (rekur==4) {
#ifdef GERMAN
		fprintf(stderr,"\nZu viele input-Files verschachtelt!\n");
		fprintf(stderr,"%s wird nicht "uE"berpr"uE"ft!\n",dummyname);
		fprintf(logfile,"\nZu viele input-Files verschachtelt!\n");
		fprintf(logfile,"%s wird nicht "uE"berpr"uE"ft!\n",dummyname);
#else
		fprintf(stderr,"\nToo many nested input-files!\n");
		fprintf(stderr,"%s will not be checked!\n",dummyname);
		fprintf(logfile,"\nToo many nested input-files!\n");
		fprintf(logfile,"%s will not be checked!\n",dummyname);

#endif
		return;}

	strcpy(rekurinname[rekur],Name_eingabe);
	strcpy(rekuroutname[rekur],Name_ausgabe);
	rekurin[rekur]=ein;
	rekurout[rekur]=aus;

	rekurzeile[rekur]=zeile;
	zeile=0;
	rekur++;


	strcpy (Name_eingabe,dummyname);
	point=strtok(dummyname,".");
	strcpy(Name_ausgabe,point);

	if ((point=strtok (NULL," "))==NULL ){
		strcat (Name_eingabe,".tex");
	}/*Ende if */

	strcat (Name_ausgabe,".old");


	if ((ein = fopen (Name_eingabe,"rb"))==NULL){
#ifdef GERMAN
		fprintf(stderr,"\nWarnung: %s konnte nicht ge"oE"ffnet werden!\n",Name_eingabe);
		fprintf(logfile,"\nWarnung: %s konnte nicht ge"oE"ffnet werden!\n",Name_eingabe);
#else
		fprintf(stderr,"\nWarning: couldn't open %s!\n",Name_eingabe);
		fprintf(logfile,"\nWarning: couldn't open %s!\n",Name_eingabe);

#endif
		aus=NULL;
		alteeingabe();
		return;
	}
	if ((aus = fopen (Name_ausgabe,"wb"))==NULL){
#ifdef GERMAN
		fprintf(stderr,"\nWarnung: %s konnte nicht ge"oE"ffnet werden!\n",Name_ausgabe);
		fprintf(logfile,"\nWarnung: %s konnte nicht ge"oE"ffnet werden!\n",Name_ausgabe);
#else
		fprintf(stderr,"\nWarning: couldn't open %s!\n",Name_ausgabe);
		fprintf(logfile,"\nWarning: couldn't open %s!\n",Name_ausgabe);

#endif
		alteeingabe();
		return;
	}

#ifdef GERMAN
	printf("\n"UE"berpr"uE"fe %s \n",Name_eingabe);
	fprintf(logfile,"\n"UE"berpr"uE"fe %s \n",Name_eingabe);
#else
	printf("\nChecking %s \n",Name_eingabe);
	fprintf(logfile,"Checking %s \n",Name_eingabe);

#endif

}



/********************************************************************
 *                        backslash                                 *
 ********************************************************************/

void backslash (void)

/********************************************************************
 * Dieses Unterprogramm wird aufgerufen, wenn im Text ein \ gefunden*
 * wird. Die normalen TeX-Befehle werden herausgenommen, und nur die*
 * Befehle fuer Umlaute nach lineout kopiert.                       *
 ********************************************************************/

{       char *hilfspoint;
#if TC
char huge *key;
#else
char *key;
#endif
	int pos,befehlnr,i;

	 if ((strncmp(point,"\\input",6)==0)&&(folgeinput==TRUE)) {

		if(isalpha(point[6])==FALSE){
			neuerinput();
			return;
		}
	 }

	 if ((strncmp(point,"\\include",8)==0)&&(folgeinput==TRUE)) { /* UB */

		if(isalpha(point[8])==FALSE){ /* UB */
			neuerinput(); /* UB */
			return; /* UB */
		} /* UB */
	 } /* UB */

    if (strncmp(point,"\\ss",3)==0){      /*  */

		 
		 if(point[3]==' '){
			strncat(lineout,point,4);
			point=&point[4];
			return;
		 }else if(isalpha(point[3])==0){
			strncat(lineout,point,3);
			point=&point[3];
			return;
		 }/*Ende if-else*/
	}/*Ende if*/

	if ((befehlnr=ueberlesen())!=anzahl_befehle) {

		kontrolle(&lineout[0]);
		schreiben();

		strncat(fertig,point,strlen(befehl1[befehlnr]));
		point=point+strlen(befehl1[befehlnr])*sizeof(char);

		while ((hilfspoint=strstr (point,befehl2[befehlnr])) == NULL ){
			strcat(fertig,point);
			schreiben();
			if (neuezeile()==NULL){
				fehler(4,befehl2[befehlnr]);
			}/*Ende if */
			point=&linein[0];

		}/*Ende while */
		strncat(fertig,point,hilfspoint+strlen(befehl2[befehlnr])-point);
		point=hilfspoint+strlen(befehl2[befehlnr])*sizeof(char);


	} else if (isalpha(point[1])==0) {          /* kurzbefehl */
		switch (point[1]){
		case '\'':
		case '`':
		case '^':
		case '\"':
		case '/':
		case '-':
		case '3':strncat(lineout,point,2);
					break;
		default:        kontrolle(&lineout[0]);
					strncat(fertig,point,2);
	  }/*Ende switch*/
	  point=&point[2];

	}else {   /* Befehl raus */

		kontrolle(&lineout[0]); /*Ueberpruefung ausloesen, damit die */
										/*Reihenfolge stimmt*/

																	/*auf erstes Zeichen hinter*/
		pos=strspn(&point[1],ENGLISCHESALPHABET);
		strncat(fertig,point,pos+1);               /*bEFEHL*/
		point=&point[pos+1];


	  key=keybereich;
	 while(key<maxkey){
		i=strlen((char*)key);
		  /*i--;i--;*/
		pos=strcspn(&point[0],ENGLISCHESALPHABET);
										 /*erster Buchstabe nach dem Befehl*/

		if((strncmp(&point[pos],(char*)key,i)==0)&&(strchr(ENGLISCHESALPHABET,point[i+pos])==NULL)){
			strncat(fertig,point,pos+i);
			point=&point[pos+i];
		  key=keybereich;           /* von vorne suchen, ob zweites keyword */
		  i=0;                                                                          /* da ist*/
		}/*Ende if*/
		key=&key[i+2];    /*Key zeigt auf das erste Zeichen hinter \0*/
		while(key[0]=='\0'){key=&key[1];} /* erstes nicht-\0 suchen*/


	 }/*Ende while*/

	}/*Ende if-else */



}/*Ende backslash */
/********************************************************************
 *                          prozent                                 *
 ********************************************************************/

void prozent (void) {

/********************************************************************
 * Diese Funktion wird aufgerufen, wenn im Text en %-Zeichen ist.   *
 * Der Rest der Zeile wird dann ueberlesen.                         *
 ********************************************************************/

	kontrolle(&lineout[0]);
	schreiben();
	strcat(fertig,point);
	point=&point[strlen(point)];

}/*Ende prozent*/


/********************************************************************
 *                          dollar                                  *
 ********************************************************************/

void dollar (void) {

/********************************************************************
 * Diese Funktion wird aufgerufen, wenn im Text ein $ oder $$       *
 * Zeichen steht. Das Programm sucht das Ende der Formel und        *
 * ueberliest alles dazwischen.                                     *
 ********************************************************************/

char *hilfspoint;
	kontrolle(&lineout[0]);
	schreiben();
	if (point[1]=='$'){
		point=&point[2];
		strcat(fertig,"$$");
		while ((hilfspoint=strstr (point,"$$")) == NULL ){
			strcat(fertig,point);
			schreiben();
			if (neuezeile()==NULL){
				fehler(4,"$$");
			}/*Ende if */

			point=&linein[0];

		}/*Ende while */
		strncat(fertig,point,hilfspoint+2-point);
		point=hilfspoint+2*sizeof(char);

	} else {
	  point=&point[1];
	  strcat(fertig,"$");
		while ((hilfspoint=strstr (point,"$")) == NULL ){
			strcat(fertig,point);
			schreiben();
			if (neuezeile()==NULL){
				fehler(4,"$");
			}/*Ende if */

			point=&linein[0];

		}/*Ende while */

		strncat(fertig,point,hilfspoint+1-point);
		point=hilfspoint+1*sizeof(char);

	}/*Ende if*/

}/*Ende dollar */

/****************************************************************
 *                      Lizenz
 ****************************************************************/
void lizenz(void){

#ifdef GERMAN
fprintf(stderr,"\n"
		 "TeXSPELL Version "VER", Copyright (C) 1992 - 94 Martin Eckl\n"
		 "\n"
		 "TeXSPELL wird nach den Bestimmungen der GNU General Public\n"
		 "Licence verteilt. Das bedeutet, da"sS"\n"
		 "TeXSPELL OHNE JEDE HAFTUNG f"uE"r Sch"aE"den verteilt wird\n"
		 "und unter bestimmten Bedingungen kopiert und weitergegeben\n"
		 "werden darf.\n\n"
		 "Die komplette Lizenz befindet sich im File 'copying', das \n"
		 "Version 1 der GNU General Public Licence enth"aE"lt, oder ist\n"
		 "bei der Free Software Foundation, Inc., 675 Mass Ave,\n"
		 "Cambridge, MA 02139, USA erh"aE"ltlich.\n\n"
);


#else
fprintf(stderr,"\n"
		  "TeXSPELL version "VER", Copyright (C) 1992 - 94 Martin Eckl\n"
		  "\n"
		  "TeXSPELL is distributed under the terms of the GNU Public\n"
		  "Licence. This means, that\n"
		  "TeXSPELL is distributed WITHOUT ANY WARRENTY,\n"
		  "and that it may be copied and redistributed under certain\n"
		  "conditions.\n\n"
		  "The complete licence can be found in the file copying, or it can\n"
		  "be obtained from the Free Software Foundation, Inc., 675 Mass Ave,\n"
		  "Cambridge, MA 02139, USA.\n\n"
		  );

#endif


exit(1);
}/*Ende lizenz*/


/************************************************************
 *                     Hauptprogramm                        *
 ************************************************************/

int main(int argc,char *argv[])

{  char help,*pntr,Zeichen,*filepos,*pfad;
	int pos,ueberles,i,j;
	long dummy;
/*      long far *farptr; */
	char envirvar[12]="SPELLPATH", *dummypt;

	if (argc == 1 ) {anleitung();}
	if (strcmp(argv[1],"/?")==0) {anleitung();}
	if (strcmp(argv[1],"/h")==0) {anleitung();}
	if (strcmp(argv[1],"/l")==0) {lizenz();}
	if (strcmp(argv[1],"-?")==0) {anleitung();}
	if (strcmp(argv[1],"-h")==0) {anleitung();}
	if (strcmp(argv[1],"-l")==0) {lizenz();}

#if NOSTDOUTBUF
	/* djgpp puffer die Ausgabe zu stark */
	setvbuf(stdout,NULL,_IONBF,0);

#endif


#ifdef GERMAN
	printf("Dies ist TeXSPELL Version %s \n",VER);
#else
	printf("This is TeXSPELL version %s \n",VER);
	englisch=TRUE;
#endif
	lastline[0]='\0';
	linein[0]='\0';
	strcpy (Name_eingabe,argv[1]);
	point=strtok(argv[1],".");
	strcpy(Name_ausgabe,point);

	if ((point=strtok (NULL," "))==NULL ){
		strcat (Name_eingabe,".tex");
	}/*Ende if */

	strcat (Name_ausgabe,".old");


	if ((ein = fopen (Name_eingabe,"rb+"))==NULL){fehler(2,Name_eingabe);}
	if ((aus = fopen (Name_ausgabe,"wb+"))==NULL){fehler(3,Name_ausgabe);}
#ifdef GERMAN
	printf(""UE"berpr"uE"fe %s \n",Name_eingabe);
#else
	printf("Checking %s \n",Name_eingabe);
#endif
/***************************************************************/

	i=2;
	while(i<argc){
		if (isdigit(argv[i][0])!=0){
			dummy=strtol(argv[i],&pntr,0);
			ueberles=(int)dummy;
			for (j=0;j<ueberles;j++){
				neuezeile();
				strcpy(fertig,linein);
	  schreiben();
			}/*Ende for*/
			printf("\n");
		}else if((isprint(argv[i][0])!=0)&&(argv[i][0]!=OPTIONENZEICHEN)&&(!isdigit(argv[i][0]))){
			if(strcmp(namespecial,"")==0){
				strcpy(namespecial,argv[i]); 
				dummypt=namespecial;
				while(strstr(&dummypt[1],VERZEICHNISTRENNER)!=NULL){
					dummypt=strstr(&dummypt[1],VERZEICHNISTRENNER);
				}/*Ende while*/
				if(strstr(dummypt,".")==NULL){strcat(namespecial,".lst");}
			}else{
				strcpy(namespecial2,argv[i]);      
				dummypt=namespecial2;
				while(strstr(&dummypt[1],VERZEICHNISTRENNER)!=NULL){ 
					dummypt=strstr(&dummypt[1],VERZEICHNISTRENNER);
				}/*Ende while*/
				if(strstr(dummypt,".")==NULL){strcat(namespecial2,".lst");}

			}/*Ende if-else*/
		}else if(argv[i][0]==OPTIONENZEICHEN){
			switch(argv[i][1]){
				case 's':superviser=TRUE;
#ifdef GERMAN
							printf("In Standardliste schreiben!\n");
#else
							printf("Writing to standard list!\n");
#endif
							break;
				case 'p':gtex=0;
#ifdef GERMAN
							printf("Unterst"uE"tzung der deutschen TeX-Befehle aus!\n");
#else
							printf("German TeX-commands off!\n");
#endif
							break;
				case 'u':ersetz=TRUE;
#ifdef GERMAN
							printf("Umlautersetzung ein!\n");
#else
							printf("Umlaut translation on!\n");
#endif
							break;
				case 'v':vorschlaege=0;
#ifdef GERMAN
							printf("Keine Korrekturvorschl"aE"ge!\n");
#else
							printf("No correction suggestions!\n");
#endif
							break;
				case 'i':folgeinput=FALSE;
#ifdef GERMAN
							printf("\\input - Befehle werden nicht verfolgt!\n");
#else
							printf("\\input - commands will not be followed!\n");
#endif
							break;
				case 'e':englisch=TRUE;
							gtex=FALSE;
#ifdef GERMAN
							printf("Englische W"oE"rterlisten verwenden!\n");
#else
							printf("Using English word lists!\n");
#endif
							break;
				case 'g':englisch=FALSE;
#ifdef GERMAN
							printf("Deutsche W"oE"rterlisten verwenden!\n");
#else
							printf("Using German word lists!\n");
#endif
							break;
				case 'b':
#ifdef GERMAN
							defaultliste='b';
							printf("Benutzerliste wird als Standardliste verwendet!\n");
#else
							defaultliste='u';
							printf("Userlist will be used as default!\n");
#endif
							break;
				case 't':
#ifdef GERMAN
							defaultliste='t';
							printf("Textliste wird als Standardliste verwendet!\n");
#else
							defaultliste='t';
							printf("Textlist will be used as default!\n");

#endif
							break;
#if TC
				case 'a':ansisys=FALSE;
#ifdef GERMAN
							printf("Es werden keine Farben benutzt!\n");
#else
							printf("No colours will be used!\n");
#endif
							break;
#endif
				case 'c':pruef=TRUE;
#ifdef GERMAN
							printf("Pr"uE"fmodus ein!\n");
#else
							printf("Checking mode on!\n");
#endif
							if((prueffile=fopen(&argv[i+1][0],"w"))==NULL){fehler(1,&argv[i+1][2]);} 
							i++;
							break;
				case 'q':batchmode=TRUE;
							break;
				default :
#ifdef GERMAN
							fprintf(stderr,"Unbekannte Option: %s !\n",argv[i]);
#else
							fprintf(stderr,"Unknown option: %s !\n",argv[i]);
#endif
							break;
			}/*Ende switch*/
		}else{
#ifdef GERMAN
			fprintf(stderr,"%s nicht erkannt!\n",argv[i]);
#else
			fprintf(stderr,"%s not recognized!\n",argv[i]);
#endif

		}/*Ende if*/
      i++;
	}/*Ende while*/
/***************************************************************/
	strcpy(listname,"");
	strcpy(datname,"");
	strcpy(endname,"");
	strcpy(ergname,"");
	strcpy(keyname,"");

	if((pfad=getenv(envirvar))==NULL){
#ifdef SPELLPATH
	  pfad=SPELLPATH;               /* UB */
#else
		if((i=strlen(argv[0]))>13){
			argv[0][i-13]='\0';
			pfad=argv[0];
		}/*Ende if*/
#endif
	}/*Ende if*/

	if(pfad!=NULL){
		strcpy(listname,pfad);
		strcpy(datname,pfad);
		strcpy(endname,pfad);
		strcpy(keyname,pfad);
		strcpy(vorname,pfad);
		strcat(listname,VERZEICHNISTRENNER);
		strcat(datname,VERZEICHNISTRENNER);
		strcat(endname,VERZEICHNISTRENNER);
		strcat(keyname,VERZEICHNISTRENNER);
		strcat(vorname,VERZEICHNISTRENNER);
	}/*Ende if*/

	if(englisch==TRUE){
		strcat(listname,ENGLISTNAME);
		strcat(endname,ENGENDNAME);
		strcat(ergname,ENGERGNAME);
		strcat(vorname,ENGVORSILBENAME);
	}else{
		strcat(listname,LISTNAME);
		strcat(endname,ENDNAME);
		strcat(ergname,ERGNAME);
		strcat(vorname,VORSILBENAME);
	}/*Ende if*/

	strcat(keyname,KEYNAME);
	strcat(datname,DATNAME);

/**************************************************************/
	platz=100;
	platzspecial=100;
	platzspecial2=100;
	platzerg=100;
#if TC
	if ((datpointspecial2=(long*)farmalloc((unsigned long)(platzspecial2*sizeof(long))))==NULL){
		fehler(5,"");
	}/*Ende if*/
	if ((datpointspecial=(long*)farmalloc((unsigned long)(platzspecial*sizeof(long))))==NULL){
		fehler(5,"");
   }/*Ende if*/
	if ((datpoint=(long*)farmalloc((unsigned long)(platz*sizeof(long))))==NULL){
		fehler(5,"");
   }/*Ende if*/
	if ((datpointerg=(long*)farmalloc((unsigned long)(platzerg*sizeof(long))))==NULL){
		fehler(5,"");
	}/*Ende if*/

#else
	if ((datpointspecial2=(long*)malloc((size_t)(platzspecial2*sizeof(long))))==NULL){
		fehler(5,"");
   }/*Ende if*/
	if ((datpointspecial=(long*)malloc((size_t)(platzspecial*sizeof(long))))==NULL){
		fehler(5,"");
   }/*Ende if*/
	if ((datpoint=(long*)malloc((size_t)(platz*sizeof(long))))==NULL){
		fehler(5,"");
	}/*Ende if*/
	if ((datpointerg=(long*)malloc((unsigned long)(platzerg*sizeof(long))))==NULL){
		fehler(5,"");
	}/*Ende if*/


#endif

/************************************************************/
	einlesen(pfad);
#ifdef GERMAN
	fprintf(logfile,"Dies ist TeXSPELL Version %s \n",VER);
	fprintf(logfile,""UE"berpr"uE"fe %s \n",Name_eingabe);
#else
	fprintf(logfile,"This is TeXSPELL version %s \n",VER);
	fprintf(logfile,"Checking %s \n",Name_eingabe);

#endif

/********************************************************************
 *             Hier beginnt die Hauptschleife                       *
 ********************************************************************/

	while(  ( (filepos=neuezeile()) !=NULL)  ||   (rekur!=0)) {

		if (filepos==NULL) {
			alteeingabe();
			filepos=neuezeile();
			if (filepos==NULL) {
				strcpy(linein,"");
			}/*Ende if*/
		}/*Ende if*/

		point=&linein[0];
		strcpy(lineout,"");
		while (strlen(point)!=0){

			if ((pos=strcspn(point,"\\$%"))!=strlen(point)){
				maxline=strlen(point);
				strncat(lineout,point,pos);
				point=&point[pos];

				if (point[0]==92) {backslash();}
				else if (point[0]=='$'){dollar();}
				else if (point[0]=='%'){prozent();}
				else {printf("Fehler3!\n");}

			}else{

				strcat(lineout,point);
				point=&point[strlen(point)];

			}/*Ende if-else */
	  }/*Ende while2*/


	  kontrolle(&lineout[0]);

	  schreiben();

	  if (abgebrochen==-1){
		while (((filepos=neuezeile())!= NULL) || (rekur!=0) ){

						if (filepos==NULL) {
							alteeingabe();
							filepos=neuezeile();
							if (filepos==NULL) {
								strcpy(linein,"");
							}/*Ende if*/
						}/*Ende if*/

			strcpy(fertig,linein);
			schreiben();
		}/*Ende while*/
		ende(1);
	  }/*Ende if abgebrochen*/

	  if (changeinput==TRUE) {changeeingabe();}
#if TC


		if(kbhit()!=0){
			Zeichen=getch();
			if (Zeichen=='q'){
				do {
#ifdef GERMAN
					printf("\nProgramm abbrechen (j/n)?\n");
					rewind(stdin);
					scanf("%1c",&Zeichen);
					Zeichen=tolower(Zeichen);
#else
					printf("\nAbort program (y/n)?\n");
					rewind(stdin);
					scanf("%1c",&Zeichen);
					Zeichen=tolower(Zeichen);
					if (Zeichen=='y')Zeichen='j';
#endif
				}while ((Zeichen!='j') && (Zeichen!='n'));
				if (Zeichen=='j'){
					while (((filepos=neuezeile())!= NULL) || (rekur!=0) ){

						if (filepos==NULL) {
							alteeingabe();
							filepos=neuezeile();
							if (filepos==NULL) {
								strcpy(linein,"");
							}/*Ende if*/
						}/*Ende if*/

						strcpy(fertig,linein);
						schreiben();


					}/*Ende while*/
					ende(1);
				}/*Ende if*/
			}else{
/*                              ungetc(Zeichen,stdin);    */
			}/*Ende if*/

		}/*Ende if*/

#endif

	}/* Ende while */
	ende(0);
	return 0;
}/* Ende main */

