/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.viewer;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.properties.TexlipseProperties;
import net.sourceforge.texlipse.viewer.ViewerManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class ViewerOutputScanner
implements Runnable {
    private BufferedReader br;
    private IProject project;

    public ViewerOutputScanner(IProject project, InputStream in) {
        this.project = project;
        this.br = new BufferedReader(new InputStreamReader(in));
    }

    protected ViewerOutputScanner(IProject project) {
        this.project = project;
    }

    public static void openInEditor(IProject proj, String file, int lineNumber) {
        new ViewerOutputScanner(proj).openFileFromLineNumber(file, lineNumber);
    }

    private void checkLine(String line) {
        int index = line.indexOf(58);
        if (index < 0) {
            return;
        }
        String file = line.substring(0, index);
        String number = line.substring(index + 1);
        int lineNumber = -1;
        try {
            lineNumber = Integer.parseInt(number);
        }
        catch (NumberFormatException numberFormatException) {}
        if (lineNumber >= 0) {
            this.openFileFromLineNumber(file, lineNumber);
        }
    }

    protected void openFileFromLineNumber(String file, int lineNumber) {
        IContainer srcDir;
        String projDir;
        int index;
        if (this.project == null) {
            return;
        }
        IResource resource = null;
        if (File.separatorChar == '\\') {
            file = file.replace('/', '\\');
        }
        if ((index = file.indexOf(projDir = this.project.getLocation().addTrailingSeparator().toOSString())) == 0) {
            String outdirName;
            file = file.substring(projDir.length());
            IFolder outdir = TexlipseProperties.getProjectOutputDir(this.project);
            if (outdir != null && (index = file.indexOf(outdirName = String.valueOf(outdir.getProjectRelativePath().toString()) + File.separator)) == 0) {
                file = file.substring(outdirName.length());
            }
            if ((resource = this.project.findMember(file)) == null) {
                srcDir = TexlipseProperties.getProjectSourceDir(this.project);
                resource = srcDir.findMember(file);
            }
        } else {
            String outDir;
            if (file.startsWith("..")) {
                file = file.substring(3);
            }
            if ((outDir = TexlipseProperties.getProjectProperty((IResource)this.project, "outputDir")) != null && outDir.length() > 0) {
                if (outDir.endsWith("/") || outDir.endsWith("\\")) {
                    outDir = outDir.substring(0, outDir.length() - 1);
                }
                if (file.indexOf(outDir = outDir.trim()) == 0) {
                    file = file.substring(outDir.length() + 1);
                }
            }
            srcDir = TexlipseProperties.getProjectSourceDir(this.project);
            resource = srcDir.findMember(file);
        }
        if (resource == null) {
            return;
        }
        IMarker mark = null;
        try {
            mark = resource.createMarker("org.eclipse.core.resources.bookmark");
            MarkerUtilities.setLineNumber((IMarker)mark, (int)lineNumber);
        }
        catch (CoreException coreException) {}
        if (mark != null) {
            Display display = TexlipsePlugin.getDefault().getWorkbench().getDisplay();
            display.syncExec((Runnable)new EditorOpener(mark));
            try {
                mark.delete();
            }
            catch (CoreException coreException) {}
            new Thread(new Runnable(){

                public void run() {
                    ViewerManager.returnFocusToEclipse(TexlipsePlugin.getDefault().getPreferenceStore().getBoolean("forceReturnFocusOnInverseSearch"));
                }
            }).start();
        }
    }

    public void run() {
        String line = null;
        try {
            while ((line = this.br.readLine()) != null) {
                this.checkLine(line);
            }
        }
        catch (IOException iOException) {}
    }

    class EditorOpener
    implements Runnable {
        private IMarker marker;

        public EditorOpener(IMarker marker) {
            this.marker = marker;
        }

        public void run() {
            IWorkbenchPage page = TexlipsePlugin.getCurrentWorkbenchPage();
            if (page == null) {
                return;
            }
            try {
                IDE.openEditor((IWorkbenchPage)page, (IMarker)this.marker, (boolean)false);
            }
            catch (PartInitException partInitException) {}
        }
    }
}

