/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.outline;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.model.MarkerHandler;
import net.sourceforge.texlipse.model.OutlineNode;
import net.sourceforge.texlipse.model.TexProjectParser;
import net.sourceforge.texlipse.properties.TexlipseProperties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TexProjectOutline {
    private IProject currentProject;
    private List<OutlineNode> topLevelNodes;
    private OutlineNode virtualTopNode;
    private TexProjectParser fileParser;
    private Map<String, List<OutlineNode>> outlines = new HashMap<String, List<OutlineNode>>();
    private Set<String> included = new HashSet<String>();

    public TexProjectOutline(IProject currentProject) {
        this.currentProject = currentProject;
        this.fileParser = new TexProjectParser(currentProject);
    }

    public void addOutline(List<OutlineNode> nodes, String fileName) {
        this.outlines.put(fileName, nodes);
        IFile mainFile = TexlipseProperties.getProjectSourceFile(this.currentProject);
        String str = mainFile.getFullPath().removeFirstSegments(1).toString();
        if (fileName.equals(str)) {
            this.topLevelNodes = nodes;
        }
    }

    public List<OutlineNode> getFullOutline() {
        this.included.clear();
        this.virtualTopNode = new OutlineNode("Entire document", -1, 0, null);
        IFile currentTexFile = TexlipseProperties.getProjectSourceFile(this.currentProject);
        MarkerHandler marker = MarkerHandler.getInstance();
        marker.clearProblemMarkers((IResource)currentTexFile);
        String fullName = this.getProjectRelativeName(currentTexFile);
        if (this.topLevelNodes == null) {
            try {
                this.topLevelNodes = this.fileParser.parseFile(currentTexFile);
                this.outlines.put(fullName, this.topLevelNodes);
            }
            catch (IOException ioe) {
                TexlipsePlugin.log("Unable to create full document outline; main file is not parsable", ioe);
                return new ArrayList<OutlineNode>();
            }
        }
        this.included.add(fullName);
        this.addChildren(this.virtualTopNode, this.topLevelNodes, currentTexFile);
        ArrayList<OutlineNode> outlineTop = this.virtualTopNode.getChildren();
        for (OutlineNode node : outlineTop) {
            node.setParent(null);
        }
        return outlineTop;
    }

    /*
     * Unable to fully structure code
     */
    private void replaceInput(OutlineNode parent, List<OutlineNode> insertList, IFile texFile) {
        if (insertList.size() == 0) {
            return;
        }
        for (OutlineNode oldNode2 : insertList) {
            if (oldNode2.getType() != 45) ** GOTO lbl13
            includedFile = this.resolveFile(oldNode2.getName(), texFile, oldNode2.getBeginLine());
            if (includedFile == null) continue;
            nodes = this.loadInput(includedFile, texFile, oldNode2.getBeginLine());
            this.replaceInput(parent, nodes, includedFile);
            this.included.remove(this.getProjectRelativeName(includedFile));
            continue;
lbl-1000:
            // 1 sources

            {
                parent = parent.getParent();
lbl13:
                // 2 sources

                ** while (oldNode2.getType() <= parent.getType())
            }
lbl14:
            // 1 sources

            newNode = oldNode2.copy(texFile);
            parent.addChild(newNode);
            newNode.setParent(parent);
            oldChildren = oldNode2.getChildren();
            if (oldChildren == null) continue;
            this.addChildren(newNode, oldChildren, texFile);
        }
    }

    private boolean addChildren(OutlineNode main, List<OutlineNode> children, IFile texFile) {
        boolean insert = false;
        for (OutlineNode node : children) {
            if (insert) {
                OutlineNode newMain = this.getParentLevel(this.virtualTopNode.getChildren(), OutlineNode.getSmallerType(node.getType()));
                OutlineNode outlineNode = main = newMain == null ? this.virtualTopNode : newMain;
            }
            if (node.getType() == 45) {
                IFile includedFile = this.resolveFile(node.getName(), texFile, node.getBeginLine());
                if (includedFile == null) continue;
                List<OutlineNode> nodes = this.loadInput(includedFile, texFile, node.getBeginLine());
                this.replaceInput(main, nodes, includedFile);
                this.included.remove(this.getProjectRelativeName(includedFile));
                insert = true;
                continue;
            }
            OutlineNode newNode = node.copy(texFile);
            main.addChild(newNode);
            newNode.setParent(main);
            ArrayList<OutlineNode> oldChildren = node.getChildren();
            if (oldChildren == null || !this.addChildren(newNode, oldChildren, texFile)) continue;
            main = this.getParentLevel(this.virtualTopNode.getChildren(), main.getType());
        }
        return insert;
    }

    private OutlineNode getParentLevel(List<OutlineNode> children, int level) {
        OutlineNode found;
        if (children == null || children.size() == 0) {
            return null;
        }
        OutlineNode lastNode = children.get(children.size() - 1);
        if (lastNode.getType() == level) {
            return lastNode;
        }
        if (lastNode.getType() > level) {
            return level == -1 ? lastNode.getParent() : null;
        }
        ArrayList<OutlineNode> nodeChildren = lastNode.getChildren();
        if (nodeChildren != null && (found = this.getParentLevel(nodeChildren, level)) != null) {
            return found;
        }
        return lastNode;
    }

    private IFile resolveFile(String name, IFile referringFile, int lineNumber) {
        MarkerHandler marker = MarkerHandler.getInstance();
        IFile currentTexFile = TexlipseProperties.getProjectSourceFile(this.currentProject);
        IFile newTexFile = this.fileParser.findIFile(name, currentTexFile);
        if (newTexFile == null) {
            return null;
        }
        marker.clearProblemMarkers((IResource)newTexFile);
        return newTexFile;
    }

    private List<OutlineNode> loadInput(IFile newTexFile, IFile referringFile, int lineNumber) {
        MarkerHandler marker = MarkerHandler.getInstance();
        String fullName = this.getProjectRelativeName(newTexFile);
        List<OutlineNode> nodes = this.outlines.get(fullName);
        if (nodes == null) {
            try {
                nodes = this.fileParser.parseFile(newTexFile);
                this.outlines.put(fullName, nodes);
            }
            catch (IOException ioe) {
                marker.createErrorMarker((IResource)referringFile, "Could not parse file " + fullName + ", reason: " + ioe.getMessage(), lineNumber);
                return new ArrayList<OutlineNode>();
            }
        }
        if (!this.included.add(fullName)) {
            marker.createErrorMarker((IResource)referringFile, "Circular include of " + fullName, lineNumber);
            return new ArrayList<OutlineNode>();
        }
        return nodes;
    }

    private String getProjectRelativeName(IFile file) {
        return file.getFullPath().removeFirstSegments(1).toString();
    }
}

