/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.builder;

import net.sourceforge.texlipse.builder.AbstractBuilder;
import net.sourceforge.texlipse.builder.Builder;
import net.sourceforge.texlipse.builder.BuilderRegistry;
import net.sourceforge.texlipse.builder.ProgramRunner;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PsBuilder
extends AbstractBuilder {
    private Builder dvi;
    private ProgramRunner pdf;
    private Class<? extends Builder> builderClass;
    private boolean stopped;

    public PsBuilder(int i, Class<? extends Builder> clazz) {
        super(i);
        this.builderClass = clazz;
        this.isValid();
    }

    @Override
    public void reset(IProgressMonitor monitor) {
        super.reset(monitor);
        this.dvi.reset(monitor);
    }

    @Override
    public boolean isValid() {
        if (this.dvi == null) {
            this.dvi = BuilderRegistry.get(this.builderClass, "ps");
        }
        if (this.pdf == null || !this.pdf.isValid()) {
            this.pdf = BuilderRegistry.getRunner("ps", "pdf", 0);
        }
        return this.dvi != null && this.dvi.isValid() && this.pdf != null && this.pdf.isValid();
    }

    @Override
    public String getOutputFormat() {
        return "pdf";
    }

    @Override
    public String getSequence() {
        return String.valueOf(this.dvi.getSequence()) + '+' + this.pdf.getProgramName();
    }

    @Override
    public void stopRunners() {
        this.dvi.stopRunners();
        this.pdf.stop();
        this.stopped = true;
    }

    @Override
    public void buildResource(IResource resource) throws CoreException {
        this.stopped = false;
        this.dvi.buildResource(resource);
        if (this.stopped) {
            return;
        }
        this.monitor.subTask("Converting dvi to pdf");
        this.pdf.run(resource);
        this.monitor.worked(15);
    }
}

