/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.actions;

import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.editor.TexEditor;
import net.sourceforge.texlipse.properties.TexlipseProperties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.part.FileEditorInput;

public class PartialBuildAction
implements IWorkbenchWindowActionDelegate,
IEditorActionDelegate {
    private IWorkbenchWindow window;
    private IEditorPart editor;

    public void run(IAction action) {
        String value = action.isChecked() ? "true" : null;
        IProject project = ((FileEditorInput)this.editor.getEditorInput()).getFile().getProject();
        TexlipseProperties.setProjectProperty((IResource)project, "partialBuild", value);
        if (value == null) {
            TexlipseProperties.setSessionProperty((IResource)project, "partialFile", null);
            try {
                IFolder projectOutputDir = TexlipseProperties.getProjectOutputDir(project);
                IResource[] res = projectOutputDir != null ? projectOutputDir.members() : project.members();
                int i = 0;
                while (i < res.length) {
                    if (res[i].getName().startsWith("tempPartial0000")) {
                        res[i].delete(true, null);
                    }
                    ++i;
                }
                IFolder projectTempDir = TexlipseProperties.getProjectTempDir(project);
                res = projectTempDir != null && projectTempDir.exists() ? projectTempDir.members() : project.members();
                int i2 = 0;
                while (i2 < res.length) {
                    if (res[i2].getName().startsWith("tempPartial0000")) {
                        res[i2].delete(true, null);
                    }
                    ++i2;
                }
                IContainer sourceDir = TexlipseProperties.getProjectSourceDir(project);
                res = sourceDir.members();
                int i3 = 0;
                while (i3 < res.length) {
                    if (res[i3].getName().startsWith("tempPartial0000")) {
                        res[i3].delete(true, null);
                    }
                    ++i3;
                }
            }
            catch (CoreException e) {
                TexlipsePlugin.log("Error while deleting temp files", e);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.editor = targetEditor;
        action.setEnabled(this.editor instanceof TexEditor);
        if (action.isEnabled()) {
            IProject project = ((TexEditor)this.editor).getProject();
            if (project == null) {
                action.setEnabled(false);
                return;
            }
            action.setChecked(TexlipseProperties.getProjectProperty((IResource)project, "partialBuild") != null);
            this.run(action);
        }
    }
}

