/* Document.h
 *
 * Of all the parameters, those in the derived class Document are probably
 * the most basic. Calls to class Document routines can usually be resolved
 * directly into some simple PostScript output involving no nesting.
 *
 * Copyright 1992 Jonathan Monsarrat. Permission given to freely distribute,
 * edit and use as long as this copyright statement remains intact.
 *
 */

class Document : public Param {
 public:
   enum DocumentType {
      Begin,           //  The command last executed by \begin, or null
      CloseBrace,      //  If the token is a closebrace (not \end)
      Comment,         // If the token is part of a comment
      DocumentStart,   // Whether we're inside a \document{ } command
      End,             //  \end flushes the last command executed by \begin
      Ignore,          // Entering an "ignore mode" for pure LaTeX stuff
      JustDidSection,  // Don't indent the first paragraph in a section
      NewLine,         // The newline was found in the document
      PostScript,      // Whether we're inside a \postscript environment
      ShutDown,        // We're shutting down the main stack
      StartPage,       // Has this page been started with "StartPage"?
      Stealth,         // If the token is part of a stealth environment
      LastType
   };

   Document();
   Document(Document *);
   Param *copy();
   int set(int, float, char *);
   float get(int, char *);
   void postscript_set(int);
   void revert(Param *);
   static void begin(int, int, float, char *);
   static void end(int, int, float, char *);
   static void documentstyle(int, int, float, char *);
 private:
   float values[LastType];
   char begin_command[MAXSTRING];
   static float start_page;
};
