/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.jmakepdfx;

import com.dickimawbooks.jmakepdfx.Jmakepdfx;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JTextField;

public class FileField
extends Box
implements ActionListener {
    private JTextField textField;
    private JButton button;
    private JFileChooser fileChooser;
    private Container parent;
    private int mode;

    public FileField(Container container, JFileChooser jFileChooser) {
        this(container, null, jFileChooser, 0);
    }

    public FileField(Container container, JFileChooser jFileChooser, int n) {
        this(container, null, jFileChooser, n);
    }

    public FileField(Container container, String string, JFileChooser jFileChooser) {
        this(container, string, jFileChooser, 0);
    }

    public FileField(Container container, String string, JFileChooser jFileChooser, int n) {
        super(1);
        this.fileChooser = jFileChooser;
        this.parent = container;
        this.mode = n;
        this.add(Box.createVerticalGlue());
        Box box = Box.createHorizontalBox();
        this.add(box);
        this.textField = new JTextField(string == null ? "" : string, 20);
        Dimension dimension = this.textField.getPreferredSize();
        dimension.width = (int)this.textField.getMaximumSize().getWidth();
        this.textField.setMaximumSize(dimension);
        box.add(this.textField);
        this.button = new JButton("...");
        this.button.setActionCommand("choose");
        this.button.addActionListener(this);
        box.add(this.button);
        this.add(Box.createVerticalGlue());
        this.setAlignmentY(0.5f);
        this.setAlignmentX(0.0f);
    }

    @Override
    public void setAlignmentY(float f) {
        super.setAlignmentY(f);
        this.textField.setAlignmentY(f);
        this.button.setAlignmentY(f);
    }

    @Override
    public void setAlignmentX(float f) {
        super.setAlignmentX(f);
        this.textField.setAlignmentX(f);
        this.button.setAlignmentX(f);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == null) {
            return;
        }
        if (string.equals("choose")) {
            this.fileChooser.setFileSelectionMode(this.mode);
            File file = this.getFile();
            if (file != null) {
                this.fileChooser.setCurrentDirectory(file.getParentFile());
                this.fileChooser.setSelectedFile(file);
            }
            this.fileChooser.setApproveButtonMnemonic('S');
            if (this.fileChooser.showDialog(this.parent, Jmakepdfx.getLabel("file.select")) == 0) {
                this.textField.setText(this.fileChooser.getSelectedFile().getAbsolutePath());
            }
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.textField.requestFocusInWindow();
    }

    public JTextField getTextField() {
        return this.textField;
    }

    public File getFile() {
        String string = this.getFileName();
        if (string == null || string.equals("")) {
            return null;
        }
        return string.contains(File.separator) ? new File(string) : new File(this.fileChooser.getCurrentDirectory(), string);
    }

    public String getFileName() {
        return this.textField.getText();
    }

    public void setFileName(String string) {
        this.textField.setText(string);
    }

    public void setCurrentDirectory(String string) {
        this.setCurrentDirectory(new File(string));
    }

    public void setCurrentDirectory(File file) {
        this.fileChooser.setCurrentDirectory(file);
    }

    public void setFile(File file) {
        this.setCurrentDirectory(file.getParentFile());
        this.setFileName(file.getName());
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.textField.setEnabled(bl);
        this.button.setEnabled(bl);
    }
}

