/*
 * A string definition is something like
 * 
 * @string{ cacm = "Communications of the ACM }
 * 
 * Created on Mar 17, 2003
 *
 * @author henkel@cs.colorado.edu
 * 
 */
package bibtex.dom;

import java.io.PrintWriter;
import java.io.Serializable;

import bibtex.visitor.BibtexVisitor;

/**
 * @author 	henkel
 * @author 	Yann-Gal Guhneuc
 */
public class BibtexStringDefinition
	extends BibtexAbstractEntry
	implements Serializable {

	protected BibtexStringDefinition(String key, BibtexAbstractValue value) {
		this.key = key;
		this.value = value;
	}

	private String key;
	private BibtexAbstractValue value;

	/**
	 * @return String
	 */
	public String getKey() {
		return key;
	}

	/**
	 * @return BibtexValue
	 */
	public BibtexAbstractValue getValue() {
		return value;
	}

	/**
	 * Sets the key.
	 * @param key The key to set
	 */
	public void setKey(String key) {
		this.key = key;
	}

	/**
	 * Sets the value.
	 * @param value The value to set
	 */
	public void setValue(BibtexAbstractValue value) {
		this.value = value;
	}

	/* (non-Javadoc)
	 * @see bibtex.dom.BibtexNode#printBibtex(java.io.PrintWriter)
	 */
	public void print(PrintWriter writer) {
		writer.print("@string{");
		writer.print(this.key);
		writer.print("=");
		this.value.print(writer);
		writer.println("}");

	}

	public void accept(final BibtexVisitor visitor) {
		visitor.visit(this);
		this.getValue().accept(visitor);
	}
}
