{$V-,N-}
program vidmode;
uses
  DOS, bibcrt, bibstrg;
const
  vver = '1.1, March 1995';
type
  memscreentype = array[1..132*60] of word;
var
  nlines: byte;
  icode,i: integer;
  memscreen: memscreentype;
  rescolls,resrows: byte;
  newmode,newnumcolls,newnumrows: byte;
  tmp,param: string;
  c: char;
  Dir: DirStr;
  PrName: NameStr;
  Ext: ExtStr;

begin
  AltPrtScRoutine:=false;
  fsplit(ParamStr(0),Dir,PrName,Ext);
  StrLwr(PrName);
  param:='';
  if (ParamCount>=1) then
  begin
    param:=ParamStr(1);
    if param[1] in ['/','-'] then Delete(param,1,1);
  end;
  if (param='?') or (param='h') or (param='help') then
  begin
    tmp:=prname; StrUpr(tmp);
    writeln;
    writeln(tmp,' - A video mode manager, version ',vver,'.');
    writeln;
    writeln('Parameters:');
    writeln('-----------');
    writeln;
    writeln('none         - Report video mode & screen size.');
    writeln('?            - Show usage.');
    writeln('<number>     - Switch to video mode <number>.');
    writeln('mda/hgc      - MDA/Hercules 25 line mono mode.');
    writeln('ega/vga      - CGA/EGA/VGA 25 line mode.');
    writeln('ega <number> - EGA 25/29/35/43 line mode.');
    writeln('vga <number> - VGA 12/14/16/20/21/25/28/29/30/33/34/35/40/43/48/50/60 lines.');
    writeln('e<number>    - Same as "',prname,' ega <number>".');
    writeln('v<number>    - Same as "',prname,' vga <number>".');
    writeln('Alt[PrtSc]   - Install alternate (video BIOS) PrtSc routine.');
    Halt;
  end;
  VideoInit('');
  if param='' then
  begin
    tmp:='';
    if oldvidmode mod 16<10 then c:=chr(oldvidmode mod 16 + Ord('0'))
    else c:=chr(oldvidmode mod 16 -10 + Ord('A'));
    tmp:=c;
    if OldvidMode>15 then
    begin
      if oldvidmode div 16<10 then c:=chr(oldvidmode div 16 + Ord('0'))
      else c:=chr(oldvidmode div 16 -10 + Ord('A'));
      tmp:=c+tmp;
    end else tmp:='0'+tmp;
    tmp:=tmp+'h';
    {
    writeln('Video mode is ',tmp,' (decimal ',oldvidmode,'), screen size ',
            Oldnumcolls,'x',OldNumRows,', page size ',MemW[$0040:$004c],
            ' bytes.');
    }
    writeln('Video mode is ',tmp,' (decimal ',oldvidmode,'), screen size ',
            Oldnumcolls,'x',OldNumRows,'.');
    Halt(OldVidMode);
  end;
  newmode:=oldvidmode;
  nlines:=0;
  if (length(param)>=3) and (Copy(param,1,3)='alt') then
  begin
    SelectAltPrtSc; Halt(OldVidMode);
  end;
  if param[1] in ['e','v','c'] then
  begin
    if not (oldvidmode in [2,3]) then newmode:=3;
    nlines:=25;
    if ((length(param)>1) and (param[2] in ['0'..'9'])) or (ParamCount>1) then
    begin
      if ParamCount>1 then
        Val(ParamStr(2),nlines,icode)
      else begin
        Delete(param,1,1);
        Val(param,nlines,icode);
      end;
      if (icode<>0) or not(nlines in [12,14,16,20,21,25,28,29,30,33,34,35,40,43,48,50,60 ]) then
      begin
        writeln('Can set only 12/14/16/20/21/25/28/29/30/33/34/35/40/43/48/50/60 lines!');
        Halt(OldVidMode);
      end;
    end;
  end else if (param[1]='m') or (param='hgc') or 
      ((length(param)>=4) and (Copy(param,1,4)='herc')) then newmode:=7
  else begin
    newmode:=0;
    if param[1]='#' then
    begin
      delete(param,1,1);
      Val(param,newmode,icode);
      if (length(param)<1) or (length(param)>3) or (icode<>0) then
      begin
        writeln('Illegal parameter!'); Halt(OldVidMode);
      end;
    end else
    begin
      if param[1]='$' then delete(param,1,1);
      if param[length(param)]='h' then delete(param,length(param),1);
      if length(param)=1 then param:='0'+param;
      if param[2] in ['0'..'9'] then newmode:=newmode+Ord(param[2])-Ord('0')
      else if param[2] in ['a'..'f'] then newmode:=newmode+Ord(param[2])-Ord('a')+10
      else begin
        writeln('Illegal parameter!'); Halt(OldVidMode);
      end;
      if param[1] in ['0'..'9'] then newmode:=newmode+16*(Ord(param[1])-Ord('0'))
      else if param[1] in ['a'..'f'] then newmode:=newmode+16*(Ord(param[1])-Ord('a')+10)
      else begin
        writeln('Illegal parameter!'); Halt(OldVidMode);
      end;
    end;
  end;
  
  MOVE(VideoBuf^,memscreen,OldNumColls*OldNumRows*2);
  if (newmode in [2,3]) and (nlines>0) then vgalines(nlines)
  else set_video_mode(newmode);
  
  NewNumColls:=MaxX; NewNumRows:=MaxY;
  resColls:=OldNumColls; if rescolls>newnumcolls then rescolls:=newnumcolls;
  resrows:=OldYcursor; if resrows>newnumrows then resrows:=newnumrows;
  for i:=1 to resrows do
    move(memscreen[(i-1+oldYcursor-resrows)*oldnumcolls+1],
         Ptr(VideoSeg,VideoOfs+(i-1)*2*newnumcolls)^,2*rescolls);
  if OldXCursor>NewNumColls then OldXCursor:=NewNumColls;
  if OldYCursor>NewNumRows then OldYCursor:=NewNumRows;
  if OldYcursor=1 then GotoXY(OldXcursor,OldYcursor)
  else GotoXY(OldXcursor,OldYcursor-1);

  Halt(OldVidMode);
end.
