Part of the Occam utility.
Laurent Siebenmann   <lcs@topo.math.u-psud.fr>
Master posting 1994, ftp ftp.math.u-psud.fr
Alpha version 6-94 subject to change.


     ====== Occam Syntax and Specifications ====== 

    Occam is a system for extracting from a large macro file
exactly those macros required by a given typescript.  Its
active parts are  auditor.tex  that determines which macros
are necessary, and DefStrip a utility to deletes unnecessary
macros.

    The first created DefStrip utility is a QUEDM script; QUEDM
is a editor with macro capabilities that is available on
Macintosh computers.  (Hopefully a version of this utility
which is a ".tex" program like auditor.tex will follow in due
time; it would be very analogous to the LaTeX "docstrip.cmd"
utility.)

(I) About the QUEDM Version of Summer 1994 (preliminary)

     The Occam syntax is for TeX macro files. Its purpose is to let
the "DefStrip" utility delete selected lines of the file with the
help of a list audit.lst of "unused" control sequences (mostly
macros).

      These lines come in blocks of roughly two sorts:

 (a)  Material that is to be unconditionally deleted.

 (b)  Blocks surrounding lines beginning (modulo spaces) with
one of:

    \Def  (variant of \def)
    \gDef  (variant of \gdef or \global\def)
    \Let  (variant of \let)
    \gLet  (variant of \global\let)
    \Font  (variant of \font)
    \Mathchardef  (variant of \mathchardef)
    \Newsymbol  (variant of \newsymbol)

This list may be extended. A particular such block is to be deleted
precisely if the macro name is designated in an external list called
"audit.lst". output by the TeX utility "auditor.tex".


MAIN SPECIFICATIONS of the Occam syntax.

     ASCII (7-bit) text files only. No tab characters please.

     The names of macro files conforming to this syntax should
involve the suffix "aud" in some form if at all possible.  For
example, "x.sty" might become "x-aud.sty" or "x.aud", say
"x-aud.sty" for future reference.

     See internal documentation of "audit.tex" to generate a
list of macros in "x-aud.sty" that are unnecessary in a
given typesetting job "x.tex".

     In x-aud.sty, the lines

 %^ This file is formatted by <programmer>, <date>, <email> 
 % for use of the Occam utility posted on the CTAN archives
 % (master posting 1994 on ftp ftp.math.u-psud.fr)
 %% DO NOT ALTER "OCCAM" SIGNS  <percent>^  or  <percent>_ , ^_  
 %% UNLESS YOU UNDERSTAND THEM!
  \let\Def\def \let\gDef\gdef \let\Let\let 
  \def\gLet{\global\let} \let\Font\font 
  \let\Mathchardef\mathchardef\let\Newsymbol\newsymbol
  \let\MATHchardef\mathchardef\let\NEWsymbol\newsymbol
 % \input auditor.tex %% keep auditor.tex available
 %% comment out above line to suppress audit function. %_

should appear in the header. 

     Two composite symbols %^ and %_ are employed to
designate possible deletions.  On its line %^ is always
preceeded by spaces only (zero or more); similarly %_ is
always followed by spaces only.

 (A) Unconditionally deleted material:

 %%^_ <delete me>

Everything from %%^_ to the end of file is then deleted.
To delete just a segment use

 %^ <delete me> %_

The deleted material can span many lines, but must include no
blank line.  We have just seen a block of such material above!
Note that it may well contain \Def etc. but not %^, %_.

     The unconditional deletions will occur in the order
described, and before conditional deletions are considered.


     (B) Conditionally deleted material:

 \Def \somemacro<maybe delete me>%_

may cause deletion of the block of lines beginning with \Def
etc. and ending with %_. This material is really deleted
precisely if the macro \somemacro is marked for deletion in
the the file "audit.lst".

     The material <maybe delete me> must contain no blank line nor %^,
%_, \Def etc; but it is otherwise arbitrary; in particular, macro
arguments, comments, and auxiliary definitions are OK.

     Along with this material some additional preceding material
is deleted, namely contiguous preceeding lines (if any) that (a)
are nonempty and (b) contain no %_ (but \Def etc; are allowed).
Typically, such preceeding material might be comments or commands
"owned" by the macro being deleted. For example the whole block

 %_
 \ifx\undefined\eightpoint
       \Def\eightpoint{}
 \fi  %_

will be deleted precisely in case \eightpoint is marked as unused
in audit.lst.  (The first %_ could be replaced by a blank line.)

     Note that %_ is not really a closing delimiter since it can
exist in arbitrary numbers without belonging to a matching pair.
For another example, consider:

     \Def\amacro ...%_
     \newtoks\btoks %_
     \Def\cmacro ...%_

Here, the the first two %_ prevent \newtoks\btoks being deleted
--- in all circumstances.

      The example 

     \Def\amacro ...
     \Def\bmacro ...%_

is incorrect because the block beginning with \Def\amacro ...
contains \Def\bmacro.

      There is a second type of conditional deletion. Suppose
\amacro  is not used and is so designated in audit.lst.  It
often occurs that several *disjoint* blocks of lines  should be
deleted along with  \amacro.  These blocks should be 
designated as follows:

     %/^\amacro
        <stuff>
     %/_

\amacro is called the sentinel (watchman).
The sentinel's line %/^... must contain nothing more than
%/^\amacro  and blank space.  The initial and terminal 
lines will vanish along with <stuff>.

IN SUMMARY: the blocks %^...%_ are unconditionally deleted,
while a block signalled by  \Def, \gDef, etc. with the help of
%_ and/or blank lines is deleted or not according as the macro
following \Def etc. is marked for deletion in "audit.lst".
Similarly for blocks with sentinel macro.  None of these blocks
for conditional or unconditional deletion is allowed to contain
an empty line nor any extraneous %^,%_,%/^,%/_,%%^_,\Def,
\gDef, etc.  The blocks introduced by \Def, \gDef, etc. include
material extending backward as far as (but not including) a
preceding line that is blank or terminated by one of %_,%/_.  No
such extension for blocks introduced by %^, %/^ is allowed --- 
nor would it be helpful.

    Beyond these primary deletions, the utility DefStrip
performs a few auxiliary tasks:

 --- All remaining \Def, \gDef, etc. are converted to  \def,
\global\def, etc.. Also, if a remaining %_ is alone on its line
(spaces ignored), the whole line disappears. And each remaining %_
*not* alone on its line becomes % (this is the only deletion that
can affect a line that survives.)

 --- any empty line sequence (usually created by the deletion of
blocks of lines) is reduced to a single empty line.

 --- Residual appearances in  x-aud.sty  of macros marked for
deletion in audit.lst  will be marked by %%[VESTIGE] (on a new
following line). They should be considered a failure of the current
Occam format".

    Users may find the vestiges mentioned above hard to deal with.
(Can they simply be deleted?) Thus programmers should attempt to
set up "Occam" formatting so as to assure that vestiges
never occur; for their part, users should report vestiges to the
programmers along with the involved audit.lst file from
auditor.tex.

   It is the programmer's or the user's responsibility to
assure that the deletions made by the DefStrip utility result
in a useful TeX macro file. The DefStrip utility is of little
help here since it does not understand the macros. Thus it is
expected that programmers take on the task of preparing macro
files in Occam format. In most cases, anyone who programs TeX
macros at an intermediate level will find it an easy task to
put a macro file in Occam format.  Beware that a good deal of
testing and a bit of cleverness is usually necessary to assure
that the Occam formatting does the job desired and in the most
efficient way.

