void show_bits (unsigned char *baseptr, int bitwidth, int bitheight)
{
  int row,col;
  unsigned char mask, *ch;
  
  ch = baseptr;
  mask = 0x80;
  for (row = 0; row < bitheight; row++)
    {    
      for (col = 0; col < bitwidth; col++)
	{
	  if (*ch & mask == mask)
	    printf("*");
	  else
	    printf(".");
	  
	  mask >>= 1;
	  if (mask == 0)
	    {
	      mask = 0x80;
	      ch++;
	    }
	}
      if (mask != 0x80)
	ch++;
    }      
}

unsigned char *get_bits(unsigned char *baseptr, 
			int rowbytes,
			int bitofs, 
			int bitwidth,
			int bitheight,
			int *firstrow,
			int *lastrow)
{
  int width, maplen;
  unsigned char *rect, *rowptr, *sourceptr, *destptr;
  int row, col;
  char mask, sourcemask, destmask;

  rowptr = baseptr + (bitofs / 8);
  *firstrow = -1;
  *lastrow = -1;
  for (row = 0; row < bitheight; row++)
    {
      sourceptr = rowptr;
      mask = (bitofs % 8);
      for (col = 0; col < bitwidth; col++)
	{
	  if (*sourceptr & mask == mask) 
	    {
	      if (*firstrow < 0)
		*firstrow = row;
	      *lastrow = row;
	    }
	  mask >>= 1;
	  if (mask == 0)
	    {
	      mask = 0x80;
	      sourceptr++;
	    }
	}
      rowptr += rowbytes;
    }
      
  width = (bitwidth + 7) / 8;
  maplen = width * (*lastrow - *firstrow + 1);

  rect = (unsigned char *) malloc(maplen);
  bzero(rect, maplen);

  rowptr = baseptr + (bitofs / 8);
  rowptr += (rowbytes * (*firstrow));
  destptr = rect;
  for (row = *firstrow; row <= *lastrow; row++)
    {
      sourceptr = rowptr;
      sourcemask = (bitofs % 8);
      destmask = 0x80;

      for (col = 0; col < bitwidth; col++)
	{
	  if (*sourceptr & sourcemask == sourcemask) 
	    *destptr |= destmask;
	
	  sourcemask >>= 1;
	  if (sourcemask == 0)
	    {
	      sourcemask = 0x80;
	      sourceptr++;
	    }

	  destmask >>= 1;
	  if (destmask == 0)
	    {
	      destmask = 0x80;
	      destptr++;
	    }
	}
      
      if (destmask != 0x80)
	destptr++;
      rowptr += rowbytes;
    }


}
