/*
 *			TeX Device Driver dviout for Windows95/NT
 *							copyright by SHIMA, 1996
 *
 *	inter.h: Module between User interface of Win32API and Kernel
 *
 */

/*
					   vȊ֐

  StartDviout();	// 

  SetPara();		// Kvȃp[^Zbg

	SetStartPage();	// KvȂŏɊJy[W`

  OpenDvi();		// DVI@CI[vāAy[W̏Ȃǂǂ

  ExpandPage();		// w肳ꂽy[WWJ
					// ɐ旧At@C̃^CX^v`FbN
					// ^CX^vςꍇAIvVɕύX
					// ꍇAKvȍďȂ

  MakeBMP();		// WJy[WA\p DIB wb_tŃ
					// [ɓB
					// ׂwƂ GetWindowBMP() pB
					// y[WƂ́AExpandPage() 
					// Kv͂ȂB

  free_bmp();		// DIB  [̊J
					// Ă΂Ȃێ
  ...
	SetPara();		// p[^Ȃǂ̕ύX
  ChgPage();		// ̃y[W
  ExpandPage();
  MakeBMP();
  ...
 */

#ifndef INC_INTER_H
#define INC_INTER_H

#ifndef	_INC_WINDOWS
typedef struct tagPOINT
{
	int x;
	int y;
} POINT;
#endif

#define	MAX_PATH	260

/* The following is used to define boxes for Searching a string 
/    and HyperTeX's references
/  Coordinates are used in Expanded bitmap page buffer (in ???dpi)
*/
struct S_BOX {
	short int base;
	short int x0;
	short int x1;
	short int y0;
	short int y1;
	short int dir;				/* TATE/YOKO and other reseved flags */
	union {
		char *href;				/* Hyper Reference */
		int	 found;				/* Reference to the pointer of DVI file */
	}sub;
};

/* The following is used to define the named tags refered by HyperTeX/source special
/   Coordinates are in expanded bitmap buffer
/   HyperTeX        *name : target name  (name[0] != 1 , 2);
/   Source special   name[0] = 1  YOKO,   = 2  TATE
/                    name[1]name[2]name[3]        = line number     (255)
					 name[4]name[5]name[6]name[7] = position in DVI (255)
/                    *(name+8) : source file name
*/
struct H_NAME {
	short int x;
	short int y;
	char *name;
};

#define	IsSRCspecial(x)	(x.name[0]==1||x.name[0]==2)

/* The following is used to recored the former pages where we have been
	 Ringed buffer of arrays of the structure of size MAX_H_HIST
*/
struct HyperHistory{
	int id;						/* ID of DVI file */
	short int page;
	short int x;
	short int y;
	short int flag;
};

/* This is a history of file, array of size MAX_F_HIST */
struct F_HIST {
	int	id;
	int page;
	char name[MAX_PATH];
};

/* This is a file menu, array of MAX_F_MENU */
struct F_FMENU {
	int page;
	char name[MAX_PATH+4];
};

/* ---------------------------------------------------------------------- */

/*			p[^̐ݒ		*/

void StartDviout(void);
/* NɈ̂݌Ăԏ̊֐ */

char *def_dvifile(int, char **, char *);

void *SetPara(char *para, int mode);
/* p[^̐ݒƕύXȂǂs
// mode = 			 (option.h Œ`Ăj
//   SET_OPTION
//        IvV̒`ĩIvV𓯎wj
//
//   CHECK_OPTION
//		  ̃IvV̍\̂̃AhXԂ
//		  ݂Ȃꍇ NULL
//
//   CHECK_TOP
//		  IvV\̂̔z̐擪̃|C^Ԃ
//
//   SHOW_DEFAULT
//        IvV̓ei܃ftHglj镶̃|C^Ԃ
//
//   SHOW_OPTION
//        IvV̓eiܐݒlj镶̃|C^Ԃ
//
//   SAVE_REG
//		  IvV̒`RegistryւSaveĩIvV𓯎wj
*/
enum {SHOW_DEFAULT, SHOW_OPTION, SET_OPTION, CHECK_OPTION, GET_TOP, SAVE_REG};

int KeepPara(int mode);
void SetParaFlag(char *opt, BOOL val);
BOOL GetParaFlag(char *opt);
BOOL GetParaFlagDefault(char *opt);
void SetParaString(char *opt, char *val);
int SetParaStringDirect(char *opt, char *val);
char *GetParaString(char *opt);
char *GetParaStringDefault(char *opt);
void SetParaInt(char *opt, int val);
int  GetParaInt(char *opt);
int  GetParaIntDefault(char *opt);
char *PrintAllPara(int mode);
char *GetParaAny(char *opt);

/*           y[W̐ݒ			*/

void SetStartPage(int num);
/*  ʁior ŏjDVIt@Cǂގ̃X^[gy[Wݒ肷
//  \傫ȒĺAŌ̃y[WӖ
//  OpenDvi() ŎQƂAQƂꂽ 1 ɃZbg
*/

int  GetStartPage(void);
/*  LŐݒ肳ꂽy[W𓾂 */

int	ChgPage(int page);
/*   ExpandPage() œWJy[W`(physical page)
//  \ɑ傫ȒĺAŌ̃y[WӖ
//  ʂ DVI t@CɕύXƁAݒ肳Ăl͖ɂȂ
//  ߂l͐ݒ肵y[Wԍ
*/

int GetTotalPage(void);
/*  ݂DVIt@C̑Sy[WԂ */

int GetCurrentPage(void);
/*  ݂̃y[Wԍ(physical)Ԃ */

int GetMaxNombrePage(void);
/*  ő̘_y[WԍԂ */

int TransPage(int page);
/*  y[Wԍ logical Ȃ̂ɕϊ */

int CheckPage(int page);
/*  y[WԍAɑ݂͈͂Ɏ߂lԂ */

int SearchPage(int page, int skip);
/*  logical ȃy[Wԍ page ɑΉy[W physical  skip y[W
//  ȍ~TA炻 physicaly[WԍԂ
//  Ȃ΁A0 Ԃ(skip = 0: ŏ珇ɒT)
*/

int IsHyperTag(void);
/*  current page  HyperTeX \special 邩ǂ𒲂ׂ
//  return = -2: DVI t@C[hĂȂAHyperTeX 𖳎
//               tOiF_H_IGNOREjĂ
//           -1: HyperTeX \special ݂Ȃ
//            0: `FbN
//         >  0: ݂B̒l nn Ƃ
//				 h_box[h_box[nn].x0],...,
//					h_box[h_box[nn].x0 + h_box[nn].y0 - 1]   : href  Box
//               h_name[h_box[nn].x1],...,
//					h_name[h_box[nn].x1 + h_name[nn].y1 - 1] : name  Box
*/

/*			TCY֘A			*/

int GetTextXSize(void);
/*  WJy[W̉̃TCYԂiPIXELj */

int GetTextYSize(void);
/*  WJy[W̏c̃TCYԂiPIXELj */

int GetBufXSize(void);
/*  WJpy[Wobt@̉̃TCYԂiPIXELj */

int GetBufYSize(void);
/*  WJpy[Wobt@̏c̃TCYԂiPIXELj */

int GetXDpi(void);
/*  ̉𑜓x dpi ̒lԂ */

int GetYDpi(void);
/*  c̉𑜓x dpi ̒lԂ */

void ReSetDpi(void);
/*  c dpi Zbg */

int GetMaginification(void);
/*  Magnification ̒lԂ */

int SetGamma(int num);
/*	num > 0:  Gray Scale ̃K}␳̃p[^ num/1000 ɐݒ
//  num < 0:  ] Gray Scale ŁAK}␳̃p[^ -num/1000 ɐݒ
//  num = 0:  ύXȂ
//  return :  ݒl
//            SetGamma(0); Ō݂̐ݒl킩
*/

char *GetOpenName(void);

int SetBright(void);
/*  bright ςƂɌĂ
//  return bright
*/

void SetBMP(void);
/*  BMP ςƂɌĂ */

void SetXYGray(int xscale, int yscale);
/*  Gray Scale ɂ鉡Əc̏k{ݒ肷
//  AAxscale <= 0 ́Ȁk{ύXȂƂӖ
//  ܂Ayscale = 0 ́AcƓkɂ邱ƂӖ
//  yscale < 0 ́Ac̏k{ύXȂƂӖ
*/

int GetXGray(void);
/*  ̏k{Ԃ */

int GetYGray(void);
/*  c̏k{Ԃ */

int SetColor(int color);
/*  k̐F̃rbgݒ肷
//  color = 4:  16F[h
//        = 8: 256F[h
//          LȊÓAێ
//  ԂĺAݒl
*/

/*	 y[W̓WJ Gray Scale DIB ւ̕ϊ	*/

int OpenDvi(char *fname);
/*  fname Ƃt@C DVIt@CǂݍŁAy[WȂǂ
//   SetStartPage() Ŏw肵y[WŏɓWJy[Wɐݒ肷
//  return: y[WԂ
//          -1 ́ADVIt@C̃I[vɎsƂ\
//          ̎s̏ꍇAǂł DVIt@C΁A͕ێ
*/

char *GetFTime(void);
/*  ݕ\Ă dvit@C̃^CX^v𓾂
*/

int CheckRenew(int wait);
/* ^CX^vύXꂽǂׂ
//  0: open łȂ
//  1: ύXꂽ
// -1: ςĂȂ
// -2: ύX
*/

void ExpandPage(void);
void ExpandPage0(void);
/*  DVIt@Cɉ炩̕ύXꍇAp[^ύXꂽꍇ
//  ꂼɉĐݒ蒼ÂƎw肵y[WWJ
//  ݒ̂蒼sȂAWJꏊ̓[œʒu
//  ߂̂ŁAxɈێłȂB
*/

char *MakeBMP(void);
/*  WJꂽy[WAKvȂ gray scale ɂďkADIB `Ń
//  ɓWJĕԂB͐VɊmۂ̂ŁAsvɂȂĂяo
//   free_bmp() ŊJB
*/

char *GetWindowBMP(int x, int y, int width, int height, int xdiv, int ydiv,
	unsigned char *buf);
/*  ƓAy[Ẅꕔ؂o DIB `ɕϊB
//
//  ؂oʒuȂǂ́AkO PIXEL PʂŎw肷B_Ƃ
//  (x,y) ؂o`̍̍W
//  width x height ؂o傫
//  xdvi, ydiv AꂼꉡAc̏k{
//
//    x + width, y + height y[W͈̔͂Ɏ܂Ȃꍇ́Awidth, 
//    height ꂼ؂߂B
//
//    xdiv = 0: ftHg̉k{p
//    xdiv < 0: kȂA16F܂256F[h DIB `ɂ
//              ydiv ͖î߁A0 Ƃj
//    ydiv = 0: ftHg̏ck{p
//    ydiv < 0: ydiv ́Axdiv ɓ
//
//  ksƂ́Agray scale ɂȂi16F[h DIBj
//  ksȂƂ́A2F[h DIB
*/

void free_bmp(unsigned char *);
/*  y[Wϊēꂽ[ DIB svɂȂ΁Å֐
//  [
*/

char *GetBMPdata(int num, int *x_pos, int *y_pos, int *x_size, int *y_size, 
	int *type);


void ClearKeepBMP(void);
void FreeBMPdata(void);
void AllFree(void);

int ToDviDir(void);
/* dvi file ̃fBNgAJgɂB */
/* -------------------------------------------------------------------- */
		/* T[`  HyperTeX */

/* flag used by  mode  in FillBox() and ColorS_Box() */
#define	F_B_BUFXY		1		/* ignored by ColorS_Box() */
#define	F_B_BOUNDARY	2
#define	F_B_SET			4
#define	F_B_REV			8

/* color used by  mode  in FillBox() and ColorS_Box() */
#define	F_B_ERACE		0x00
#define	F_B_SECRET		0x70
#define	F_B_YELLOW		0x10
#define	F_B_PURPLE		0x20
#define	F_B_RED			0x30
#define	F_B_SKY			0x40
#define	F_B_BLUE		0x50
#define	F_B_GREEN		0x60
#define	F_B_BLACKC		0x80
#define	F_B_BLUEC		0x90
#define	F_B_GREENC		0xa0
#define	F_B_SKYC		0xb0
#define	F_B_REDC		0xc0
#define	F_B_PURPLEC		0xd0
#define	F_B_YELLOWC		0xe0
#define	F_B_WHITEC		0xf0

/* flag used by  mode  in ColorS_Box() */
#define	F_CB_ULINE		0x8000
#define	F_CB_UULINE		0x9000
#define	F_CB_OLINE		0xa000
#define	F_CB_LLINE		0xc000

BOOL FillBox(unsigned char *pDib, int x1, int y1, int x2, int y2, 
	unsigned char mode);
/*   Draw a colored box in (256 color) BMP
//	(x1,y1)-(x2,y2)		 : coordintes of diagonal vertices of the box
//  					   (0,0) is the left upper corner
//  draw a (part of) box within the BMP
//
//  mode & 0xf0 = 0      : Erace the color
//
//	mode & 0x01 = 0      : coordinates are in BMP
//                1      : coordinates are in the original page buffer
//
//  mode & 0x02 = 0      : fill box
//                2      : draw boundary
//
//  mode & 0x0c = 0      : or  color
//                4      : set color
//				  8      : reverse  (ignore : mode & 0xf0)
//
//  mode & 0x80 = 0      : background
//                0x80   : forground
//
//  mode & 0xf0 = 
//       color box (with gray characters in black)
//		   0x00: original          0x10: yellow box      0x20: purple box
//         0x30: red box           0x40: light blue box  0x50: blue box
//         0x60: green box         0x70: black box
//
//       color characters (gray scaled with a white background)
//         0x80: black char        0x90: blue char       0xa0: green char
//         0xb0: light blue char   0xc0: red char        0xd0: purple char
//         0xe0: yellow char       0xf0: while char
//
*/

void ColorS_Box(unsigned char *pDib, struct S_BOX *box, int mode);
/* struct S_BOX *box ɊÂ 256F[hBMP ɐF
//
// mode & 0xfe       : FillBox  mode ɑΉ
// mode & 0x8000 = 0 : box ŚA܂́A̒̕A܂͘gɐF
// mode & 0x8000 = 0x8000  ̎͐Ft̐iʏAmode & 0x80 = 0x80j
//    
//       (mode & 0x4000)? : ĉƂAEɂH
//       (mode & 0x2000)? : ̂ƂAA_[CłȂI[o[CH
//       (mode & 0x1000)? : ̂ƂAA_[CɁH
// mode & 0x10000 = 0x10000 : A̐FÂicolor box̐Fwj
*/

int CheckS_Box(struct S_BOX *box, int x, int y);
/*  Check if    (x,y) is contained in Box
//  return  0:  (x,y) is contained in Box
//          1:  (x,y) is located after the Box
//         -1:  (x,y) is located before the Box
//   (x,y) is a coordinate in Buffer
*/

		/* HyperTeX */

extern struct S_BOX *h_box;			/* <a href="..."> ... </a>	*/
extern struct H_NAME *h_name;		/* <a name="...">			*/
extern char *hypertag;				/* used by SetHyperTag()	*/

extern  int f_hyper;
#define	F_H_IGNORE			0x001	/* ignore HyperTeX specials */
#define F_H_DIRECT			0x002	/* jump directly outer HyperTeX href */

/* used as internal flags */
#define	F_H_SKIP			0x004	/* skip expanding HT specials */
#define	F_H_BOX				0x008	/* within HyperTeX specials */
#define	F_H_SEARCH			0x100	/* search HyperTeX tag name */
#define	F_H_DVIOPEN			0x200	/* HyperJump after opening DVI */
#define F_H_CURRENTPAGE		0x400	/* found tag on the current page */

int SearchH_Name(char *name);
/*  Search HyperJump tag name (begining with '#') in the current DVI file
//  return    : the page containing the tag name
//              current page is changed to the page and ExpandPage();
//         < 0: not exist and current page is not changed
*/

int GetH_NamePos(POINT *pt, char *name);
/*  Get (pt.x, pt.y) in Buffer for a given HyperJump tag name
//  return :1  exist
//         :0  not exist
*/

void SetHyperTag(char *name);
/*  Define href *name for HyperJump before the target DVI file will be opened */

int CheckHrefDvi(char *href, char *name);
/* Check if href is a local DVI file (i.e. <a href="file:...#...">)
// Set DVI file name in *name (resolving PATH relative to the current DVI
//  file) and SetHyperTag()
//  return: 5    	file: local DVI
//			4		file: local other file(safe)
//			3		file: local other file(no extension)
//			2		file: local other file(execute)
//          1   	file: not found
//			0		others
*/

	/* Search string */

extern unsigned int f_s_dpi;
extern struct S_BOX *s_box;
extern int	s_box_pt;
extern unsigned int f_s_search;		/* 1: word search in a page
									-> 1: not exist
									-> 0: exist and the page is expanded */

extern unsigned int f_s_flags;
#define	F_S_NOCASE			1		/* ignore case for alphabetical word */
#define	F_S_WORD			2		/* guess boundaries of words */

/* used as internal flags */
#define	F_S_ALPHA			0x1000	/* alphabetical word */

void SetSearchStr(unsigned char *string);
/* string ̃T[`ZbgBf_s_search = 1 Ɛݒ肳B
// KvȂy[WύX ExpandPage() sƁA񂪃T[`B
//   šʂ́F
// f_s_search = 1, s_box_pt = 0:			not found
//      ̃y[WTƂ́Ay[WύX ExpandPage() s
//      ߂Ƃ́Af_s_search = 0 ƕύXB
// f_s_search = 0, s_box_pt = :	found
//      s_box[0],...,s_box[s_box_pt - 1] Aʒu
//      ̃y[WTƂ́Af_s_search = 1, ExapndPage() s
*/

BOOL IsSetSearchStr(void);
/* string ̃T[`Zbgς݂H
//
*/

int GetSearchLoc(int);

int IsTopSearchBox(int pos);
/*  Check if s_box[pos] for SearchString() corresponds to the top of string
*/

void PickUpString(int, int, int);
/* ---------------------------------------------------------------------- */
		/* History of previewed pages and DVI files */

#define	MAX_H_HIST	32	/* History of pages */
#define	MAX_F_HIST	16	/* History of files, should be an integer power of 2 */
#define	MAX_F_KEEP	16	/* History of files kept in a disk */
#define	MAX_F_MENU	9	/* files in a menu */
#define	PAGE_MARK	MAX_H_HIST
#define	RANGE_MARK	(MAX_H_HIST+1)
#define	F_HIST_EXT	"rec"
#define	F_LOG_EXT	"log"

extern struct HyperHistory h_hist[];
extern int h_hist_n;
extern int h_hist_pt;
extern int id_dvi;
extern int id_page;
extern int id_current_macro;

extern struct F_HIST f_hist[];
extern int f_hist_pt, f_hist0;
extern struct F_FMENU f_fmenu[];
extern char current_name[];
extern char *current_name_pt;

void WriteHistory(char *fname);
/* write the information of previewed DVI files in a FILE */

void ReadHistory(char *fname);
/* read the information of previewed DVI files from a FILE */

char *GetOutPath(char *ext);
/* get path name of the file with extension *ext */

char *GetHelpPath(void);

char *SearchFileHistory(char *fname, int *page);
/* Search dvi file *fname (allowed to be only filename without directory)
//  in File History and return full path name and set *page
// If not found, return NULL
*/

#define	HIST_ID_STR	"hist0"	/* ID in the file with the above information */

/* ------------------------------------------------------------------- */
/* Extra functions : See the Definitions */

char *GotoPage(int page);
/*  y[WړāÃy[WWJAe DIB `ɕϊĂ
//  AhXԂB݂Ɠy[WA邢͎s̏ꍇ NULL ԂB
//  ExpandPage(), MakeBMP() ŌĂ΂B
*/

int  ChgGray(int dif, int end);
char *GrayReverse(void);
char *nextpage(int num);
char *Blacker(void);
char *Whiter(void);
int  GetMagnification(void);

void ShowParameter(void);
void ShowBuffer(void);
void ShowInformation(void);
char *GetMessagePtr(void);
void ResetMessagePtr(void);

void GuessFont(char *, char *, char *, int);
BOOL AskYes(char *, char *);

#ifdef	RAWOUT
void PrintRaw(int, char **);
#endif

int  WinMinExecute(char **, int, BOOL);

extern char common_work[];

enum {
	SIZE_USR,
	SIZE_A3,
	SIZE_A4,
	SIZE_A5,
	SIZE_A6,
	SIZE_A7,
	SIZE_E3,
	SIZE_E4,
	SIZE_E5,
	SIZE_E6,
	SIZE_B3,
	SIZE_B4,
	SIZE_B5,
	SIZE_B6,
	SIZE_J1,
	SIZE_J2,
	SIZE_J3,
	SIZE_J4,
	SIZE_LEGAL,
	SIZE_GOVLEGAL,
	SIZE_LETTER,
	SIZE_HALFLETTER,
	SIZE_GOVLETTER,
	SIZE_EXECUTIVE,
	SIZE_PCARD,
	SIZE_SVGA,
	SIZE_XGA,
	SIZE_SXGA,
	SIZE_UVGA
};

extern int paper_type;
extern BOOL f_rotate;		/* TRUE if Landscape */
extern BOOL f_spcolor;
extern int f_rpcolor;
extern int f_ucolor;
extern int f_bcolor;
extern int f_b_bcolor;
extern int f_ccolor;
extern int bmp_pt;
extern char *option_str[];
extern int f_spsh;

#define	MAX_SCALE 4
typedef struct tagSCALE {
	short int x;
	short int y;
	short int gamma;
} SCALE;


#define	FCASH_VERSION	2
extern int f_path_cash;
extern int fcash_size;
extern int fcash_rev;
extern int fcash_ver;
extern int fcash_dev;
extern unsigned char *path_cash;
extern unsigned char *path_font;
extern BOOL f_fkeep;

extern char ptex_d;
extern BOOL f_ttout;
extern BOOL f_English;
extern int bright;
extern char *exec_para;
extern BOOL f_dvioutspecial;
extern BOOL f_srcspecial;
extern BOOL f_hypertex;
extern BOOL b_presentation_mode;
extern BOOL f_Expand;
extern BOOL f_use_etf;
extern int  f_FIT;

#define SM_LOG		0x1000				/* 4 */
#define	SM_ABREIG	(SM_LOG|1)			/* 0 */
#define	SM_OKEXIT	(SM_LOG|2)			/* 1 */
#define	SM_OKCONT	3					/* 3 */
#define	SM_EDIT		4					/* 2 */
#define	SM_EDITLOG	(SM_LOG|SM_EDIT)
#define	SM_OKLOG	(SM_LOF|SM_OKLOG)	/* 5 */
#define	SM_NOEDIT	6
#define	SM_YESNO	(SM_LOG|7)			/* 7 */

#define	WRONG_INT	0x1234fedc

#define	WMF			1
#define	F_WMF		(-16)
#define	F_EMF		(-17)
#define	F_BMP		(-18)

#define	F_ODD2EVEN	1
#define	F_2PAGE		2
#define	F_2DIB2		4
#define	F_2REV		8
#define	F_2VERT		0x10
#define	F_MPAGE		0x1000
#define	F_16PAGE	0x2000

#define	IS_ODD2EVEN	(f_2page&F_ODD2EVEN)	/* (ODD, EVEN)? */
#define	IS_2HORI	(f_2page&F_2PAGE)
#define	IS_2DIB2	(f_2page&F_2DIB2)		/* pDib2 is the former? */
#define	IS_2REV		(f_2page&F_2REV)
#define	IS_2VERT	(f_2page&F_2VERT)
#define	IS_2PAGE	(f_2page&(F_2PAGE|F_2VERT))
#define	IS_MPAGE	(f_2page&F_MPAGE)
#define	IS_16PAGE	(f_2page&F_16PAGE)

#define	F_DTHICK	8

void Free(void *);
void Free0(void *);
char *dup_string(char *);
int view_warning(int);
BOOL ChangeColor(unsigned char *, int);
void KeepPathCash(char *, int);
int get_path_cash(void);
void keep_font_path(void);
int ShowMessage(char *, char *, int);
void ShowPickedString(char *, char *);
BOOL IsJapanese(void);
void get_windows_directory(char *);
void sleep0(int);
void ReSetMetric(void);
void FlushPathCash(void);
int  AddKeepBMP(int);
unsigned char *PageDup(void);
void DisplayBMP(unsigned char*, int, int, int, int, int);
void jis2sjis(int *, int *);
BOOL WinWriteRule(int, int, int, int, int);
void WriteTTRule(int, int, int, int, int);
void TTBMPOut(int);
int get_rot_matrix(int);
BOOL IsAllTT(void);
int strsubcmp(char *, char *);
BOOL kpse_search(char *, char *);
unsigned short jistojms(unsigned short);
void touch(void);
BOOL SetPath(char *, char *);
int my_access(char *, int);
void ExecPrint(char *);
void Page2EMF(char *);
void ChooseTar(void);
int  DoMacro(char *, enum tagMACROMODE);
BOOL ExecMacro(int);
void InitMenuItems(void);
char *MareaPara(char *, int);
void GetPaperSize100(int *, int *);
void PostClearMacro(void);
void InitializeParameter(void);
int GetBackGround(void);
char *GetDPos2Source(unsigned int, int*);
char *GetWPos2Source(POINT *, int *);
char *GetNextSource(int, int *);
char *GetAddFile(char *);
void ResetFile(void);
void ClearFont(void);
void GetModuleName(char *);
void FreeETF(void);
char *LoadETF(char *);
void MessagePage(int);
void DisplayMessage(char *);
void ClearhBitmap(void);
void GSPN(char *, char *);
char *GetCommandResult(char *, int);
int GetNamePos(char *);
char *Language(int);
BOOL IsTopChar(char *, char *t);
int kpse_find(char *, char *, char *);
void TempMessage(char *, int);
#ifdef	UNIX
#define	StrStr(x,y)	strstr(s,y)
#define	chg_pathsep(x,y)
#else
char *StrStr(char *, char *);
void chg_pathsep(unsigned char *, char);
#endif
void SimplifyFname(char *);
void EditFile(char *);
char *GetFigurePath(int, int, int);
BOOL ToGSource(char *);
int CheckParaFile(char *fname, char *ask);
POINT GetCoverPos( void );
void SetCoverPos( int x, int y );
void SetCoverXPos( int x );
void SetCoverYPos( int y );
#endif // INC_INTER_H
